/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.mom.dest;

import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.agent.AgentServer;
import fr.dyade.aaa.agent.DeleteNot;
import fr.dyade.aaa.agent.Notification;
import fr.dyade.aaa.agent.UnknownAgent;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import org.objectweb.joram.mom.dest.ClusterAck;
import org.objectweb.joram.mom.dest.ClusterNot;
import org.objectweb.joram.mom.dest.ClusterTest;
import org.objectweb.joram.mom.dest.DestinationImpl;
import org.objectweb.joram.mom.dest.QueueImpl;
import org.objectweb.joram.mom.dest.TopicForwardNot;
import org.objectweb.joram.mom.dest.TopicImplMBean;
import org.objectweb.joram.mom.notifications.ClientMessages;
import org.objectweb.joram.mom.notifications.ExceptionReply;
import org.objectweb.joram.mom.notifications.FwdAdminRequestNot;
import org.objectweb.joram.mom.notifications.SubscribeReply;
import org.objectweb.joram.mom.notifications.SubscribeRequest;
import org.objectweb.joram.mom.notifications.TopicMsgsReply;
import org.objectweb.joram.mom.notifications.WakeUpNot;
import org.objectweb.joram.shared.admin.AdminReply;
import org.objectweb.joram.shared.admin.AdminRequest;
import org.objectweb.joram.shared.admin.GetClusterReply;
import org.objectweb.joram.shared.admin.GetClusterRequest;
import org.objectweb.joram.shared.admin.GetDMQSettingsReply;
import org.objectweb.joram.shared.admin.GetDMQSettingsRequest;
import org.objectweb.joram.shared.admin.GetFatherReply;
import org.objectweb.joram.shared.admin.GetFatherRequest;
import org.objectweb.joram.shared.admin.GetNumberReply;
import org.objectweb.joram.shared.admin.GetSubscriberIds;
import org.objectweb.joram.shared.admin.GetSubscriberIdsRep;
import org.objectweb.joram.shared.admin.GetSubscriptions;
import org.objectweb.joram.shared.admin.SetCluster;
import org.objectweb.joram.shared.admin.SetFather;
import org.objectweb.joram.shared.excepts.AccessException;
import org.objectweb.joram.shared.excepts.MomException;
import org.objectweb.joram.shared.messages.Message;
import org.objectweb.joram.shared.selectors.Selector;
import org.objectweb.util.monolog.api.BasicLevel;

public class TopicImpl
extends DestinationImpl
implements TopicImplMBean {
    private static final long serialVersionUID = 1L;
    protected AgentId fatherId = null;
    protected Set friends = null;
    protected Vector subscribers = new Vector();
    protected Hashtable selectors = new Hashtable();
    protected transient boolean alreadySentLocally;

    public TopicImpl(AgentId adminId, Properties prop) {
        super(adminId, prop);
    }

    public void initialize(boolean firstTime) {
    }

    public String toString() {
        return "TopicImpl:" + this.getId().toString();
    }

    public void wakeUpNot(WakeUpNot not) {
    }

    public void clusterTest(AgentId from, ClusterTest not) {
        String info = null;
        if (this.friends != null && !this.friends.isEmpty()) {
            if (this.friends.contains(from)) {
                info = this.strbuf.append("Topic [").append(this.getId()).append("] already joined cluster of topic [").append(from).append(']').toString();
                this.strbuf.setLength(0);
                this.friends.add(from);
                if (not.friends != null) {
                    this.friends.addAll(not.friends);
                }
                this.friends.remove(this.getId());
                this.forward(from, new ClusterAck(true, info, not.getReplyTo(), not.getRequestMsgId(), not.getReplyMsgId()));
            } else {
                info = this.strbuf.append("Topic [").append(this.getId()).append("] can't join cluster of topic [").append(from).append("] as it is already part of a cluster").toString();
                this.strbuf.setLength(0);
                this.forward(from, new ClusterAck(false, info, not.getReplyTo(), not.getRequestMsgId(), not.getReplyMsgId()));
            }
        } else if (this.fatherId != null) {
            info = this.strbuf.append("Topic [").append(this.getId()).append("] can't join cluster of topic [").append(from).append("] as it is already part of a hierarchy").toString();
            this.strbuf.setLength(0);
            this.forward(from, new ClusterAck(false, info, not.getReplyTo(), not.getRequestMsgId(), not.getReplyMsgId()));
        } else {
            this.setSave();
            this.friends = new HashSet();
            this.friends.add(from);
            if (not.friends != null) {
                this.friends.addAll(not.friends);
            }
            this.friends.remove(this.getId());
            info = this.strbuf.append("Topic [").append(this.getId()).append("] ok for joining cluster of topic [").append(from).append(']').toString();
            this.strbuf.setLength(0);
            this.forward(from, new ClusterAck(true, info, not.getReplyTo(), not.getRequestMsgId(), not.getReplyMsgId()));
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("Topic " + this.getId().toString() + " joins cluster of topic " + from.toString()));
            }
        }
    }

    public void clusterAck(AgentId from, ClusterAck ack) {
        if (!ack.ok) {
            this.replyToTopic(new AdminReply(7, ack.info), ack.getReplyTo(), ack.getRequestMsgId(), ack.getReplyMsgId());
        } else {
            this.setSave();
            ClusterNot newFriendNot = new ClusterNot(from);
            if (this.friends != null) {
                Iterator iterator = this.friends.iterator();
                while (iterator.hasNext()) {
                    this.forward((AgentId)iterator.next(), newFriendNot);
                }
            } else {
                this.friends = new HashSet();
            }
            this.friends.add(from);
            this.replyToTopic(new AdminReply(true, null), ack.getReplyTo(), ack.getRequestMsgId(), ack.getReplyMsgId());
        }
    }

    public void clusterNot(AgentId from, ClusterNot not) {
        this.setSave();
        if (not.topicId == null) {
            this.friends.remove(from);
            if (this.friends.isEmpty()) {
                this.friends = null;
            }
        } else if (!not.topicId.equals((Object)this.getId())) {
            this.friends.add(not.topicId);
        }
    }

    public void preSubscribe() {
    }

    public void postSubscribe() {
    }

    public void subscribeRequest(AgentId from, SubscribeRequest not) throws AccessException {
        if (!this.isReader(from)) {
            throw new AccessException("READ right not granted");
        }
        this.preSubscribe();
        this.setSave();
        if (!this.subscribers.contains(from)) {
            this.subscribers.add(from);
        }
        if (not.getSelector() != null && !not.getSelector().equals("")) {
            this.selectors.put(from, not.getSelector());
        } else {
            this.selectors.remove(from);
        }
        if (!not.isAsyncSub()) {
            this.forward(from, new SubscribeReply(not));
        }
        this.postSubscribe();
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Client " + from + " set as a subscriber with selector " + not.getSelector()));
        }
    }

    public void preUnsubscribe() {
    }

    public void postUnsubscribe() {
    }

    public void unsubscribeRequest(AgentId from) {
        this.preUnsubscribe();
        this.setSave();
        this.subscribers.remove(from);
        this.selectors.remove(from);
        this.postUnsubscribe();
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Client " + from + " removed from the subscribers."));
        }
    }

    public void topicForwardNot(TopicForwardNot not) {
        if (not.toFather && this.fatherId != null) {
            this.forward(this.fatherId, not);
            this.alreadySentLocally = this.fatherId.getTo() == AgentServer.getServerId();
        }
        this.processMessages(not.messages);
    }

    public void handleAdminRequestNot(AgentId from, FwdAdminRequestNot not) {
        AdminRequest adminRequest = not.getRequest();
        if (adminRequest instanceof GetSubscriberIds) {
            this.replyToTopic((AdminReply)new GetSubscriberIdsRep(this.getSubscriberIds()), not.getReplyTo(), not.getRequestMsgId(), not.getReplyMsgId());
        } else if (adminRequest instanceof GetSubscriptions) {
            this.replyToTopic((AdminReply)new GetNumberReply(this.getNumberOfSubscribers()), not.getReplyTo(), not.getRequestMsgId(), not.getReplyMsgId());
        } else if (adminRequest instanceof GetDMQSettingsRequest) {
            this.replyToTopic((AdminReply)new GetDMQSettingsReply(this.dmqId != null ? this.dmqId.toString() : null, 0), not.getReplyTo(), not.getRequestMsgId(), not.getReplyMsgId());
        } else if (adminRequest instanceof SetFather) {
            this.setSave();
            this.fatherId = AgentId.fromString((String)((SetFather)adminRequest).getFather());
            this.replyToTopic(new AdminReply(true, null), not.getReplyTo(), not.getRequestMsgId(), not.getReplyMsgId());
        } else if (adminRequest instanceof GetFatherRequest) {
            this.replyToTopic((AdminReply)new GetFatherReply(this.fatherId != null ? this.fatherId.toString() : null), not.getReplyTo(), not.getRequestMsgId(), not.getReplyMsgId());
        } else if (adminRequest instanceof GetClusterRequest) {
            Vector<String> cluster = null;
            if (this.friends != null) {
                cluster = new Vector<String>();
                Iterator iterator = this.friends.iterator();
                while (iterator.hasNext()) {
                    cluster.add(iterator.next().toString());
                }
                cluster.add(this.getId().toString());
            }
            this.replyToTopic((AdminReply)new GetClusterReply(cluster), not.getReplyTo(), not.getRequestMsgId(), not.getReplyMsgId());
        } else if (adminRequest instanceof SetCluster) {
            AgentId newFriendId = AgentId.fromString((String)((SetCluster)adminRequest).getTopId());
            if (newFriendId != null) {
                if (this.getId().equals((Object)newFriendId)) {
                    this.replyToTopic(new AdminReply(7, "Joining topic already part of the cluster"), not.getReplyTo(), not.getRequestMsgId(), not.getReplyMsgId());
                } else {
                    this.forward(newFriendId, new ClusterTest(this.friends, not.getReplyTo(), not.getRequestMsgId(), not.getReplyMsgId()));
                }
            } else {
                if (this.friends != null && !this.friends.isEmpty()) {
                    ClusterNot uncluster = new ClusterNot(null);
                    Iterator iterator = this.friends.iterator();
                    while (iterator.hasNext()) {
                        this.forward((AgentId)iterator.next(), uncluster);
                    }
                    this.friends = null;
                    this.setSave();
                }
                this.replyToTopic(new AdminReply(true, null), not.getReplyTo(), not.getRequestMsgId(), not.getReplyMsgId());
            }
        } else {
            super.handleAdminRequestNot(from, not);
        }
    }

    public final int getNumberOfSubscribers() {
        return this.subscribers.size();
    }

    public final String[] getSubscriberIds() {
        String[] res = new String[this.subscribers.size()];
        for (int i = 0; i < res.length; ++i) {
            AgentId aid = (AgentId)this.subscribers.elementAt(i);
            res[i] = aid.toString();
        }
        return res;
    }

    protected void doRightRequest(AgentId user, int right) {
        if (right != -READ) {
            return;
        }
        if (user != null) {
            this.setSave();
            this.subscribers.remove(user);
            this.selectors.remove(user);
            this.forward(user, new ExceptionReply((MomException)new AccessException("READ right removed.")));
        } else {
            Enumeration subs = this.subscribers.elements();
            while (subs.hasMoreElements()) {
                user = (AgentId)subs.nextElement();
                if (this.isReader(user)) continue;
                this.setSave();
                this.subscribers.remove(user);
                this.selectors.remove(user);
                this.forward(user, new ExceptionReply((MomException)new AccessException("READ right removed.")));
            }
        }
    }

    protected void doClientMessages(AgentId from, ClientMessages not) {
        ClientMessages clientMsgs = this.preProcess(from, not);
        if (clientMsgs != null) {
            this.forwardMessages(clientMsgs);
            this.processMessages(clientMsgs);
            this.postProcess(clientMsgs);
        }
    }

    protected void doUnknownAgent(UnknownAgent uA) {
        AgentId agId = uA.agent;
        Notification not = uA.not;
        if (not instanceof ClusterTest) {
            ClusterTest cT = (ClusterTest)not;
            this.replyToTopic(new AdminReply(7, "Joining topic doesn't exist"), cT.getReplyTo(), cT.getRequestMsgId(), cT.getReplyMsgId());
        } else {
            this.setSave();
            this.subscribers.remove(agId);
            this.selectors.remove(agId);
            if (agId.equals((Object)this.fatherId)) {
                this.fatherId = null;
            }
        }
    }

    protected void doDeleteNot(DeleteNot not) {
        for (int i = 0; i < this.subscribers.size(); ++i) {
            AgentId clientId = (AgentId)this.subscribers.get(i);
            this.forward(clientId, (Notification)new UnknownAgent(this.getId(), null));
        }
        if (this.friends != null) {
            Iterator iterator = this.friends.iterator();
            while (iterator.hasNext()) {
                this.forward((AgentId)iterator.next(), new ClusterNot(null));
            }
            this.friends = null;
        }
        this.setSave();
    }

    protected void forwardMessages(ClientMessages messages) {
        if (this.friends != null && !this.friends.isEmpty()) {
            for (AgentId topicId : this.friends) {
                this.forward(topicId, new TopicForwardNot(messages, false));
                if (!logger.isLoggable(BasicLevel.DEBUG)) continue;
                logger.log(BasicLevel.DEBUG, (Object)("Messages forwarded to fellow " + topicId.toString()));
            }
        } else if (this.fatherId != null) {
            this.forward(this.fatherId, new TopicForwardNot(messages, true));
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("Messages forwarded to father " + this.fatherId.toString()));
            }
        }
    }

    protected void processMessages(ClientMessages not) {
        Vector<Object> messages = not.getMessages();
        this.nbMsgsReceiveSinceCreation += (long)messages.size();
        this.setNoSave();
        boolean persistent = false;
        Enumeration subs = this.subscribers.elements();
        while (subs.hasMoreElements()) {
            Vector<Object> deliverables;
            AgentId subscriber = (AgentId)subs.nextElement();
            boolean local = subscriber.getTo() == AgentServer.getServerId();
            String selector = (String)this.selectors.get(subscriber);
            if (selector == null || selector.equals("")) {
                if (!local) {
                    deliverables = messages;
                    persistent = true;
                } else if (!this.alreadySentLocally) {
                    deliverables = messages;
                    this.alreadySentLocally = true;
                } else {
                    deliverables = new Vector();
                    Iterator msgs = messages.iterator();
                    while (msgs.hasNext()) {
                        deliverables.add(((Message)msgs.next()).clone());
                    }
                }
            } else {
                deliverables = new Vector<Object>();
                for (int i = 0; i < messages.size(); ++i) {
                    Message message = (Message)messages.get(i);
                    if (!Selector.matches((Message)message, (String)selector)) continue;
                    if (!local) {
                        deliverables.add(message);
                        persistent = true;
                        continue;
                    }
                    if (!this.alreadySentLocally) {
                        deliverables.add(message);
                        this.alreadySentLocally = true;
                        continue;
                    }
                    deliverables.add(message.clone());
                }
            }
            if (deliverables.isEmpty()) continue;
            TopicMsgsReply topicMsgsReply = new TopicMsgsReply(deliverables);
            topicMsgsReply.setPersistent(persistent);
            this.setDmq(topicMsgsReply);
            this.forward(subscriber, topicMsgsReply);
            this.nbMsgsDeliverSinceCreation += (long)deliverables.size();
        }
    }

    private void setDmq(TopicMsgsReply not) {
        if (this.dmqId != null) {
            not.setDMQId(this.dmqId);
        } else {
            not.setDMQId(QueueImpl.getDefaultDMQId());
        }
    }

    public void setAlreadySentLocally(boolean alreadySentLocally) {
        this.alreadySentLocally = alreadySentLocally;
    }

    public long getNbMsgsReceiveSinceCreation() {
        return this.nbMsgsReceiveSinceCreation;
    }
}

