/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.monolog.wrapper.javaLog;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.FileHandler;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Handler;
import org.objectweb.util.monolog.api.MonologFactory;
import org.objectweb.util.monolog.wrapper.common.RelatifEnvironmentPathGetter;
import org.objectweb.util.monolog.wrapper.javaLog.ConsoleHandler;
import org.objectweb.util.monolog.wrapper.javaLog.JMXHandler;
import org.objectweb.util.monolog.wrapper.javaLog.LevelImpl;
import org.objectweb.util.monolog.wrapper.javaLog.MonologFormatter;

public class GenericHandler
extends java.util.logging.Handler
implements Handler {
    public java.util.logging.Handler handler = null;
    protected String type;
    protected String name;
    Map attributes = new HashMap();

    public GenericHandler() {
    }

    public GenericHandler(String name) {
        this();
        this.name = name;
    }

    public GenericHandler(String name, String type) {
        this(name);
        this.type = type;
    }

    public GenericHandler(String name, java.util.logging.Handler h) {
        this(name);
        this.handler = h;
        if (h instanceof FileHandler) {
            this.type = "file";
        } else if (h instanceof ConsoleHandler) {
            this.type = "console";
        } else if (h instanceof JMXHandler) {
            this.type = "jmx";
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public String[] getAttributeNames() {
        return this.attributes.keySet().toArray(new String[0]);
    }

    public Object getAttribute(String n) {
        return this.attributes.get(n);
    }

    public Object setAttribute(String _name, Object value) {
        if (!_name.equalsIgnoreCase("activation")) {
            return this.attributes.put(_name, value);
        }
        if (this.type == null) {
            this.type = (String)this.attributes.get("handlertype");
        }
        MonologFactory mf = (MonologFactory)value;
        String output = (String)this.attributes.get("output");
        output = RelatifEnvironmentPathGetter.getRealPath(output);
        String pattern = (String)this.attributes.get("pattern");
        String level = (String)this.attributes.get("level");
        String append = (String)this.attributes.get("appendMode");
        String nbfile = (String)this.attributes.get("fileNumber");
        String fileSize = (String)this.attributes.get("maxSize");
        boolean appendVal = true;
        if (append != null && append.length() > 0) {
            appendVal = Boolean.getBoolean(append);
        }
        int levelVal = BasicLevel.DEBUG;
        if (level != null && level.length() > 0) {
            levelVal = org.objectweb.util.monolog.wrapper.common.LevelImpl.evaluate(level, mf);
        }
        if ("console".equalsIgnoreCase(this.type)) {
            this.handler = new ConsoleHandler();
            if (output != null && output.length() > 0) {
                if (output.equalsIgnoreCase("System.err")) {
                    ((ConsoleHandler)this.handler).setOutput(System.err);
                } else if (output.equalsIgnoreCase("switch")) {
                    ((ConsoleHandler)this.handler).activateSwitching();
                } else if (output.equalsIgnoreCase("System.out")) {
                    ((ConsoleHandler)this.handler).setOutput(System.out);
                }
            }
        } else if ("file".equalsIgnoreCase(this.type) || "rollingfile".equalsIgnoreCase(this.type)) {
            int limit = 0;
            if (fileSize != null && fileSize.length() > 0) {
                limit = Integer.parseInt(fileSize);
            }
            int count = 1;
            if (nbfile != null && nbfile.length() > 0) {
                count = Integer.parseInt(nbfile);
            }
            try {
                this.handler = new FileHandler(output, limit, count, appendVal);
            }
            catch (Exception e) {
                throw new IllegalStateException("Error when building the handler '" + this.name + "': " + e.getMessage());
            }
        } else if ("jmx".equalsIgnoreCase(this.type)) {
            this.handler = new JMXHandler();
        } else {
            throw new IllegalStateException("Error when building the handler '" + this.name + "': unknwon type: " + this.type);
        }
        this.handler.setFormatter(new MonologFormatter(pattern));
        this.handler.setLevel(LevelImpl.int2Level(levelVal));
        return null;
    }

    public void close() {
        this.handler.close();
    }

    public void flush() {
        this.handler.flush();
    }

    public String getEncoding() {
        return this.handler.getEncoding();
    }

    public Filter getFilter() {
        return this.handler.getFilter();
    }

    public Formatter getFormatter() {
        return this.handler.getFormatter();
    }

    public Level getLevel() {
        System.out.println("handler(" + this.name + ").getLevel(): " + this.handler.getLevel().getName());
        return this.handler.getLevel();
    }

    public boolean isLoggable(LogRecord record) {
        return this.handler.isLoggable(record);
    }

    public void publish(LogRecord record) {
        this.handler.publish(record);
    }

    public void setEncoding(String encoding) throws SecurityException, UnsupportedEncodingException {
        this.handler.setEncoding(encoding);
    }

    protected void setException(Exception exception) {
    }

    public void setFilter(Filter newFilter) {
        this.handler.setFilter(newFilter);
    }

    public void setFormatter(Formatter newFormatter) {
        this.handler.setFormatter(newFormatter);
    }

    public void setLevel(Level newLevel) {
        this.handler.setLevel(newLevel);
    }
}

