/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.deployment.ejb.xml;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.ow2.jonas.deployment.common.xml.AbsDescriptionElement;
import org.ow2.jonas.deployment.common.xml.DescriptionGroupXml;
import org.ow2.jonas.deployment.common.xml.TopLevelElement;
import org.ow2.jonas.deployment.ejb.xml.AssemblyDescriptor;
import org.ow2.jonas.deployment.ejb.xml.EnterpriseBeans;
import org.ow2.jonas.deployment.ejb.xml.Relationships;

public class EjbJar
extends AbsDescriptionElement
implements TopLevelElement,
DescriptionGroupXml {
    private static final int VERSION_INDEX = 3;
    private EnterpriseBeans enterpriseBeans = null;
    private Relationships relationships = null;
    private AssemblyDescriptor assemblyDescriptor = null;
    private String ejbClientJar = null;
    private String publicId = null;
    private String version = null;

    public String getPublicId() {
        return this.publicId;
    }

    public void setPublicId(String pid) {
        this.publicId = pid;
    }

    public String getVersion() {
        if (this.version != null) {
            return this.version;
        }
        if (this.publicId == null) {
            this.version = "2.1";
        } else {
            ArrayList<String> al = new ArrayList<String>();
            StringTokenizer st = new StringTokenizer(this.publicId, "//");
            while (st.hasMoreTokens()) {
                al.add(st.nextToken().trim());
            }
            String spec = (String)al.get(2);
            al.clear();
            st = new StringTokenizer(spec, " ");
            while (st.hasMoreTokens()) {
                al.add(st.nextToken().trim());
            }
            this.version = (String)al.get(3);
        }
        return this.version;
    }

    public void setVersion(String ver) {
        this.version = ver;
    }

    public EnterpriseBeans getEnterpriseBeans() {
        return this.enterpriseBeans;
    }

    public void setEnterpriseBeans(EnterpriseBeans enterpriseBeans) {
        this.enterpriseBeans = enterpriseBeans;
    }

    public Relationships getRelationships() {
        return this.relationships;
    }

    public void setRelationships(Relationships relationships) {
        this.relationships = relationships;
    }

    public AssemblyDescriptor getAssemblyDescriptor() {
        return this.assemblyDescriptor;
    }

    public void setAssemblyDescriptor(AssemblyDescriptor assemblyDescriptor) {
        this.assemblyDescriptor = assemblyDescriptor;
    }

    public String getEjbClientJar() {
        return this.ejbClientJar;
    }

    public void setEjbClientJar(String ejbClientJar) {
        this.ejbClientJar = ejbClientJar;
    }

    public String toXML(int indent) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.indent(indent));
        sb.append("<ejb-jar>\n");
        sb.append(this.xmlElement(this.getDescription(), "description", indent += 2));
        sb.append(this.xmlElement(this.getDisplayName(), "display-name", indent));
        sb.append(this.xmlElement(this.getIcon().getSmallIcon(), "small-icon", indent));
        sb.append(this.xmlElement(this.getIcon().getLargeIcon(), "large-icon", indent));
        if (this.enterpriseBeans != null) {
            sb.append(this.enterpriseBeans.toXML(indent));
        }
        if (this.relationships != null) {
            sb.append(this.relationships.toXML(indent));
        }
        if (this.assemblyDescriptor != null) {
            sb.append(this.assemblyDescriptor.toXML(indent));
        }
        sb.append(this.xmlElement(this.ejbClientJar, "ejb-client-jar", indent));
        sb.append(this.indent(indent -= 2));
        sb.append("</ejb-jar>\n");
        return sb.toString();
    }
}

