/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.container.mdb;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.EJBException;
import javax.ejb.Timer;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.InvalidPropertyException;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.UnavailableException;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.transaction.xa.XAResource;
import org.ow2.easybeans.api.EZBContainer;
import org.ow2.easybeans.api.FactoryException;
import org.ow2.easybeans.api.bean.EasyBeansMDB;
import org.ow2.easybeans.api.bean.info.IMethodInfo;
import org.ow2.easybeans.component.itf.JMSComponent;
import org.ow2.easybeans.container.info.MessageDrivenInfo;
import org.ow2.easybeans.container.mdb.EZBMessageEndPoint;
import org.ow2.easybeans.container.mdb.MDBFactory;
import org.ow2.easybeans.container.mdb.MDBListenerEndpointInvocationHandler;
import org.ow2.easybeans.resolver.api.EZBJNDIResolverException;
import org.ow2.easybeans.rpc.util.Hash;
import org.ow2.util.ee.metadata.ejbjar.impl.struct.JActivationConfigProperty;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.pool.api.PoolException;

public class MDBMessageEndPointFactory
extends MDBFactory
implements MessageEndpointFactory {
    public static final String DEFAULT_ACTIVATION_SPEC_NAME = "joramActivationSpec";
    public static final String DEFAULT_DESTINATION_TYPE = "javax.jms.Queue";
    public static final String DESTINATION_TYPE_PROPERTY = "destinationType";
    public static final String DESTINATION_PROPERTY = "destination";
    private static Log logger = LogFactory.getLog(MDBMessageEndPointFactory.class);
    private ActivationSpec activationSpec = null;
    private ResourceAdapter resourceAdapter = null;
    private JMSComponent jmsComponent = null;
    private Class<?> listenerInterface = null;
    private Map<Method, Boolean> transactedMethods = null;

    public MDBMessageEndPointFactory(String className, EZBContainer container, ActivationSpec activationSpec, ResourceAdapter resourceAdapter, JMSComponent jmsComponent) throws FactoryException {
        super(className, container);
        this.activationSpec = activationSpec;
        this.resourceAdapter = resourceAdapter;
        this.jmsComponent = jmsComponent;
        this.transactedMethods = new HashMap<Method, Boolean>();
    }

    public void init() throws FactoryException {
        super.init();
        String listenerInterfaceName = this.getMessageDrivenInfo().getMessageListenerInterface();
        if (listenerInterfaceName == null) {
            throw new FactoryException("No MessageListener interface found for MDB '" + this.getClassName() + "' of container '" + this.getContainer().getName() + "'");
        }
        try {
            this.listenerInterface = this.getContainer().getClassLoader().loadClass(listenerInterfaceName.replace("/", "."));
        }
        catch (ClassNotFoundException e) {
            throw new FactoryException("Cannot load MessageListener interface '" + listenerInterfaceName + "' found for MDB '" + this.getClassName() + "' of container '" + this.getContainer().getName() + "'");
        }
        this.initActivationSpec();
        this.validateActivationSpec();
        this.activate();
    }

    private void initActivationSpec() throws FactoryException {
        String messageDestinationLink;
        List<ActivationConfigProperty> properties = this.getMessageDrivenInfo().getActivationConfigProperties();
        if (properties == null) {
            properties = new ArrayList<ActivationConfigProperty>();
        }
        if ((messageDestinationLink = this.getMessageDrivenInfo().getMessageDestinationLink()) != null) {
            String jndiName = null;
            try {
                jndiName = this.getContainer().getConfiguration().getContainerJNDIResolver().getMessageDestinationJNDIUniqueName(messageDestinationLink);
            }
            catch (EZBJNDIResolverException e) {
                throw new FactoryException("Unable to resolve message destination link '" + messageDestinationLink + "' for bean '" + this.getBeanInfo().getName() + "'.", (Throwable)e);
            }
            properties.add((ActivationConfigProperty)new JActivationConfigProperty(DESTINATION_PROPERTY, jndiName));
            logger.info((Object)"Message destination link ''{0}'' resolved to ''{1}'' for bean ''{2}''", new Object[]{messageDestinationLink, jndiName, this.getBeanInfo().getName()});
        }
        boolean destinationFound = false;
        boolean destinationTypeFound = false;
        for (ActivationConfigProperty property : properties) {
            if (DESTINATION_TYPE_PROPERTY.equals(property.propertyName())) {
                destinationTypeFound = true;
            }
            if (!DESTINATION_PROPERTY.equals(property.propertyName())) continue;
            destinationFound = true;
        }
        if (!destinationTypeFound && destinationFound) {
            JActivationConfigProperty jActivationConfigProperty = new JActivationConfigProperty(DESTINATION_TYPE_PROPERTY, DEFAULT_DESTINATION_TYPE);
            properties.add((ActivationConfigProperty)jActivationConfigProperty);
            logger.warn((Object)"No ''{0}'' property found in the activation config, adding default value ''{1}'' for bean ''{2}''", new Object[]{DESTINATION_TYPE_PROPERTY, DEFAULT_DESTINATION_TYPE, this.getBeanInfo().getName()});
        }
        HashMap<String, String> activationConfigProperties = new HashMap<String, String>();
        for (ActivationConfigProperty property : properties) {
            activationConfigProperties.put(property.propertyName(), property.propertyValue());
        }
        logger.debug((Object)"Activation config properties are ''{0}''", new Object[]{activationConfigProperties});
        if (this.jmsComponent != null) {
            this.jmsComponent.updateActivationConfigProperties(activationConfigProperties);
            logger.debug((Object)"The JMS Component ''{0}'' may have updated the activation config properties. New values are: ''{1}''", new Object[]{this.jmsComponent, activationConfigProperties});
        }
        Set entrySet = activationConfigProperties.entrySet();
        for (Map.Entry entry : entrySet) {
            this.applyActivationSpecProperty((String)entry.getKey(), (String)entry.getValue());
        }
    }

    protected void applyActivationSpecProperty(String key, String value) throws FactoryException {
        String methodName = "set" + key.substring(0, 1).toUpperCase() + key.substring(1);
        Method m = null;
        try {
            m = this.activationSpec.getClass().getMethod(methodName, String.class);
        }
        catch (SecurityException e) {
            throw new FactoryException("Cannot get a method named '" + methodName + "' on activation spec object '" + this.activationSpec + "'.", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new FactoryException("Cannot get a method named '" + methodName + "' on activation spec object '" + this.activationSpec + "'.", (Throwable)e);
        }
        try {
            m.invoke((Object)this.activationSpec, value);
        }
        catch (IllegalArgumentException e) {
            throw new FactoryException("Cannot invoke method named '" + methodName + "' with value '" + value + "' on activation spec object '" + this.activationSpec + "'.", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new FactoryException("Cannot invoke method named '" + methodName + "' with value '" + value + "' on activation spec object '" + this.activationSpec + "'.", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new FactoryException("Cannot invoke method named '" + methodName + "' with value '" + value + "' on activation spec object '" + this.activationSpec + "'.", (Throwable)e);
        }
    }

    protected void validateActivationSpec() throws FactoryException {
        try {
            this.activationSpec.validate();
        }
        catch (InvalidPropertyException e) {
            throw new FactoryException("Cannot validate the validation spec object for bean '" + this.getBeanInfo().getName() + "'.", (Throwable)e);
        }
    }

    protected void activate() throws FactoryException {
        try {
            this.resourceAdapter.endpointActivation((MessageEndpointFactory)this, this.activationSpec);
        }
        catch (ResourceException e) {
            throw new FactoryException("Cannot activate the activationspec object and us (MessageEndPointFactory) on the resource adapter", (Throwable)e);
        }
    }

    public MessageEndpoint createEndpoint(XAResource xaResource) throws UnavailableException {
        return this.createInternalEndpoint(xaResource);
    }

    public EZBMessageEndPoint createInternalEndpoint(XAResource xaResource) throws UnavailableException {
        EasyBeansMDB easyBeansMDB = null;
        try {
            easyBeansMDB = (EasyBeansMDB)this.getPool().get();
        }
        catch (PoolException e) {
            throw new UnavailableException("Cannot get instance in the pool", (Throwable)e);
        }
        MDBListenerEndpointInvocationHandler handler = new MDBListenerEndpointInvocationHandler(this, easyBeansMDB, this.listenerInterface);
        EZBMessageEndPoint proxy = (EZBMessageEndPoint)Proxy.newProxyInstance(this.getContainer().getClassLoader(), new Class[]{this.listenerInterface, EZBMessageEndPoint.class}, (InvocationHandler)handler);
        easyBeansMDB.setXaResource(xaResource);
        return proxy;
    }

    protected void releaseEndPoint(EZBMessageEndPoint mdbMessageEndPoint) {
        try {
            this.getPool().release((Object)mdbMessageEndPoint.getEasyBeansMDB());
        }
        catch (PoolException e) {
            throw new IllegalStateException("Cannot release the given message end point", e);
        }
    }

    public boolean isDeliveryTransacted(Method method) throws NoSuchMethodException {
        Boolean isTransacted = this.transactedMethods.get(method);
        if (isTransacted != null) {
            return isTransacted;
        }
        MessageDrivenInfo messageDrivenInfo = (MessageDrivenInfo)this.getBeanInfo();
        List<IMethodInfo> methodInfos = messageDrivenInfo.getBusinessMethodsInfo();
        long methodHash = Hash.hashMethod(method);
        if (methodInfos != null) {
            for (IMethodInfo methodInfo : methodInfos) {
                long hashTempMethod = Hash.hashMethod(methodInfo.getName(), methodInfo.getDescriptor());
                if (methodHash != hashTempMethod) continue;
                boolean tmpBoolean = methodInfo.isTransacted();
                this.transactedMethods.put(method, tmpBoolean);
                return tmpBoolean;
            }
            this.transactedMethods.put(method, Boolean.FALSE);
        }
        return false;
    }

    public void stop() {
        super.stop();
        this.resourceAdapter.endpointDeactivation((MessageEndpointFactory)this, this.activationSpec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyTimeout(Timer timer) {
        EZBMessageEndPoint mdbMessageEndPoint = null;
        try {
            mdbMessageEndPoint = this.createInternalEndpoint(null);
        }
        catch (UnavailableException e) {
            throw new EJBException("Cannot get an endpoint for notifying the timeout", (Exception)((Object)e));
        }
        try {
            mdbMessageEndPoint.notifyTimeout(timer);
        }
        finally {
            this.releaseEndPoint(mdbMessageEndPoint);
        }
    }
}

