/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.engine;

import edu.emory.mathcs.backport.java.util.concurrent.Executor;
import edu.emory.mathcs.backport.java.util.concurrent.ExecutorService;
import edu.emory.mathcs.backport.java.util.concurrent.Executors;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadFactory;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicInteger;
import org.jacorb.notification.engine.TaskExecutor;
import org.jacorb.notification.interfaces.Disposable;
import org.jacorb.notification.util.DisposableManager;

public class DefaultTaskExecutor
implements TaskExecutor {
    private final Executor executor_;
    private final DisposableManager disposeHooks_ = new DisposableManager();

    public DefaultTaskExecutor(String string, int n, boolean bl) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            this.executor_ = new DirectExecutor();
        } else {
            DefaultThreadFactory defaultThreadFactory = new DefaultThreadFactory(string);
            ExecutorService executorService = bl ? Executors.newCachedThreadPool((ThreadFactory)defaultThreadFactory) : Executors.newFixedThreadPool((int)n, (ThreadFactory)defaultThreadFactory);
            this.executor_ = executorService;
        }
    }

    public DefaultTaskExecutor(String string, int n) {
        this(string, n, false);
    }

    public void dispose() {
        if (this.executor_ instanceof ExecutorService) {
            ((ExecutorService)this.executor_).shutdown();
            ((ExecutorService)this.executor_).shutdownNow();
        }
        this.disposeHooks_.dispose();
    }

    public void registerDisposable(Disposable disposable) {
        this.disposeHooks_.addDisposable(disposable);
    }

    public void execute(Runnable runnable) {
        this.executor_.execute(runnable);
    }

    private static final class DefaultThreadFactory
    implements ThreadFactory {
        private final AtomicInteger counter_ = new AtomicInteger(0);
        private final String name_;

        private DefaultThreadFactory(String string) {
            this.name_ = string;
        }

        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable);
            thread.setDaemon(true);
            thread.setName(this.name_ + "#" + this.counter_.getAndIncrement());
            return thread;
        }
    }

    private final class DirectExecutor
    implements Executor {
        private DirectExecutor() {
        }

        public void execute(Runnable runnable) {
            runnable.run();
        }
    }
}

