/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.ews.mapper;

import java.util.Vector;
import org.apache.axis.constants.Scope;
import org.apache.axis.utils.CLArgsParser;
import org.apache.axis.utils.CLOption;
import org.apache.axis.utils.CLOptionDescriptor;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.Messages;
import org.apache.axis.wsdl.gen.Parser;
import org.apache.axis.wsdl.gen.WSDL2;
import org.apache.ws.ews.mapper.J2eeEmitter;

public class WsdlToJ2ee
extends WSDL2 {
    protected static final int MAPPING_OPT = 109;
    protected static final int SERVER_OPT = 115;
    protected static final int SKELETON_DEPLOY_OPT = 83;
    protected static final int NAMESPACE_OPT = 78;
    protected static final int NAMESPACE_FILE_OPT = 102;
    protected static final int OUTPUT_OPT = 111;
    protected static final int SCOPE_OPT = 100;
    protected static final int TEST_OPT = 116;
    protected static final int PACKAGE_OPT = 112;
    protected static final int ALL_OPT = 97;
    protected static final int TYPEMAPPING_OPT = 84;
    protected static final int FACTORY_CLASS_OPT = 70;
    protected static final int HELPER_CLASS_OPT = 72;
    protected static final int USERNAME_OPT = 85;
    protected static final int PASSWORD_OPT = 80;
    protected boolean bPackageOpt = false;
    private J2eeEmitter emitter = (J2eeEmitter)this.parser;
    protected static final CLOptionDescriptor[] options = new CLOptionDescriptor[]{new CLOptionDescriptor("server-side", 8, 115, Messages.getMessage((String)"optionSkel00")), new CLOptionDescriptor("skeletonDeploy", 2, 83, Messages.getMessage((String)"optionSkeletonDeploy00")), new CLOptionDescriptor("NStoPkg", 48, 78, Messages.getMessage((String)"optionNStoPkg00")), new CLOptionDescriptor("fileNStoPkg", 2, 102, Messages.getMessage((String)"optionFileNStoPkg00")), new CLOptionDescriptor("package", 2, 112, Messages.getMessage((String)"optionPackage00")), new CLOptionDescriptor("output", 2, 111, Messages.getMessage((String)"optionOutput00")), new CLOptionDescriptor("deployScope", 2, 100, Messages.getMessage((String)"optionScope00")), new CLOptionDescriptor("testCase", 8, 116, Messages.getMessage((String)"optionTest00")), new CLOptionDescriptor("all", 8, 97, Messages.getMessage((String)"optionAll00")), new CLOptionDescriptor("typeMappingVersion", 2, 84, Messages.getMessage((String)"optionTypeMapping00")), new CLOptionDescriptor("factory", 2, 70, Messages.getMessage((String)"optionFactory00")), new CLOptionDescriptor("helperGen", 8, 72, Messages.getMessage((String)"optionHelper00")), new CLOptionDescriptor("user", 2, 85, Messages.getMessage((String)"optionUsername")), new CLOptionDescriptor("password", 2, 80, Messages.getMessage((String)"optionPassword")), new CLOptionDescriptor("mapping-file-path", 2, 109, "Choose a mapping file path for J2EE JAX-RPC mapping")};

    public WsdlToJ2ee() {
        this.addOptions(options);
    }

    protected Parser createParser() {
        return new J2eeEmitter();
    }

    protected void parseOption(CLOption option) {
        switch (option.getId()) {
            case 70: {
                this.emitter.setFactory(option.getArgument());
                break;
            }
            case 72: {
                this.emitter.setHelperWanted(true);
                break;
            }
            case 83: {
                this.emitter.setSkeletonWanted(JavaUtils.isTrueExplicitly((String)option.getArgument(0)));
            }
            case 115: {
                this.emitter.setServerSide(true);
                break;
            }
            case 78: {
                String namespace = option.getArgument(0);
                String packageName = option.getArgument(1);
                this.emitter.getNamespaceMap().put(namespace, packageName);
                break;
            }
            case 102: {
                this.emitter.setNStoPkg(option.getArgument());
                break;
            }
            case 112: {
                this.bPackageOpt = true;
                this.emitter.setPackageName(option.getArgument());
                break;
            }
            case 111: {
                this.emitter.setOutputDir(option.getArgument());
                break;
            }
            case 100: {
                String arg = option.getArgument();
                Scope scope = Scope.getScope((String)arg, null);
                if (scope != null) {
                    this.emitter.setScope(scope);
                    break;
                }
                System.err.println(Messages.getMessage((String)"badScope00", (String)arg));
                break;
            }
            case 116: {
                this.emitter.setTestCaseWanted(true);
                break;
            }
            case 97: {
                this.emitter.setAllWanted(true);
                break;
            }
            case 84: {
                String tmValue = option.getArgument();
                if (tmValue.equals("1.1")) {
                    this.emitter.setTypeMappingVersion("1.1");
                    break;
                }
                if (tmValue.equals("1.2")) {
                    this.emitter.setTypeMappingVersion("1.2");
                    break;
                }
                System.out.println(Messages.getMessage((String)"badTypeMappingOption00"));
                break;
            }
            case 85: {
                this.emitter.setUsername(option.getArgument());
                break;
            }
            case 80: {
                this.emitter.setPassword(option.getArgument());
                break;
            }
            case 109: {
                this.emitter.setMappingFilePath(option.getArgument());
                break;
            }
            default: {
                super.parseOption(option);
            }
        }
    }

    protected void validateOptions() {
        super.validateOptions();
        if (this.emitter.isSkeletonWanted() && !this.emitter.isServerSide()) {
            System.out.println(Messages.getMessage((String)"badSkeleton00"));
            this.printUsage();
        }
        if (!this.emitter.getNamespaceMap().isEmpty() && this.bPackageOpt) {
            System.out.println(Messages.getMessage((String)"badpackage00"));
            this.printUsage();
        }
    }

    protected void run(String[] args) {
        CLArgsParser argsParser = new CLArgsParser(args, options);
        if (null != argsParser.getErrorString()) {
            System.err.println(Messages.getMessage((String)"error01", (String)argsParser.getErrorString()));
            this.printUsage();
        }
        Vector clOptions = argsParser.getArguments();
        int size = clOptions.size();
        for (int i = 0; i < size; ++i) {
            this.parseOption((CLOption)clOptions.get(i));
        }
        this.validateOptions();
        try {
            this.parser.run(this.wsdlURI);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public static void main(String[] args) {
        WsdlToJ2ee j2ee = new WsdlToJ2ee();
        j2ee.run(args);
    }
}

