/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.medor.expression.parser.lib;

import org.objectweb.jorm.type.api.PTypeSpace;
import org.objectweb.medor.expression.api.Expression;
import org.objectweb.medor.expression.api.MalformedExpressionException;
import org.objectweb.medor.expression.api.Operator;
import org.objectweb.medor.expression.lib.Concat;
import org.objectweb.medor.expression.lib.Plus;
import org.objectweb.medor.expression.lib.TypeConverter;

public class ReplaceStringPlusByConcat {
    public Expression rewrite(Expression e) throws MalformedExpressionException {
        if (e instanceof Operator) {
            Operator op = (Operator)e;
            for (int i = op.getOperandNumber() - 1; i >= 0; --i) {
                op.setExpression(i, this.rewrite(op.getExpression(i)));
            }
            if (op instanceof Plus) {
                Expression left = op.getExpression(0);
                Expression right = op.getExpression(1);
                if (left.getType() == PTypeSpace.STRING || right.getType() == PTypeSpace.STRING) {
                    return new Concat(this.convertToString(left), this.convertToString(right));
                }
            }
        }
        return e;
    }

    private Expression convertToString(Expression e) throws MalformedExpressionException {
        return e.getType() == PTypeSpace.STRING ? e : new TypeConverter(e, PTypeSpace.STRING);
    }
}

