/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.mom.proxies.tcp;

import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.agent.AgentServer;
import fr.dyade.aaa.common.Debug;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.StringTokenizer;
import java.util.Vector;
import org.objectweb.joram.mom.proxies.ConnectionManager;
import org.objectweb.joram.mom.proxies.tcp.TcpConnection;
import org.objectweb.joram.mom.proxies.tcp.TcpConnectionListener;
import org.objectweb.joram.mom.proxies.tcp.TcpProxyServiceMBean;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class TcpProxyService
implements TcpProxyServiceMBean {
    public static Logger logger = Debug.getLogger((String)TcpProxyService.class.getName());
    public static final String SO_TIMEOUT_PROP = "org.objectweb.joram.mom.proxies.tcp.soTimeout";
    public static final int DEFAULT_SO_TIMEOUT = 10000;
    public static final String POOL_SIZE_PROP = "org.objectweb.joram.mom.proxies.tcp.poolSize";
    public static final int DEFAULT_POOL_SIZE = 1;
    public static final String BACKLOG_PROP = "org.objectweb.joram.mom.proxies.tcp.backlog";
    public static final int DEFAULT_BACKLOG = 10;
    public static final int DEFAULT_PORT = 16010;
    public static final String DEFAULT_BINDADDRESS = "0.0.0.0";
    private static final String MBEAN_NAME = "type=Connection,mode=tcp";
    private static TcpProxyService proxyService;
    int port;
    int backlog;
    String address;
    private ServerSocket serverSocket = null;
    private Vector connections;
    private TcpConnectionListener[] connectionListeners;
    private boolean activated = false;

    ServerSocket getServerSocket() {
        return this.serverSocket;
    }

    protected void resetServerSocket() {
        if (this.serverSocket == null) {
            return;
        }
        try {
            this.serverSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.serverSocket = null;
    }

    protected ServerSocket createServerSocket(int port, int backlog, String address) throws Exception {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("TcpProxyService.createServerSocket(" + port + ',' + backlog + ',' + address + ')'));
        }
        ServerSocket serverSocket = address.equals(DEFAULT_BINDADDRESS) ? new ServerSocket(port, backlog) : new ServerSocket(port, backlog, InetAddress.getByName(address));
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("TcpProxyService.createServerSocket serverSocket = " + serverSocket));
        }
        return serverSocket;
    }

    public static void init(String args, boolean firstTime) throws Exception {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("TcpProxyService.init(" + args + ',' + firstTime + ')'));
        }
        int port = 16010;
        String address = DEFAULT_BINDADDRESS;
        if (args != null) {
            StringTokenizer st = new StringTokenizer(args);
            port = Integer.parseInt(st.nextToken());
            if (st.hasMoreTokens()) {
                address = st.nextToken();
            }
        }
        int backlog = AgentServer.getInteger((String)BACKLOG_PROP, (int)10);
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("TcpProxyService.init() - binding to " + address + ", port " + port));
        }
        proxyService = new TcpProxyService(port, backlog, address);
        proxyService.start();
    }

    public static void stopService() {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"TcpProxyService.stop()");
        }
        proxyService.stop();
    }

    public TcpProxyService(int port, int backlog, String address) throws Exception {
        this.port = port;
        this.backlog = backlog;
        this.address = address;
        this.serverSocket = this.createServerSocket(port, backlog, address);
        int poolSize = AgentServer.getInteger((String)POOL_SIZE_PROP, (int)1);
        int timeout = AgentServer.getInteger((String)SO_TIMEOUT_PROP, (int)10000);
        this.connections = new Vector();
        this.connectionListeners = new TcpConnectionListener[poolSize];
        for (int i = 0; i < poolSize; ++i) {
            this.connectionListeners[i] = new TcpConnectionListener(this, timeout);
        }
    }

    protected void start() {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"TcpProxyService.start()");
        }
        ConnectionManager.getCurrentInstance().addManager(this);
        this.activate();
    }

    public String getMBeanName() {
        return MBEAN_NAME;
    }

    void registerConnection(TcpConnection tcpConnection) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("TcpProxyService.registerConnection(" + tcpConnection + ')'));
        }
        this.connections.addElement(tcpConnection);
    }

    void unregisterConnection(TcpConnection tcpConnection) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("TcpProxyService.unregisterConnection(" + tcpConnection + ')'));
        }
        this.connections.removeElement(tcpConnection);
    }

    TcpConnection getConnection(AgentId proxyId, int key) {
        for (int i = 0; i < this.connections.size(); ++i) {
            TcpConnection tc = (TcpConnection)this.connections.elementAt(i);
            if (tc.getProxyId() != proxyId || tc.getKey() != key) continue;
            return tc;
        }
        return null;
    }

    private void stop() {
        this.deactivate();
        this.closeAllConnections();
        ConnectionManager.getCurrentInstance().removeManager(this);
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"TcpProxyService.stoped.");
        }
    }

    public void activate() {
        block6: {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)"TcpProxyService.activate()");
            }
            try {
                if (this.serverSocket == null) {
                    this.serverSocket = this.createServerSocket(this.port, this.backlog, this.address);
                }
                for (int i = 0; i < this.connectionListeners.length; ++i) {
                    if (this.connectionListeners[i].isRunning()) continue;
                    this.connectionListeners[i].start();
                }
                this.activated = true;
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)"TcpProxyService.activated.");
                }
            }
            catch (Exception exc) {
                if (!logger.isLoggable(BasicLevel.ERROR)) break block6;
                logger.log(BasicLevel.ERROR, (Object)"TcpProxyService.activate()", (Throwable)exc);
            }
        }
    }

    public void closeAllConnections() {
        Vector stopList = (Vector)this.connections.clone();
        for (int i = 0; i < stopList.size(); ++i) {
            TcpConnection tc = (TcpConnection)stopList.elementAt(i);
            tc.close();
        }
    }

    public void deactivate() {
        for (int i = 0; i < this.connectionListeners.length; ++i) {
            this.connectionListeners[i].stop();
        }
        this.activated = false;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"TcpProxyService.activated = false");
        }
    }

    public boolean isActivated() {
        return this.activated;
    }

    public int getRunningConnectionsCount() {
        return this.connections.size();
    }

    public int getTcpListenersPoolSize() {
        return this.connectionListeners.length;
    }

    public String getServerAddress() {
        return this.address.toString();
    }

    public int getFailedLoginCount() {
        int failedCount = 0;
        for (int i = 0; i < this.connectionListeners.length; ++i) {
            failedCount += this.connectionListeners[i].getFailedLoginCount();
        }
        return failedCount;
    }

    public int getInitiatedConnectionCount() {
        int initCount = 0;
        for (int i = 0; i < this.connectionListeners.length; ++i) {
            initCount += this.connectionListeners[i].getInitiatedConnectionCount();
        }
        return initCount;
    }

    public int getProtocolErrorCount() {
        int errorCount = 0;
        for (int i = 0; i < this.connectionListeners.length; ++i) {
            errorCount += this.connectionListeners[i].getProtocolErrorCount();
        }
        return errorCount;
    }
}

