/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.pool.impl.enhanced;

import java.util.concurrent.Executor;
import org.ow2.util.pool.impl.enhanced.EnhancedPool;
import org.ow2.util.pool.impl.enhanced.ResizerType;
import org.ow2.util.pool.impl.enhanced.api.IPool;
import org.ow2.util.pool.impl.enhanced.api.thread.IReusableThread;
import org.ow2.util.pool.impl.enhanced.impl.thread.ThreadPool;
import org.ow2.util.pool.impl.enhanced.impl.util.ExecutorProvider;
import org.ow2.util.pool.impl.enhanced.internal.resizer.impl.shared.SharedResizerPoolThreadManager;
import org.ow2.util.pool.impl.enhanced.manager.IPoolManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnhancedPoolFactory {
    private IPool<IReusableThread> pool;

    public EnhancedPoolFactory(IPool<IReusableThread> pool) {
        this.pool = pool;
    }

    public <E> EnhancedPool<E> createEnhancedPool(IPoolManager<E> poolManager) {
        return this.createEnhancedPool(poolManager, false, true);
    }

    public <E> EnhancedPool<E> createEnhancedPool(IPoolManager<E> poolManager, boolean setSizeShared, boolean schedulerShared) {
        Executor executor = schedulerShared ? new ThreadPool(this.pool, 0L) : ExecutorProvider.SELF_THREAD_EXECUTOR;
        if (setSizeShared) {
            return new EnhancedPool<E>(poolManager, ResizerType.SHARED_ASYNCHRONOUS, new SharedResizerPoolThreadManager(this.pool), executor);
        }
        return new EnhancedPool<E>(poolManager, ResizerType.SIMPLE, null, executor);
    }
}

