/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.component.smartclient.message;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import org.ow2.easybeans.component.smartclient.api.Message;

public abstract class AbsMessage
implements Message {
    public ByteBuffer getMessage() {
        ByteBuffer subMessage = this.getSubMessage();
        int length = 6;
        if (subMessage != null) {
            length += subMessage.capacity();
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(length);
        byteBuffer.put((byte)1);
        byteBuffer.put(this.getOpCode());
        if (subMessage != null) {
            byteBuffer.putInt(subMessage.capacity());
        }
        if (subMessage != null) {
            subMessage.position(0);
            byteBuffer.put(subMessage);
        }
        byteBuffer.position(0);
        return byteBuffer;
    }

    public abstract byte getOpCode();

    public abstract ByteBuffer getSubMessage();

    protected ByteBuffer encode(String str) {
        byte[] bytes = null;
        try {
            bytes = str.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Invalid Encoding scheme", e);
        }
        ByteBuffer buffer = ByteBuffer.allocate(bytes.length);
        buffer.put(bytes);
        return buffer;
    }

    protected String decode(ByteBuffer buffer) {
        Charset charset = Charset.forName("UTF-8");
        CharsetDecoder charsetDecoder = charset.newDecoder();
        CharBuffer charBuffer = null;
        try {
            charBuffer = charsetDecoder.decode(buffer);
        }
        catch (CharacterCodingException e) {
            throw new IllegalStateException("Invalid characted encoding", e);
        }
        return charBuffer.toString();
    }
}

