/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jotm;

import java.nio.ByteBuffer;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Vector;
import javax.rmi.PortableRemoteObject;
import javax.transaction.InvalidTransactionException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionRolledbackException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import org.objectweb.howl.log.xa.XACommittingTx;
import org.objectweb.jotm.Current;
import org.objectweb.jotm.HeuristicRollback;
import org.objectweb.jotm.Resource;
import org.objectweb.jotm.SLog;
import org.objectweb.jotm.StatusHelper;
import org.objectweb.jotm.TraceTm;
import org.objectweb.jotm.TransactionImpl;
import org.objectweb.jotm.TransactionRecoveryImpl;
import org.objectweb.jotm.Xid;
import org.objectweb.jotm.XidImpl;

public class SubCoordinator
extends PortableRemoteObject
implements Resource {
    private TransactionImpl tx = null;
    private Vector synchroList = new Vector();
    private Vector resourceList = new Vector();
    private Vector javaxxidList = new Vector();
    private TransactionManager tm;
    private Xid xid = null;
    private SLog log = null;
    private int status = 0;
    private boolean beforeCompletionDone = false;
    static final String JOTM_RD_ONLY = "JOTM_RD_ONLY";
    static final byte[] RT1 = "RR1".getBytes();
    static final byte[] RT2 = "RR2".getBytes();
    static final byte[] JOTMDONE = "RR3JOTMDONE".getBytes();

    SubCoordinator(TransactionImpl tx, Xid xid) throws RemoteException {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("tx=" + tx + ",  xid=" + xid));
        }
        this.tx = tx;
        this.xid = xid;
        this.tm = Current.getTransactionManager();
        this.beforeCompletionDone = false;
    }

    public int prepare() throws RemoteException {
        block10: {
            if (TraceTm.jta.isDebugEnabled()) {
                TraceTm.jta.debug((Object)("status=" + StatusHelper.getStatusName(this.status)));
            }
            try {
                this.tx.doDetach(0x4000000);
            }
            catch (SystemException e) {
                if (!TraceTm.jta.isDebugEnabled()) break block10;
                String error = "Error when detaching XAResource:" + (Object)((Object)e) + "--" + e.getMessage();
                TraceTm.jta.debug((Object)error);
            }
        }
        switch (this.status) {
            case 1: {
                this.status = 9;
                return 1;
            }
            case 3: {
                return 0;
            }
        }
        this.doBeforeCompletion(true);
        if (this.status == 1) {
            TraceTm.jotm.info((Object)"Rollback during beforeCompletion in SubCoordinator.prepare");
            this.status = 9;
            return 1;
        }
        int ret = this.doPrepare();
        if (ret == 2) {
            this.doAfterCompletion();
        }
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("vote = " + ret));
        }
        return ret;
    }

    public void rollback() throws RemoteException {
        block9: {
            if (TraceTm.jta.isDebugEnabled()) {
                TraceTm.jta.debug((Object)("status=" + StatusHelper.getStatusName(this.status)));
            }
            try {
                this.tx.doDetach(0x4000000);
            }
            catch (SystemException e) {
                if (!TraceTm.jta.isDebugEnabled()) break block9;
                String error = "Error when detaching XAResource:" + (Object)((Object)e) + "--" + e.getMessage();
                TraceTm.jta.debug((Object)error);
            }
        }
        switch (this.status) {
            case 0: 
            case 1: 
            case 9: {
                if (!TraceTm.jotm.isDebugEnabled()) break;
                TraceTm.jotm.debug((Object)"transaction rolling back");
                break;
            }
            case 2: {
                if (!TraceTm.jotm.isDebugEnabled()) break;
                TraceTm.jotm.debug((Object)"should not rollback a prepared transaction");
                break;
            }
            case 4: {
                if (TraceTm.jotm.isDebugEnabled()) {
                    TraceTm.jotm.debug((Object)"already rolledback");
                }
                return;
            }
            default: {
                TraceTm.jotm.error((Object)("rollback: bad status: " + StatusHelper.getStatusName(this.status)));
                return;
            }
        }
        this.doBeforeCompletion(false);
        this.doRollback();
    }

    public void commit() throws RemoteException {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("status=" + StatusHelper.getStatusName(this.status)));
        }
        switch (this.status) {
            case 2: {
                break;
            }
            default: {
                TraceTm.jotm.error((Object)("commit: bad status: " + StatusHelper.getStatusName(this.status)));
                return;
            }
        }
        this.doCommit();
    }

    /*
     * Unable to fully structure code
     */
    public void commit_one_phase() throws RemoteException {
        block22: {
            if (TraceTm.jta.isDebugEnabled()) {
                TraceTm.jta.debug((Object)("status=" + StatusHelper.getStatusName(this.status)));
            }
            switch (this.status) {
                case 4: {
                    try {
                        this.tx.doDetach(0x4000000);
                    }
                    catch (SystemException e) {
                        if (!TraceTm.jta.isDebugEnabled()) ** GOTO lbl12
                        error = "Error when detaching XAResource:" + (Object)e + "--" + e.getMessage();
                        TraceTm.jta.debug((Object)error);
                    }
lbl12:
                    // 3 sources

                    throw new TransactionRolledbackException();
                }
                case 1: {
                    this.doBeforeCompletion(false);
                    try {
                        this.tx.doDetach(0x4000000);
                    }
                    catch (SystemException e) {
                        if (!TraceTm.jta.isDebugEnabled()) ** GOTO lbl22
                        error = "Error when detaching XAResource:" + (Object)e + "--" + e.getMessage();
                        TraceTm.jta.debug((Object)error);
                    }
lbl22:
                    // 3 sources

                    this.doRollback();
                    throw new TransactionRolledbackException();
                }
                case 3: {
                    try {
                        this.tx.doDetach(0x4000000);
                    }
                    catch (SystemException e) {
                        if (!TraceTm.jta.isDebugEnabled()) ** GOTO lbl32
                        error = "Error when detaching XAResource:" + (Object)e + "--" + e.getMessage();
                        TraceTm.jta.debug((Object)error);
                    }
lbl32:
                    // 3 sources

                    return;
                }
            }
            this.doBeforeCompletion(true);
            try {
                this.tx.doDetach(0x4000000);
            }
            catch (SystemException e) {
                if (!TraceTm.jta.isDebugEnabled()) break block22;
                error = "Error when detaching XAResource:" + (Object)e + "--" + e.getMessage();
                TraceTm.jta.debug((Object)error);
            }
        }
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("status=" + StatusHelper.getStatusName(this.status)));
        }
        if (this.status == 1) {
            TraceTm.jotm.info((Object)"Rollback during beforeCompletion in SubCoordinator.commit_one_phase");
            this.doRollback();
            throw new TransactionRolledbackException();
        }
        if (this.resourceList.size() == 1) {
            this.doOnePhaseCommit();
            return;
        }
        vote = this.doPrepare();
        switch (vote) {
            case 0: {
                this.doCommit();
                break;
            }
            case 2: {
                this.doAfterCompletion();
                break;
            }
            case 1: {
                this.doRollback();
                throw new TransactionRolledbackException();
            }
        }
    }

    public void forget() throws RemoteException {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)"SubCoordinator.forget()");
        }
        this.doForget();
    }

    public synchronized void addSynchronization(Synchronization synchro) throws RollbackException, IllegalStateException {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("synchro=" + synchro));
            TraceTm.jta.debug((Object)("status=" + StatusHelper.getStatusName(this.status)));
        }
        boolean markedRollback = false;
        switch (this.status) {
            case 1: 
            case 4: {
                markedRollback = true;
                break;
            }
            case 0: {
                break;
            }
            default: {
                String errorMsg = "addSynchronization: bad status = " + StatusHelper.getStatusName(this.status);
                TraceTm.jotm.error((Object)errorMsg);
                throw new IllegalStateException(errorMsg);
            }
        }
        this.synchroList.addElement(synchro);
        if (markedRollback) {
            if (TraceTm.jta.isDebugEnabled()) {
                TraceTm.jta.debug((Object)"SubCoordinator.addSynchronization: transaction rollback only");
            }
            throw new RollbackException();
        }
    }

    public synchronized boolean addResource(XAResource xares) throws IllegalStateException {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("xares=" + xares));
            TraceTm.jta.debug((Object)("status=" + StatusHelper.getStatusName(this.status)));
        }
        boolean markedRollback = false;
        switch (this.status) {
            case 1: {
                markedRollback = true;
                break;
            }
            case 0: {
                break;
            }
            default: {
                String errorMsg = "SubCoordinator.addResource: bad status= " + StatusHelper.getStatusName(this.status);
                TraceTm.jotm.error((Object)errorMsg);
                throw new IllegalStateException(errorMsg);
            }
        }
        boolean found = false;
        for (int i = 0; i < this.resourceList.size(); ++i) {
            XAResource res = (XAResource)this.resourceList.elementAt(i);
            try {
                if (!res.isSameRM(xares)) continue;
                found = true;
                break;
            }
            catch (XAException e) {
                String error = "Cannot send res.isSameRM:" + e + " (error code = " + e.errorCode + ") --" + e.getMessage();
                TraceTm.jotm.error((Object)("Exception on resource.isSameRM: " + error));
            }
        }
        if (!found) {
            if (TraceTm.jta.isDebugEnabled()) {
                TraceTm.jta.debug((Object)"new XAResource added to the list");
            }
            this.resourceList.addElement(xares);
        }
        if (markedRollback) {
            TraceTm.jta.debug((Object)"SubCoordinator.addResource: transaction set rollback only");
        }
        return found;
    }

    public synchronized void addJavaxXid(javax.transaction.xa.Xid javaxxid) {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("addJavaxXid javaxxid=" + javaxxid));
        }
        this.javaxxidList.addElement(javaxxid);
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)"new JavaxXid added to the list");
        }
    }

    public javax.transaction.xa.Xid getJavaxXid(int xaresindex) {
        javax.transaction.xa.Xid myjavaxxid = (javax.transaction.xa.Xid)this.javaxxidList.elementAt(xaresindex);
        return myjavaxxid;
    }

    public int getStatus() {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("status=" + StatusHelper.getStatusName(this.status)));
        }
        return this.status;
    }

    public void setRollbackOnly() {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("status=" + StatusHelper.getStatusName(this.status)));
        }
        switch (this.status) {
            case 0: 
            case 5: 
            case 7: {
                this.status = 1;
                break;
            }
            case 1: 
            case 9: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                TraceTm.jotm.error((Object)"Cannot set transaction as rollback only");
                TraceTm.jotm.error((Object)("Bad status=" + StatusHelper.getStatusName(this.status)));
            }
        }
    }

    private synchronized void doForget() throws RemoteException {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)"SubCoordinator.doForget()");
        }
        boolean exception = false;
        for (int i = 0; i < this.resourceList.size(); ++i) {
            XAResource xar = (XAResource)this.resourceList.elementAt(i);
            javax.transaction.xa.Xid myjavaxxid = (javax.transaction.xa.Xid)this.javaxxidList.elementAt(i);
            if (TraceTm.jta.isDebugEnabled()) {
                TraceTm.jta.debug((Object)("myjavaxxid= " + myjavaxxid));
                TraceTm.jta.debug((Object)("forgotten with resource= " + xar));
            }
            try {
                xar.forget(myjavaxxid);
                continue;
            }
            catch (XAException e) {
                String error = "Cannot send xar.forget:" + e + " (error code = " + e.errorCode + ") --" + e.getMessage();
                TraceTm.jotm.error((Object)("Got XAException from xar.forget: " + error));
                exception = true;
            }
        }
        if (exception) {
            throw new RemoteException("XAException on forget");
        }
        SubCoordinator.unexportObject((Remote)this);
    }

    private synchronized int doPrepare() throws RemoteException {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)"SubCoordinator.doPrepare()");
        }
        int ret = 2;
        int errors = 0;
        if (this.resourceList.size() == 0) {
            Current.getCurrent().incrementCommitCounter();
            this.status = 3;
            return ret;
        }
        this.log = new SLog();
        this.status = 7;
        for (int i = 0; i < this.resourceList.size(); ++i) {
            String error;
            XAResource res = (XAResource)this.resourceList.elementAt(i);
            javax.transaction.xa.Xid myjavaxxid = (javax.transaction.xa.Xid)this.javaxxidList.elementAt(i);
            XidImpl xid = new XidImpl(this.xid, i);
            if (errors > 0) {
                if (TraceTm.jta.isDebugEnabled()) {
                    TraceTm.jta.debug((Object)("xid=        " + xid));
                    TraceTm.jta.debug((Object)("myjavaxxid= " + myjavaxxid));
                    TraceTm.jta.debug((Object)("rolled back with resource= " + res));
                }
                try {
                    res.rollback(myjavaxxid);
                }
                catch (XAException e) {
                    error = "Cannot send res.rollback:" + e + " (error code = " + e.errorCode + ") --" + e.getMessage();
                    TraceTm.jotm.error((Object)("Got XAException from res.rollback: " + error));
                }
                continue;
            }
            if (TraceTm.jta.isDebugEnabled()) {
                TraceTm.jta.debug((Object)("xid=        " + xid));
                TraceTm.jta.debug((Object)("myjavaxxid= " + myjavaxxid));
                TraceTm.jta.debug((Object)("prepared with resource= " + res));
            }
            try {
                switch (res.prepare(myjavaxxid)) {
                    case 0: {
                        this.log.addResource(res, xid, myjavaxxid);
                        ret = 0;
                        if (!TraceTm.jta.isDebugEnabled()) break;
                        TraceTm.jta.debug((Object)"Prepare= XA_OK");
                        break;
                    }
                    case 3: {
                        if (!TraceTm.jta.isDebugEnabled()) break;
                        TraceTm.jta.debug((Object)"Prepare= XA_RDONLY");
                    }
                }
                continue;
            }
            catch (XAException e) {
                error = "Cannot send res.prepare:" + e + " (error code = " + e.errorCode + ") --" + e.getMessage();
                TraceTm.jotm.error((Object)("Got XAException from res.prepare: " + error));
                ret = 1;
                ++errors;
            }
        }
        switch (ret) {
            case 2: {
                Current.getCurrent().incrementCommitCounter();
                this.status = 3;
                if (!TraceTm.jta.isDebugEnabled()) break;
                TraceTm.jta.debug((Object)"VOTE_READONLY");
                break;
            }
            case 0: {
                this.status = 2;
                if (!TraceTm.jta.isDebugEnabled()) break;
                TraceTm.jta.debug((Object)"VOTE_COMMIT");
                break;
            }
            case 1: {
                this.status = 9;
                if (!TraceTm.jta.isDebugEnabled()) break;
                TraceTm.jta.debug((Object)"VOTE_ROLLBACK");
            }
        }
        return ret;
    }

    private synchronized int doCommit() throws RemoteException {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)"SubCoordinator.doCommit()");
        }
        if (this.log == null) {
            TraceTm.jotm.error((Object)"doCommit: no log");
            return -1;
        }
        boolean successfulcommit = true;
        int commitnb = 0;
        int heuristicnb = 0;
        List loggedResources = this.log.getLoggedResources();
        List byteloggedResources = this.log.getByteLoggedResources();
        List loggedXids = this.log.getLoggedXids();
        List loggedJavaxXids = this.log.getLoggedJavaxXids();
        XACommittingTx xaCommitTx = null;
        Object xaCommitTxRewrite = null;
        byte[][] recoveryBuffer = new byte[loggedResources.size() + 1][];
        byte[] recoveryRecord1 = null;
        byte[] recoveryRecord2 = null;
        ByteBuffer rr1 = null;
        ByteBuffer rr2 = null;
        byte[][] jotmDoneRecord = new byte[1][11];
        if (Current.getDefaultRecovery()) {
            Xid txxid = this.tx.getXid();
            int txxidfi = txxid.getFormatId();
            byte[] txxidgti = txxid.getGlobalTransactionId();
            byte[] txxidbq = txxid.getBranchQualifier();
            int txxidlength = 4 + txxidgti.length + txxidbq.length;
            int gridlen = txxidgti.length;
            int bqlen = txxidbq.length;
            String txdate = this.tx.getTxDate().toString();
            int txdatelength = txdate.length();
            long rcdate = System.currentTimeMillis();
            recoveryRecord1 = new byte[19 + gridlen + 4 + bqlen + 4 + txdatelength + 4];
            rr1 = ByteBuffer.wrap(recoveryRecord1);
            rr1.put(RT1);
            rr1.putLong(rcdate);
            rr1.putInt(txxidfi);
            rr1.putInt(txxidgti.length);
            rr1.put(txxidgti);
            rr1.putInt(txxidbq.length);
            rr1.put(txxidbq);
            rr1.putInt(txdatelength);
            rr1.put(txdate.getBytes());
            rr1.putInt(loggedResources.size());
            recoveryBuffer[0] = rr1.array();
            for (int i = 0; i < loggedResources.size(); ++i) {
                XAResource res = (XAResource)loggedResources.get(i);
                byte[] resname = (byte[])byteloggedResources.get(i);
                Xid xid = (Xid)loggedXids.get(i);
                int rmindex = 99;
                if (TraceTm.recovery.isDebugEnabled()) {
                    TraceTm.recovery.debug((Object)("recovery xid= " + xid));
                    TraceTm.recovery.debug((Object)("recovery resource= " + res));
                }
                int resnamelength = resname.length;
                String resclassname = res.getClass().getName();
                int resclassnamelength = resclassname.length();
                int xidfi = xid.getFormatId();
                byte[] xidgti = xid.getGlobalTransactionId();
                byte[] xidbq = xid.getBranchQualifier();
                int rr2gtilen = xidgti.length;
                int rr2bqlen = xidbq.length;
                recoveryRecord2 = new byte[11 + resnamelength + 4 + resclassnamelength + 4 + 4 + rr2gtilen + 4 + rr2bqlen + 4];
                rr2 = ByteBuffer.wrap(recoveryRecord2);
                rr2.put(RT2);
                rr2.putInt(rmindex);
                rr2.putInt(resnamelength);
                rr2.put(resname);
                rr2.putInt(resclassnamelength);
                rr2.put(resclassname.getBytes());
                rr2.putInt(xidfi);
                rr2.putInt(xidgti.length);
                rr2.put(xidgti);
                rr2.putInt(xidbq.length);
                rr2.put(xidbq);
                rr2.putInt(this.status);
                if (TraceTm.recovery.isDebugEnabled()) {
                    TraceTm.recovery.debug((Object)"Prepare Init RR2 to Recovery Buffer");
                }
                recoveryBuffer[i + 1] = rr2.array();
            }
            try {
                xaCommitTx = TransactionRecoveryImpl.getTransactionRecovery().howlCommitLog(recoveryBuffer);
            }
            catch (Exception e) {
                this.status = 4;
                String howlerror = "Cannot howlCommitLog:" + e + " --" + e.getMessage();
                TraceTm.jotm.error((Object)("Got LogException from howlCommitLog: " + howlerror));
                xaCommitTx = null;
                this.doAfterCompletion();
                this.log.forgetLog();
                throw new TransactionRolledbackException();
            }
        }
        this.status = 8;
        if (TraceTm.recovery.isDebugEnabled()) {
            TraceTm.recovery.debug((Object)"Status Committing");
        }
        for (int i = 0; i < loggedResources.size(); ++i) {
            block40: {
                XAResource res = (XAResource)loggedResources.get(i);
                javax.transaction.xa.Xid myjavaxxid = (javax.transaction.xa.Xid)loggedJavaxXids.get(i);
                Xid xid = (Xid)loggedXids.get(i);
                if (TraceTm.jta.isDebugEnabled()) {
                    TraceTm.jta.debug((Object)("xid=        " + xid));
                    TraceTm.jta.debug((Object)("myjavaxxid= " + myjavaxxid));
                    TraceTm.jta.debug((Object)("attempting commit with resource= " + res));
                }
                if (Current.getDefaultRecovery()) {
                    int rmindex = 99;
                    byte[] resname = (byte[])byteloggedResources.get(i);
                    int resnamelength = resname.length;
                    String resclassname = res.getClass().getName();
                    int resclassnamelength = resclassname.length();
                    int xidfi = xid.getFormatId();
                    byte[] xidgti = xid.getGlobalTransactionId();
                    byte[] xidbq = xid.getBranchQualifier();
                    int rr2gtilen = xidgti.length;
                    int rr2bqlen = xidbq.length;
                    recoveryRecord2 = new byte[11 + resnamelength + 4 + resclassnamelength + 4 + 4 + rr2gtilen + 4 + rr2bqlen + 4];
                    rr2 = ByteBuffer.wrap(recoveryRecord2);
                    rr2.put(RT2);
                    rr2.putInt(rmindex);
                    rr2.putInt(resnamelength);
                    rr2.put(resname);
                    rr2.putInt(resclassnamelength);
                    rr2.put(resclassname.getBytes());
                    rr2.putInt(xidfi);
                    rr2.putInt(xidgti.length);
                    rr2.put(xidgti);
                    rr2.putInt(xidbq.length);
                    rr2.put(xidbq);
                }
                try {
                    res.commit(myjavaxxid, false);
                    if (Current.getDefaultRecovery()) {
                        rr2.putInt(3);
                        if (TraceTm.recovery.isDebugEnabled()) {
                            TraceTm.recovery.debug((Object)"Status Committed");
                        }
                    }
                    ++commitnb;
                }
                catch (XAException e) {
                    switch (e.errorCode) {
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: {
                            if (TraceTm.jta.isDebugEnabled()) {
                                TraceTm.jta.debug((Object)("Heuristic condition= " + e.getMessage()));
                            }
                            if (!Current.getDefaultRecovery()) break;
                            rr2.putInt(5);
                            if (!TraceTm.recovery.isDebugEnabled()) break;
                            TraceTm.recovery.debug((Object)"Status Unknown");
                            break;
                        }
                        case -7: 
                        case -6: 
                        case -5: 
                        case -4: 
                        case -3: {
                            if (TraceTm.jta.isDebugEnabled()) {
                                TraceTm.jta.debug((Object)("RM error= " + e.getMessage()));
                            }
                            if (!Current.getDefaultRecovery()) break;
                            rr2.putInt(8);
                            if (!TraceTm.recovery.isDebugEnabled()) break;
                            TraceTm.recovery.debug((Object)"Status Committing");
                            break;
                        }
                        default: {
                            if (TraceTm.jta.isDebugEnabled()) {
                                TraceTm.jta.debug((Object)("Default error= " + e.getMessage()));
                            }
                            if (!Current.getDefaultRecovery()) break;
                            rr2.putInt(4);
                            if (!TraceTm.recovery.isDebugEnabled()) break;
                            TraceTm.recovery.debug((Object)"Status Rolledback");
                        }
                    }
                    String error = "Cannot send res.commit:" + e + " (error code = " + e.errorCode + ") --" + e.getMessage();
                    TraceTm.jotm.error((Object)("Got XAException from res.commit: " + error));
                    successfulcommit = false;
                    if (commitnb <= 0) break block40;
                    ++heuristicnb;
                }
            }
            if (!Current.getDefaultRecovery()) continue;
            if (TraceTm.recovery.isDebugEnabled()) {
                TraceTm.recovery.debug((Object)"Prepare New RR2 to Recovery Buffer");
            }
            recoveryBuffer[i + 1] = rr2.array();
        }
        if (successfulcommit) {
            Current.getCurrent().incrementCommitCounter();
            this.status = 3;
            if (TraceTm.recovery.isDebugEnabled()) {
                TraceTm.recovery.debug((Object)"Status Committed");
            }
            if (Current.getDefaultRecovery()) {
                try {
                    if (TraceTm.recovery.isDebugEnabled()) {
                        TraceTm.recovery.debug((Object)"Done howl log, all okay");
                    }
                    jotmDoneRecord[0] = JOTMDONE;
                    TransactionRecoveryImpl.getTransactionRecovery().howlDoneLog(jotmDoneRecord, xaCommitTx);
                }
                catch (Exception f) {
                    String howlerror = "Cannot howlDoneLog:" + f + "--" + f.getMessage();
                    TraceTm.jotm.error((Object)("Got LogException from howlDoneLog: " + howlerror));
                }
            }
            this.doAfterCompletion();
            this.log.forgetLog();
            if (TraceTm.jta.isDebugEnabled()) {
                TraceTm.jta.debug((Object)"SubCoordinator.doCommit(): EXIT 0");
            }
            return 0;
        }
        if (Current.getDefaultRecovery()) {
            try {
                if (TraceTm.recovery.isDebugEnabled()) {
                    TraceTm.recovery.debug((Object)"Rewrite HowlCommitLog");
                }
                TransactionRecoveryImpl.getTransactionRecovery().howlCommitLog(recoveryBuffer);
            }
            catch (Exception e) {
                this.status = 5;
                if (TraceTm.recovery.isDebugEnabled()) {
                    TraceTm.recovery.debug((Object)"Status Unknown");
                }
                String howlerror = "Cannot howlCommitLog:" + e + " --" + e.getMessage();
                TraceTm.jotm.error((Object)("Got LogException from howlCommitLog: " + howlerror));
                xaCommitTx = null;
                this.doAfterCompletion();
                this.log.forgetLog();
                throw new TransactionRolledbackException();
            }
            try {
                jotmDoneRecord[0] = JOTMDONE;
                TransactionRecoveryImpl.getTransactionRecovery().howlDoneLog(jotmDoneRecord, xaCommitTx);
            }
            catch (Exception f) {
                String howlerror = "Cannot howlDoneLog" + f + "--" + f.getMessage();
                TraceTm.jotm.error((Object)("Got LogException from howlDoneLog: " + howlerror));
            }
        }
        this.status = 5;
        if (TraceTm.recovery.isDebugEnabled()) {
            TraceTm.recovery.debug((Object)"Status Unknown");
        }
        this.doAfterCompletion();
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)"SubCoordinator.doCommit(): Exit -1");
        }
        return -1;
    }

    private synchronized void doOnePhaseCommit() throws RemoteException {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)"SubCoordinator.doOnePhaseCommit()");
        }
        this.status = 8;
        XAResource res = (XAResource)this.resourceList.elementAt(0);
        javax.transaction.xa.Xid myjavaxxid = (javax.transaction.xa.Xid)this.javaxxidList.elementAt(0);
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("myjavaxxid= " + myjavaxxid));
            TraceTm.jta.debug((Object)("one phase commit with resource= " + res));
        }
        try {
            res.commit(myjavaxxid, true);
            Current.getCurrent().incrementCommitCounter();
            this.status = 3;
        }
        catch (XAException e) {
            this.status = 5;
            String error = "Cannot send res.commit:" + e + " (error code = " + e.errorCode + ") --" + e.getMessage();
            TraceTm.jotm.error((Object)("Got XAException from res.commit: " + error));
            if (e.errorCode == 100) {
                throw new TransactionRolledbackException("XAException:" + error);
            }
            throw new RemoteException("XAException:" + error);
        }
        finally {
            this.doAfterCompletion();
        }
    }

    private synchronized void doRollback() throws RemoteException {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)"SubCoordinator.doRollback()");
        }
        this.status = 4;
        boolean heurroll = false;
        String heuristic = null;
        block6: for (int i = 0; i < this.resourceList.size(); ++i) {
            XAResource res = (XAResource)this.resourceList.elementAt(i);
            javax.transaction.xa.Xid myjavaxxid = (javax.transaction.xa.Xid)this.javaxxidList.elementAt(i);
            if (TraceTm.jta.isDebugEnabled()) {
                TraceTm.jta.debug((Object)("myjavaxxid= " + myjavaxxid));
                TraceTm.jta.debug((Object)("rolled back with resource= " + res));
            }
            try {
                res.rollback(myjavaxxid);
                continue;
            }
            catch (XAException e) {
                switch (e.errorCode) {
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        heuristic = "Heuristic condition= " + e.errorCode + "--" + e.getMessage();
                        TraceTm.jta.warn((Object)heuristic);
                        heurroll = true;
                        continue block6;
                    }
                    case -7: 
                    case -6: 
                    case -5: 
                    case -4: 
                    case -3: {
                        if (!TraceTm.jta.isDebugEnabled()) continue block6;
                        TraceTm.jta.debug((Object)("RM error= " + e.errorCode + "--" + e.getMessage()));
                        continue block6;
                    }
                    default: {
                        if (!TraceTm.jta.isDebugEnabled()) continue block6;
                        TraceTm.jta.debug((Object)("Default error= " + e.errorCode + "--" + e.getMessage()));
                    }
                }
            }
        }
        if (heurroll) {
            throw new HeuristicRollback(heuristic);
        }
        Current.getCurrent().incrementRollbackCounter();
        this.doAfterCompletion();
    }

    private void doBeforeCompletion(boolean committing) {
        block34: {
            if (TraceTm.jta.isDebugEnabled()) {
                TraceTm.jta.debug((Object)("doBeforeCompletion committing= " + committing));
            }
            if (this.beforeCompletionDone) {
                return;
            }
            this.tx.unsetTimer();
            if (committing && this.synchroList.size() > 0) {
                String error;
                boolean resumed;
                boolean suspended;
                Transaction mytx;
                block33: {
                    block32: {
                        block31: {
                            block30: {
                                mytx = null;
                                suspended = false;
                                resumed = false;
                                try {
                                    mytx = this.tm.getTransaction();
                                }
                                catch (SystemException e) {
                                    if (!TraceTm.jta.isDebugEnabled()) break block30;
                                    error = "Cannot get transaction:" + (Object)((Object)e) + "--" + e.getMessage();
                                    TraceTm.jta.debug((Object)error);
                                }
                            }
                            if (mytx != null && !mytx.equals(this.tx)) {
                                try {
                                    this.tm.suspend();
                                    suspended = true;
                                }
                                catch (SystemException e) {
                                    if (!TraceTm.jta.isDebugEnabled()) break block31;
                                    error = "Cannot suspend transaction:" + (Object)((Object)e) + "--" + e.getMessage();
                                    TraceTm.jta.debug((Object)error);
                                }
                            }
                        }
                        if (mytx == null || suspended) {
                            try {
                                this.tm.resume((Transaction)this.tx);
                                resumed = true;
                            }
                            catch (SystemException e) {
                                if (TraceTm.jta.isDebugEnabled()) {
                                    error = "Cannot resume transaction:" + (Object)((Object)e) + "--" + e.getMessage();
                                    TraceTm.jta.debug((Object)error);
                                }
                            }
                            catch (InvalidTransactionException e) {
                                if (TraceTm.jta.isDebugEnabled()) {
                                    error = "Cannot resume transaction:" + (Object)((Object)e) + "--" + e.getMessage();
                                    TraceTm.jta.debug((Object)error);
                                }
                            }
                            catch (IllegalStateException e) {
                                if (!TraceTm.jta.isDebugEnabled()) break block32;
                                error = "Cannot resume transaction:" + e + "--" + e.getMessage();
                                TraceTm.jta.debug((Object)error);
                            }
                        }
                    }
                    if (TraceTm.jta.isDebugEnabled()) {
                        TraceTm.jta.debug((Object)("sychronization list size= " + this.synchroList.size()));
                    }
                    for (int i = 0; i < this.synchroList.size(); ++i) {
                        Synchronization sync = (Synchronization)this.synchroList.elementAt(i);
                        if (TraceTm.jta.isDebugEnabled()) {
                            TraceTm.jta.debug((Object)("Calling Synchro " + sync));
                        }
                        try {
                            sync.beforeCompletion();
                            continue;
                        }
                        catch (RuntimeException e) {
                            this.status = 1;
                            if (!TraceTm.jta.isDebugEnabled()) continue;
                            String error2 = "Cannot sync.beforeCompletion:" + e + "--" + e.getMessage();
                            TraceTm.jta.debug((Object)error2);
                        }
                    }
                    if (resumed) {
                        try {
                            this.tm.suspend();
                        }
                        catch (SystemException e) {
                            if (!TraceTm.jta.isDebugEnabled()) break block33;
                            error = "Cannot suspend transaction:" + (Object)((Object)e) + "--" + e.getMessage();
                            TraceTm.jta.debug((Object)error);
                        }
                    }
                }
                if (suspended) {
                    try {
                        this.tm.resume(mytx);
                        resumed = true;
                    }
                    catch (SystemException e) {
                        if (TraceTm.jta.isDebugEnabled()) {
                            error = "Cannot resume transaction:" + (Object)((Object)e) + "--" + e.getMessage();
                            TraceTm.jta.debug((Object)error);
                        }
                    }
                    catch (InvalidTransactionException e) {
                        if (TraceTm.jta.isDebugEnabled()) {
                            error = "Cannot resume transaction:" + (Object)((Object)e) + "--" + e.getMessage();
                            TraceTm.jta.debug((Object)error);
                        }
                    }
                    catch (IllegalStateException e) {
                        if (!TraceTm.jta.isDebugEnabled()) break block34;
                        error = "Cannot resume transaction:" + e + "--" + e.getMessage();
                        TraceTm.jta.debug((Object)error);
                    }
                }
            }
        }
        this.beforeCompletionDone = true;
    }

    private void doAfterCompletion() {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)"doAfterCompletion()");
        }
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("sychronization list size= " + this.synchroList.size()));
        }
        for (int i = 0; i < this.synchroList.size(); ++i) {
            Synchronization sync = (Synchronization)this.synchroList.elementAt(i);
            if (TraceTm.jta.isDebugEnabled()) {
                TraceTm.jta.debug((Object)("Synchronization sync= " + sync));
                TraceTm.jta.debug((Object)("sync.afterCompletion status= " + StatusHelper.getStatusName(this.status)));
            }
            sync.afterCompletion(this.status);
        }
        Current.getCurrent().forgetTx(this.tx.getXid());
    }

    public int getXaresIndex(XAResource xares) {
        XAResource res;
        int i;
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("getXaresIndex xares= " + xares));
            TraceTm.jta.debug((Object)("resourceList.size= " + this.resourceList.size()));
        }
        int xaresIndex = -1;
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)"search xares with same obj ref");
        }
        for (i = 0; i < this.resourceList.size(); ++i) {
            res = (XAResource)this.resourceList.elementAt(i);
            if (TraceTm.jta.isDebugEnabled()) {
                TraceTm.jta.debug((Object)("res= " + res));
            }
            if (!res.equals(xares)) continue;
            xaresIndex = i;
            break;
        }
        if (xaresIndex == -1) {
            if (TraceTm.jta.isDebugEnabled()) {
                TraceTm.jta.debug((Object)"not found -> search for xares with same RM");
            }
            for (i = 0; i < this.resourceList.size(); ++i) {
                res = (XAResource)this.resourceList.elementAt(i);
                if (TraceTm.jta.isDebugEnabled()) {
                    TraceTm.jta.debug((Object)("res= " + res));
                }
                try {
                    if (!res.isSameRM(xares)) continue;
                    xaresIndex = i;
                    break;
                }
                catch (XAException e) {
                    if (!TraceTm.jta.isDebugEnabled()) continue;
                    String error = "res.isSameRm exception:" + e + "--" + e.getMessage();
                    TraceTm.jta.debug((Object)error);
                }
            }
        }
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("xaresIndex= " + xaresIndex));
        }
        return xaresIndex;
    }
}

