/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.component.jdbcpool;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.XAConnection;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.ow2.easybeans.component.jdbcpool.ConnectionManager;
import org.ow2.easybeans.component.jdbcpool.JConnection;
import org.ow2.easybeans.component.jdbcpool.JStatement;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class JManagedConnection
implements Comparable,
XAConnection,
XAResource,
Synchronization {
    private static Log logger = LogFactory.getLog(JManagedConnection.class);
    private Connection physicalConnection = null;
    private Connection implConn = null;
    private int pstmtmax = 0;
    private int psOpenNb = 0;
    private Vector<ConnectionEventListener> eventListeners = new Vector();
    private int open = 0;
    private int timeout = 0;
    private Transaction tx = null;
    private static int objcount = 0;
    private final int identifier;
    private int reUsedPreparedStatements = 0;
    private Map<String, JStatement> psList = null;
    private ConnectionManager ds = null;
    private long deathTime = 0L;
    private long closeTime = 0L;

    public JManagedConnection(Connection physicalConnection, ConnectionManager ds) {
        this.physicalConnection = physicalConnection;
        this.ds = ds;
        this.implConn = new JConnection(this, physicalConnection);
        this.open = 0;
        this.deathTime = System.currentTimeMillis() + ds.getMaxAgeMilli();
        this.identifier = objcount++;
        this.pstmtmax = ds.getPstmtMax();
        this.psOpenNb = 0;
        this.psList = Collections.synchronizedMap(new HashMap());
    }

    public int getIdentifier() {
        return this.identifier;
    }

    public void setPstmtMax(int max) {
        this.pstmtmax = max;
        if (this.psList == null) {
            this.psList = Collections.synchronizedMap(new HashMap(this.pstmtmax));
        }
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        logger.debug((Object)"XA-COMMIT for {0}", new Object[]{xid});
        try {
            this.physicalConnection.commit();
        }
        catch (SQLException e) {
            logger.error((Object)"Cannot commit transaction", new Object[]{e});
            this.notifyError(e);
            throw new XAException("Error on commit");
        }
    }

    public void end(Xid xid, int flags) throws XAException {
        logger.debug((Object)"XA-END for {0}", new Object[]{xid});
    }

    public void forget(Xid xid) throws XAException {
        logger.debug((Object)"XA-FORGET for {0}", new Object[]{xid});
    }

    public int getTransactionTimeout() throws XAException {
        logger.debug((Object)"getTransactionTimeout for {0}", new Object[]{this});
        return this.timeout;
    }

    public boolean isSameRM(XAResource xares) throws XAException {
        if (xares.equals(this)) {
            logger.debug((Object)"isSameRM = true {0}", new Object[]{this});
            return true;
        }
        logger.debug((Object)"isSameRM = false {0}", new Object[]{this});
        return false;
    }

    public int prepare(Xid xid) throws XAException {
        logger.debug((Object)"XA-PREPARE for {0}", new Object[]{xid});
        return 0;
    }

    public Xid[] recover(int flag) throws XAException {
        logger.debug((Object)"XA-RECOVER for {0}", new Object[]{this});
        return null;
    }

    public void rollback(Xid xid) throws XAException {
        logger.debug((Object)"XA-ROLLBACK for {0}", new Object[]{xid});
        try {
            if (this.physicalConnection.getAutoCommit()) {
                logger.error((Object)"Rollback called on XAResource with AutoCommit set", new Object[0]);
                throw new XAException(7);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"Cannot getAutoCommit", new Object[]{e});
            this.notifyError(e);
            throw new XAException("Error on getAutoCommit");
        }
        try {
            this.physicalConnection.rollback();
        }
        catch (SQLException e) {
            logger.error((Object)"Cannot rollback transaction", new Object[]{e});
            this.notifyError(e);
            throw new XAException("Error on rollback");
        }
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        logger.debug((Object)"setTransactionTimeout to {0} for {1}", new Object[]{seconds, this});
        this.timeout = seconds;
        return true;
    }

    public void start(Xid xid, int flags) throws XAException {
        logger.debug((Object)"XA-START for {0}", new Object[]{xid});
    }

    public XAResource getXAResource() throws SQLException {
        return this;
    }

    public int compareTo(Object o) {
        JManagedConnection other = (JManagedConnection)o;
        int diff = this.getReUsedPreparedStatements() - other.getReUsedPreparedStatements();
        if (diff == 0) {
            return this.getIdentifier() - other.getIdentifier();
        }
        return diff;
    }

    public int getReUsedPreparedStatements() {
        return this.reUsedPreparedStatements;
    }

    public Connection getConnection() throws SQLException {
        return this.implConn;
    }

    public void close() throws SQLException {
        if (this.physicalConnection != null) {
            this.physicalConnection.close();
        } else {
            logger.error((Object)"Connection already closed. Stack of this new close()", new Object[]{new Exception()});
        }
        this.physicalConnection = null;
        this.implConn = null;
    }

    public void addConnectionEventListener(ConnectionEventListener listener) {
        this.eventListeners.addElement(listener);
    }

    public void removeConnectionEventListener(ConnectionEventListener listener) {
        this.eventListeners.removeElement(listener);
    }

    public void beforeCompletion() {
    }

    public void afterCompletion(int status) {
        if (this.tx != null) {
            this.ds.freeConnections(this.tx);
        } else {
            logger.error((Object)"NO TX!", new Object[0]);
        }
    }

    public boolean isAged() {
        return this.deathTime < System.currentTimeMillis();
    }

    public boolean isOpen() {
        return this.open > 0;
    }

    public int getOpenCount() {
        return this.open;
    }

    public boolean inactive() {
        return this.open > 0 && this.tx == null && this.closeTime < System.currentTimeMillis();
    }

    public boolean isClosed() {
        return this.open <= 0;
    }

    public void hold() {
        ++this.open;
        this.closeTime = System.currentTimeMillis() + this.ds.getMaxOpenTimeMilli();
    }

    public boolean release() {
        --this.open;
        if (this.open < 0) {
            logger.warn((Object)"connection was already closed", new Object[0]);
            this.open = 0;
            return false;
        }
        if (this.tx == null && this.open > 0) {
            logger.error((Object)"connection-open counter overflow", new Object[0]);
            this.open = 0;
        }
        return true;
    }

    public void setTx(Transaction tx) {
        this.tx = tx;
    }

    public Transaction getTx() {
        return this.tx;
    }

    public void remove() {
        try {
            this.close();
        }
        catch (SQLException ign) {
            logger.error((Object)"Could not close Connection: ", new Object[]{ign});
        }
        this.tx = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        logger.debug((Object)"sql = {0}", new Object[]{sql});
        if (this.pstmtmax == 0) {
            return this.physicalConnection.prepareStatement(sql, resultSetType, resultSetConcurrency);
        }
        JStatement ps = null;
        Map<String, JStatement> map = this.psList;
        synchronized (map) {
            ps = this.psList.get(sql);
            if (ps != null) {
                if (!ps.isClosed()) {
                    logger.warn((Object)"reuse an open pstmt", new Object[0]);
                }
                ps.reuse();
                ++this.reUsedPreparedStatements;
            } else {
                PreparedStatement aps = this.physicalConnection.prepareStatement(sql, resultSetType, resultSetConcurrency);
                ps = new JStatement(aps, this, sql);
                this.psList.put(sql, ps);
            }
            ++this.psOpenNb;
        }
        return ps;
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.prepareStatement(sql, 1003, 1007);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyPsClose(JStatement ps) {
        logger.debug((Object)ps.getSql(), new Object[0]);
        Map<String, JStatement> map = this.psList;
        synchronized (map) {
            --this.psOpenNb;
            if (this.psList.size() >= this.pstmtmax) {
                JStatement lru = null;
                Iterator<JStatement> i = this.psList.values().iterator();
                while (i.hasNext()) {
                    lru = i.next();
                    if (!lru.isClosed()) continue;
                    i.remove();
                    lru.forget();
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyClose() {
        Map<String, JStatement> map = this.psList;
        synchronized (map) {
            if (this.psOpenNb > 0) {
                JStatement jst2 = null;
                for (JStatement jst2 : this.psList.values()) {
                    if (!jst2.forceClose()) continue;
                    --this.psOpenNb;
                }
                if (this.psOpenNb != 0) {
                    logger.warn((Object)"Bad psOpenNb value = {0}", new Object[]{this.psOpenNb});
                    this.psOpenNb = 0;
                }
            }
        }
        for (int i = 0; i < this.eventListeners.size(); ++i) {
            ConnectionEventListener l = this.eventListeners.elementAt(i);
            l.connectionClosed(new ConnectionEvent(this));
        }
    }

    public void notifyError(SQLException ex) {
        for (int i = 0; i < this.eventListeners.size(); ++i) {
            ConnectionEventListener l = this.eventListeners.elementAt(i);
            l.connectionErrorOccurred(new ConnectionEvent(this, ex));
        }
    }
}

