/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.component.mail;

import java.util.ArrayList;
import java.util.List;
import javax.mail.Address;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.ow2.easybeans.component.api.EZBComponentException;
import org.ow2.easybeans.component.itf.JavaMailComponent;
import org.ow2.easybeans.component.mail.Auth;
import org.ow2.easybeans.component.mail.MailAddress;
import org.ow2.easybeans.component.mail.MailItf;
import org.ow2.easybeans.component.mail.MimePart;
import org.ow2.easybeans.component.mail.Session;
import org.ow2.easybeans.component.mail.factory.AbsJavaMailRef;
import org.ow2.easybeans.component.mail.factory.JavaMailMimePartDataSourceRef;
import org.ow2.easybeans.component.mail.factory.JavaMailSessionRef;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MailComponent
implements JavaMailComponent {
    private Log logger = LogFactory.getLog(MailComponent.class);
    private Auth defaultAuth = null;
    private List<Session> sessionFactories = null;
    private List<MimePart> mimePartFactories = null;

    public void init() throws EZBComponentException {
    }

    public void start() throws EZBComponentException {
        for (MailItf factory : this.getAllFactories()) {
            AbsJavaMailRef javaMailRef = null;
            String jndiName = factory.getJNDIName();
            if (factory instanceof Session) {
                JavaMailSessionRef javamailSession = new JavaMailSessionRef();
                javaMailRef = javamailSession;
            } else if (factory instanceof MimePart) {
                JavaMailMimePartDataSourceRef mimePartDataSourceRef = new JavaMailMimePartDataSourceRef();
                javaMailRef = mimePartDataSourceRef;
                MimePart mimePart = (MimePart)factory;
                mimePartDataSourceRef.setSubject(mimePart.getSubject());
                ArrayList<InternetAddress> toAddresses = new ArrayList<InternetAddress>();
                ArrayList<InternetAddress> ccAddresses = new ArrayList<InternetAddress>();
                ArrayList<InternetAddress> bccAddresses = new ArrayList<InternetAddress>();
                for (MailAddress mail : mimePart.getMailAddresses()) {
                    InternetAddress address = null;
                    try {
                        address = new InternetAddress(mail.getName());
                    }
                    catch (AddressException e) {
                        throw new EZBComponentException("Cannot build an internet address with given value '" + mail.getName() + "'.", (Throwable)e);
                    }
                    if ("CC".equalsIgnoreCase(mail.getType())) {
                        ccAddresses.add(address);
                        continue;
                    }
                    if ("BCC".equalsIgnoreCase(mail.getType())) {
                        bccAddresses.add(address);
                        continue;
                    }
                    toAddresses.add(address);
                }
                mimePartDataSourceRef.setToRecipients(toAddresses.toArray(new Address[toAddresses.size()]));
                mimePartDataSourceRef.setCcRecipients(ccAddresses.toArray(new Address[ccAddresses.size()]));
                mimePartDataSourceRef.setBccRecipients(bccAddresses.toArray(new Address[bccAddresses.size()]));
            } else {
                throw new EZBComponentException("Unknown factory '" + factory + "'.");
            }
            javaMailRef.setName(factory.getName());
            javaMailRef.setJNDIName(jndiName);
            javaMailRef.setProperties(factory.getMailSessionProperties());
            Auth auth = factory.getAuth();
            if (auth == null) {
                auth = this.getAuth();
            }
            if (auth != null) {
                javaMailRef.setAuthName(auth.getUsername());
                javaMailRef.setAuthName(auth.getPassword());
            }
            try {
                new InitialContext().bind(jndiName, (Object)javaMailRef);
                this.logger.info((Object)"Binding {0} Mail factory with JNDI name {1}", new Object[]{javaMailRef.getType(), jndiName});
            }
            catch (NamingException e) {
                throw new EZBComponentException("Unable to bind the factory '" + factory + "' with JNDI name '" + jndiName + "'.", (Throwable)e);
            }
        }
    }

    public void stop() throws EZBComponentException {
        for (MailItf factory : this.getAllFactories()) {
            try {
                new InitialContext().unbind(factory.getJNDIName());
            }
            catch (NamingException e) {
                this.logger.error((Object)"Cannot unbind factory with name {0} and JNDI name {1}", new Object[]{factory.getName(), factory.getJNDIName()});
            }
        }
    }

    public void setAuth(Auth auth) {
        this.defaultAuth = auth;
    }

    public Auth getAuth() {
        return this.defaultAuth;
    }

    public List<MailItf> getAllFactories() {
        ArrayList<MailItf> factories = new ArrayList<MailItf>();
        if (this.sessionFactories != null) {
            factories.addAll(this.sessionFactories);
        }
        if (this.mimePartFactories != null) {
            factories.addAll(this.mimePartFactories);
        }
        return factories;
    }

    public void setSessions(List<Session> sessionFactories) {
        this.sessionFactories = sessionFactories;
    }

    public List<Session> getSessions() {
        return this.sessionFactories;
    }

    public void setMimeParts(List<MimePart> mimePartFactories) {
        this.mimePartFactories = mimePartFactories;
    }

    public List<MimePart> getMimeParts() {
        return this.mimePartFactories;
    }
}

