/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.cdi.weld.internal.standard;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.naming.NamingException;
import org.apache.AnnotationProcessor;

public class CDIAnnotationProcessor
implements AnnotationProcessor {
    private final Map<Class<?>, InjectionTarget<?>> injectionTargets;
    private final BeanManager manager;

    public CDIAnnotationProcessor(BeanManager manager) {
        this.manager = manager;
        this.injectionTargets = new ConcurrentHashMap();
    }

    public void processAnnotations(Object instance) throws IllegalAccessException, InvocationTargetException, NamingException {
        Class<?> clazz = instance.getClass();
        if (!this.injectionTargets.containsKey(clazz)) {
            this.injectionTargets.put(clazz, this.manager.createInjectionTarget(this.manager.createAnnotatedType(clazz)));
        }
        CreationalContext cc = this.manager.createCreationalContext(null);
        InjectionTarget<?> it = this.injectionTargets.get(clazz);
        it.inject(instance, cc);
    }

    public void postConstruct(Object arg0) throws IllegalAccessException, InvocationTargetException {
    }

    public void preDestroy(Object arg0) throws IllegalAccessException, InvocationTargetException {
    }
}

