/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.signing;

import aQute.bnd.service.Plugin;
import aQute.bnd.service.SignerPlugin;
import aQute.lib.osgi.Builder;
import aQute.lib.osgi.Jar;
import aQute.lib.osgi.Resource;
import aQute.libg.command.Command;
import aQute.libg.reporter.Reporter;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JartoolSigner
implements Plugin,
SignerPlugin {
    String keystore;
    String storetype;
    String path = "jarsigner";
    String storepass;
    String keypass;
    String sigFile;

    @Override
    public void setProperties(Map<String, String> map) {
        if (map.containsKey("keystore")) {
            this.keystore = map.get("keystore");
        }
        if (map.containsKey("storetype")) {
            this.storetype = map.get("storetype");
        }
        if (map.containsKey("storepass")) {
            this.storepass = map.get("storepass");
        }
        if (map.containsKey("keypass")) {
            this.keypass = map.get("keypass");
        }
        if (map.containsKey("path")) {
            this.path = map.get("path");
        }
        if (map.containsKey("sigFile")) {
            this.sigFile = map.get("sigFile");
        }
    }

    @Override
    public void setReporter(Reporter processor) {
    }

    @Override
    public void sign(Builder builder, String alias) throws Exception {
        File f = builder.getFile(this.keystore);
        if (!f.isFile()) {
            builder.error("Invalid keystore %s", f.getAbsolutePath());
            return;
        }
        Jar jar = builder.getJar();
        File tmp = File.createTempFile("signdjar", ".jar");
        tmp.deleteOnExit();
        jar.write(tmp);
        Command command = new Command();
        command.add(this.path);
        if (this.keystore != null) {
            command.add("-keystore");
            command.add(f.getAbsolutePath());
        }
        if (this.storetype != null) {
            command.add("-storetype");
            command.add(this.storetype);
        }
        if (this.keypass != null) {
            command.add("-keypass");
            command.add(this.keypass);
        }
        if (this.storepass != null) {
            command.add("-storepass");
            command.add(this.storepass);
        }
        if (this.sigFile != null) {
            command.add("-sigFile");
            command.add(this.sigFile);
        }
        command.add(tmp.getAbsolutePath());
        command.add(alias);
        builder.trace("Jarsigner command: %s", command);
        command.setTimeout(20L, TimeUnit.SECONDS);
        StringBuffer out = new StringBuffer();
        StringBuffer err = new StringBuffer();
        int exitValue = command.execute(System.in, (Appendable)out, (Appendable)err);
        if (exitValue != 0) {
            builder.error("Signing Jar out: %s\nerr: %s", out, err);
        } else {
            builder.trace("Signing Jar out: %s \nerr: %s", out, err);
        }
        Jar signed = new Jar(tmp);
        builder.addClose(signed);
        Map<String, Resource> dir = signed.getDirectories().get("META-INF");
        for (String path : dir.keySet()) {
            if (!path.matches(".*\\.(DSA|RSA|SF|MF)$")) continue;
            jar.putResource(path, dir.get(path));
        }
        jar.setDoNotTouchManifest();
    }

    StringBuffer collect(final InputStream in) throws Exception {
        final StringBuffer sb = new StringBuffer();
        Thread tin = new Thread(){

            public void run() {
                try {
                    BufferedReader rdr = new BufferedReader(new InputStreamReader(in));
                    String line = rdr.readLine();
                    while (line != null) {
                        sb.append(line);
                        line = rdr.readLine();
                    }
                    rdr.close();
                    in.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        tin.start();
        return sb;
    }
}

