/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.web.tomcat6.osgi.httpservice;

import java.io.File;
import java.util.Dictionary;
import java.util.Enumeration;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.startup.ContextConfig;
import org.osgi.framework.Bundle;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.NamespaceException;
import org.ow2.jonas.lib.management.javaee.J2eeObjectName;
import org.ow2.jonas.web.JWebContainerServiceException;
import org.ow2.jonas.web.base.osgi.httpservice.DefaultHttpContextImpl;
import org.ow2.jonas.web.base.osgi.httpservice.JOnASHttpService;
import org.ow2.jonas.web.base.osgi.httpservice.OSGIResourcesServlet;
import org.ow2.jonas.web.tomcat6.Tomcat6Service;
import org.ow2.jonas.web.tomcat6.osgi.httpservice.OSGIContext;
import org.ow2.jonas.web.tomcat6.osgi.httpservice.OSGIWrapper;
import org.ow2.jonas.web.tomcat6.versioning.ContextFinder;

public class HttpServiceImpl
implements JOnASHttpService {
    private final Bundle callerBundle;
    private final Tomcat6Service tomcatService;
    private final String workDir;

    public HttpServiceImpl(Bundle bundle, Tomcat6Service tomcat6Service, String workDir) {
        this.callerBundle = bundle;
        this.tomcatService = tomcat6Service;
        this.workDir = workDir;
    }

    public HttpContext createDefaultHttpContext() {
        return new DefaultHttpContextImpl(this.callerBundle);
    }

    public void registerResources(String alias, String name, HttpContext httpContext) throws NamespaceException, IllegalArgumentException {
        HttpContext context = null;
        context = httpContext == null ? this.createDefaultHttpContext() : httpContext;
        OSGIResourcesServlet servlet = new OSGIResourcesServlet(context, name);
        try {
            this.registerServlet(alias, (Servlet)servlet, null, context);
        }
        catch (ServletException e) {
            e.printStackTrace();
        }
    }

    public void registerServlet(String alias, Servlet servlet, Dictionary initParams, HttpContext context) throws ServletException, NamespaceException, IllegalArgumentException {
        if (!this.checkAlias(alias)) {
            throw new IllegalArgumentException(alias + " is not a valid alias.");
        }
        String versionID = null;
        String userURI = null;
        String contextRoot = alias;
        if (this.tomcatService.isVersioningEnabled()) {
            versionID = this.getVersionId();
            if (!contextRoot.contains(versionID)) {
                userURI = contextRoot;
                contextRoot = contextRoot + versionID;
            } else {
                userURI = contextRoot.replace(versionID, "");
            }
        }
        if (context == null) {
            context = this.createDefaultHttpContext();
        }
        OSGIContext osgiContext = new OSGIContext(context, this.callerBundle);
        osgiContext.setPath(contextRoot);
        osgiContext.setName(contextRoot);
        osgiContext.setTomcatService(this.tomcatService);
        osgiContext.setJ2EEServer(this.tomcatService.getJonasServerName());
        osgiContext.setServer(J2eeObjectName.J2EEServer((String)this.tomcatService.getDomainName(), (String)this.tomcatService.getJonasServerName()).toString());
        osgiContext.setDocBase(new File(this.workDir).getAbsolutePath());
        ContextConfig config = new ContextConfig();
        osgiContext.addLifecycleListener(config);
        OSGIWrapper osgiWrapper = new OSGIWrapper(servlet, context);
        osgiWrapper.setName(servlet.getClass().getName());
        osgiWrapper.setParentClassLoader(servlet.getClass().getClassLoader());
        if (initParams != null) {
            Enumeration elements = initParams.keys();
            while (elements.hasMoreElements()) {
                String name = (String)elements.nextElement();
                osgiWrapper.addInitParameter(name, (String)initParams.get(name));
            }
        }
        servlet.init((ServletConfig)osgiWrapper);
        osgiContext.addChild(osgiWrapper);
        osgiContext.addServletMapping("/*", osgiWrapper.getName());
        Host host = this.tomcatService.findHost("");
        if (this.findContext(host, contextRoot) != null) {
            throw new NamespaceException(contextRoot + " already registered.");
        }
        host.addChild(osgiContext);
        try {
            if (this.tomcatService.isVersioningEnabled() && userURI != null) {
                String policy = this.tomcatService.getVersioningService().getDefaultDeploymentPolicy();
                ContextFinder.bindContextRoot(this.callerBundle.getSymbolicName(), userURI, osgiContext, policy);
            }
            ContextFinder.addNonVersionedContext(contextRoot);
        }
        catch (Exception e) {
            throw new JWebContainerServiceException("Failed binding versioned web context", (Throwable)e);
        }
    }

    public void unregister(String alias) throws IllegalArgumentException {
        Host host;
        Context ctx;
        if (!this.checkAlias(alias)) {
            throw new IllegalArgumentException(alias + " is not a valid alias.");
        }
        String versionID = null;
        if (this.tomcatService.isVersioningEnabled()) {
            versionID = this.getVersionId();
        }
        String contextRoot = alias;
        if (versionID != null && !contextRoot.contains(versionID)) {
            contextRoot = contextRoot + versionID;
        }
        if ((ctx = this.findContext(host = this.tomcatService.findHost(""), contextRoot)) == null) {
            throw new IllegalArgumentException(contextRoot + " is not registered.");
        }
        if (!(ctx instanceof OSGIContext) || !((OSGIContext)ctx).getCallerBundle().equals(this.callerBundle)) {
            throw new IllegalArgumentException(contextRoot + " is not registered by this bundle " + this.callerBundle + ".");
        }
        host.removeChild(ctx);
        if (this.tomcatService.isVersioningEnabled()) {
            ContextFinder.unbindContextRoot(contextRoot);
        }
        ContextFinder.removeNonVersionedContext(contextRoot);
    }

    public void stop() {
        Host host = this.tomcatService.findHost("");
        for (Container container : host.findChildren()) {
            if (!(container instanceof OSGIContext) || !this.callerBundle.equals(((OSGIContext)container).getCallerBundle())) continue;
            host.removeChild(container);
        }
    }

    private Context findContext(Host host, String alias) {
        for (Container container : host.findChildren()) {
            if (!(container instanceof Context) || !alias.equals(((Context)container).getPath())) continue;
            return (Context)container;
        }
        return null;
    }

    private boolean checkAlias(String alias) {
        if (alias == null) {
            return false;
        }
        if (alias.equals("/")) {
            return true;
        }
        return alias.startsWith("/") && !alias.endsWith("/");
    }

    private String getVersionId() {
        String SNAPSHOT_WITH_DOT = ".SNAPSHOT";
        String SNAPSHOT_WITH_HYPHEN = "-SNAPSHOT";
        String bundleVersion = (String)this.callerBundle.getHeaders().get("Bundle-Version");
        if (bundleVersion.endsWith(".SNAPSHOT")) {
            bundleVersion = bundleVersion.substring(0, bundleVersion.length() - ".SNAPSHOT".length()) + "-SNAPSHOT";
        }
        return "-" + bundleVersion;
    }
}

