/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.deployablemonitor;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.ow2.jonas.datasource.deploy.deployable.api.DatasourceDeployable;
import org.ow2.jonas.deployablemonitor.DeployableMonitorException;
import org.ow2.jonas.deployablemonitor.DeployableMonitorService;
import org.ow2.jonas.deployablemonitor.ExclusionFilenameFilter;
import org.ow2.jonas.deployablemonitor.LexicographicallyFileComparator;
import org.ow2.util.archive.api.IArchive;
import org.ow2.util.archive.impl.ArchiveManager;
import org.ow2.util.ee.deploy.api.deployable.EARDeployable;
import org.ow2.util.ee.deploy.api.deployable.EJBDeployable;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.api.deployable.OSGiDeployable;
import org.ow2.util.ee.deploy.api.deployable.RARDeployable;
import org.ow2.util.ee.deploy.api.deployable.WARDeployable;
import org.ow2.util.ee.deploy.api.deployer.DeployerException;
import org.ow2.util.ee.deploy.api.deployer.IDeployerManager;
import org.ow2.util.ee.deploy.api.deployer.UnsupportedDeployerException;
import org.ow2.util.ee.deploy.impl.helper.DeployableHelper;
import org.ow2.util.ee.deploy.impl.helper.DeployableHelperException;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.plan.deploy.deployable.api.DeploymentPlanDeployable;
import org.ow2.util.plan.deploy.deployable.api.RepositoryDeployable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeployableMonitor
extends Thread {
    private static Log logger = LogFactory.getLog(DeployableMonitor.class);
    private List<File> directories = new LinkedList<File>();
    private boolean developmentMode = false;
    private int monitorInterval;
    private boolean stopped = false;
    private Map<File, Long> modifiedFiles = new WeakHashMap<File, Long>();
    private Map<File, IDeployable<?>> deployed = new ConcurrentHashMap();
    private Map<File, Long> fileLengths = new HashMap<File, Long>();
    private List<File> failed = new ArrayList<File>();
    private IDeployerManager deployerManager = null;
    private boolean firstCheck = true;
    private ExclusionFilenameFilter filter = new ExclusionFilenameFilter();
    private DeployableMonitorService myService = null;

    public DeployableMonitor(DeployableMonitorService service) {
        this.myService = service;
    }

    public void reset() {
        if (this.firstCheck) {
            return;
        }
        this.modifiedFiles.clear();
        this.deployed.clear();
        this.fileLengths.clear();
        for (File deployDirectory : this.directories) {
            File[] files = deployDirectory.listFiles(this.filter);
            if (files == null) continue;
            for (File file : files) {
                try {
                    IDeployable deployable;
                    IArchive archive = ArchiveManager.getInstance().getArchive((Object)file);
                    if (archive == null || !this.deployerManager.isDeployed(deployable = DeployableHelper.getDeployable((IArchive)archive))) continue;
                    this.deployed.put(file, deployable);
                    this.fileLengths.put(file, DeployableMonitor.getFileSize(file));
                    this.hasBeenUpdated(file);
                }
                catch (Throwable t) {
                    logger.warn((Object)"Cannot reset file {0}", new Object[]{file, t});
                }
            }
        }
    }

    @Override
    public void run() {
        while (!this.stopped) {
            if (this.developmentMode || this.firstCheck) {
                this.saveFileLengths();
                try {
                    Thread.sleep((long)((double)this.monitorInterval * 0.2));
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("Thread fail to sleep");
                }
                this.updateArchives();
                this.checkNewArchives();
                if (this.firstCheck) {
                    this.myService.firstCheckEnded();
                }
                this.firstCheck = false;
            }
            try {
                Thread.sleep((long)((double)this.monitorInterval * 0.8));
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Thread fail to sleep");
            }
        }
        return;
    }

    private void saveFileLengths() {
        this.fileLengths.clear();
        for (File deployDirectory : this.directories) {
            File[] files = deployDirectory.listFiles(this.filter);
            if (files == null) continue;
            for (File file : files) {
                try {
                    this.fileLengths.put(file, DeployableMonitor.getFileSize(file));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }

    private static void checkFileCompleteness(File file) throws IOException {
        if (file.isFile()) {
            FileInputStream fis = new FileInputStream(file);
            fis.close();
        }
    }

    private static long getFileSize(File file) throws Exception {
        File[] childs;
        if (file.isFile()) {
            DeployableMonitor.checkFileCompleteness(file);
            return file.length();
        }
        long size = 0L;
        for (File child : childs = file.listFiles()) {
            size += DeployableMonitor.getFileSize(child);
        }
        return size;
    }

    private void checkNewArchives() {
        try {
            this.detectNewArchives();
        }
        catch (Exception e) {
            logger.error((Object)"Problem when trying to find and deploy new archives", new Object[]{e});
        }
        catch (Error e) {
            logger.error((Object)"Error when trying to find and deploy new archives", new Object[]{e});
        }
    }

    private void updateArchives() {
        try {
            this.checkModifiedDeployables();
        }
        catch (Exception e) {
            logger.error((Object)"Problem when checking current deployables", new Object[]{e});
        }
        catch (Error e) {
            logger.error((Object)"Error when checking current deployables", new Object[]{e});
        }
    }

    private void detectNewArchives() throws DeployableMonitorException {
        for (File deployDirectory : this.directories) {
            File[] files = deployDirectory.listFiles(this.filter);
            if (files == null) continue;
            Arrays.sort(files, new LexicographicallyFileComparator());
            if (this.firstCheck) {
                LinkedList<File> jdbcDsDeployables = new LinkedList<File>();
                LinkedList<File> osgiDeployables = new LinkedList<File>();
                LinkedList<File> rarDeployables = new LinkedList<File>();
                LinkedList<File> ejbDeployables = new LinkedList<File>();
                LinkedList<File> warDeployables = new LinkedList<File>();
                LinkedList<File> earDeployables = new LinkedList<File>();
                LinkedList<File> deploymentplanDeployables = new LinkedList<File>();
                LinkedList<File> repositoryDeployables = new LinkedList<File>();
                LinkedList<File> unknownDeployables = new LinkedList<File>();
                for (File f : files) {
                    IDeployable deployable;
                    IArchive archive = ArchiveManager.getInstance().getArchive((Object)f);
                    if (archive == null) {
                        logger.warn((Object)"Ignoring invalid file ''{0}''", new Object[]{f});
                        continue;
                    }
                    try {
                        deployable = DeployableHelper.getDeployable((IArchive)archive);
                    }
                    catch (DeployableHelperException e) {
                        this.failed.add(f);
                        throw new DeployableMonitorException("Cannot get a deployable for the archive '" + archive + "'", e);
                    }
                    if (DatasourceDeployable.class.isInstance(deployable)) {
                        jdbcDsDeployables.add(f);
                        continue;
                    }
                    if (OSGiDeployable.class.isInstance(deployable)) {
                        osgiDeployables.add(f);
                        continue;
                    }
                    if (RARDeployable.class.isInstance(deployable)) {
                        rarDeployables.add(f);
                        continue;
                    }
                    if (EJBDeployable.class.isInstance(deployable)) {
                        ejbDeployables.add(f);
                        continue;
                    }
                    if (WARDeployable.class.isInstance(deployable)) {
                        warDeployables.add(f);
                        continue;
                    }
                    if (EARDeployable.class.isInstance(deployable)) {
                        earDeployables.add(f);
                        continue;
                    }
                    if (DeploymentPlanDeployable.class.isInstance(deployable)) {
                        deploymentplanDeployables.add(f);
                        continue;
                    }
                    if (RepositoryDeployable.class.isInstance(deployable)) {
                        repositoryDeployables.add(f);
                        continue;
                    }
                    logger.debug((Object)"Unknown type of deployable: {0}", new Object[]{deployable});
                    unknownDeployables.add(f);
                }
                LinkedList<File> newList = new LinkedList<File>();
                newList.addAll(repositoryDeployables);
                newList.addAll(osgiDeployables);
                newList.addAll(rarDeployables);
                newList.addAll(jdbcDsDeployables);
                newList.addAll(deploymentplanDeployables);
                newList.addAll(ejbDeployables);
                newList.addAll(warDeployables);
                newList.addAll(earDeployables);
                newList.addAll(unknownDeployables);
                if (newList.size() > 0) {
                    logger.info((Object)"Deployables to deploy at startup: [{0}]", new Object[]{newList});
                }
                files = newList.toArray(new File[newList.size()]);
            }
            for (File file : files) {
                IDeployable deployable;
                IArchive archive;
                if (this.deployed.containsKey(file) || this.fileLengthHasChanged(file)) continue;
                if (this.failed.contains(file)) {
                    if (!this.hasBeenUpdated(file)) continue;
                    this.failed.remove(file);
                }
                if ((archive = ArchiveManager.getInstance().getArchive((Object)file)) == null) {
                    logger.warn((Object)"Ignoring invalid file ''{0}''", new Object[]{file});
                    continue;
                }
                try {
                    deployable = DeployableHelper.getDeployable((IArchive)archive);
                }
                catch (DeployableHelperException e) {
                    this.failed.add(file);
                    throw new DeployableMonitorException("Cannot get a deployable for the archive '" + archive + "'", e);
                }
                try {
                    if (this.deployerManager.isDeployed(deployable) && !DeploymentPlanDeployable.class.isInstance(deployable)) {
                        this.deployed.put(file, deployable);
                        continue;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (this.stopped) {
                    return;
                }
                logger.debug((Object)"Detect a new Deployable ''{0}'' and deploying it.", new Object[]{deployable});
                try {
                    this.deployerManager.deploy(deployable);
                    this.deployed.put(file, deployable);
                    System.gc();
                }
                catch (UnsupportedDeployerException e) {
                }
                catch (DeployerException e) {
                    this.failed.add(file);
                    throw new DeployableMonitorException("Cannot deploy the deployable '" + deployable + "'", e);
                }
                catch (RuntimeException e) {
                    this.failed.add(file);
                    throw new DeployableMonitorException("RuntimeException when deploying the deployable '" + deployable + "'", e);
                }
                catch (Error e) {
                    this.failed.add(file);
                    throw new DeployableMonitorException("Error when deploying the deployable '" + deployable + "'", e);
                }
            }
        }
    }

    protected long getLastModified(File archive) {
        if (archive.isFile()) {
            return archive.lastModified();
        }
        File[] files = archive.listFiles();
        long last = 0L;
        if (files != null) {
            for (File f : files) {
                last = Math.max(last, this.getLastModified(f));
            }
        }
        return last;
    }

    protected boolean hasBeenUpdated(File file) {
        if (this.fileLengthHasChanged(file)) {
            return false;
        }
        long previousLastModified = 0L;
        Long l = this.modifiedFiles.get(file);
        if (l != null) {
            previousLastModified = l;
        }
        long updatedModified = this.getLastModified(file);
        if (previousLastModified == 0L) {
            this.modifiedFiles.put(file, updatedModified);
            return false;
        }
        if (updatedModified > previousLastModified) {
            this.modifiedFiles.put(file, updatedModified);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void checkModifiedDeployables() throws DeployableMonitorException {
        IDeployable<?> deployable;
        Iterator<File> fileIterator = this.failed.iterator();
        while (fileIterator.hasNext()) {
            File f = fileIterator.next();
            if (f.exists()) continue;
            fileIterator.remove();
        }
        Set<File> files = this.deployed.keySet();
        for (File f : files) {
            deployable = this.deployed.get(f);
            try {
                if (this.deployerManager.isDeployed(deployable)) continue;
                this.deployed.remove(f);
            }
            catch (Exception e) {
                this.deployed.remove(f);
            }
        }
        if (files == null) {
            return;
        }
        Iterator<File> i$ = files.iterator();
        while (i$.hasNext()) {
            IDeployable newDeployable;
            File f;
            f = i$.next();
            deployable = this.deployed.get(f);
            if (deployable == null) continue;
            if (!f.exists()) {
                logger.info((Object)"Deployable ''{0}'' has been removed on the filesystem, undeploy it", new Object[]{deployable});
                try {
                    this.deployerManager.undeploy(deployable);
                    System.gc();
                }
                catch (UnsupportedDeployerException e) {
                }
                catch (DeployerException e) {
                    logger.error((Object)("Undeploy of the deployable '" + deployable + "' has failed"), new Object[]{e});
                    this.failed.add(f);
                }
                catch (RuntimeException e) {
                    logger.error((Object)("Undeploy of the deployable '" + deployable + "' has failed"), new Object[]{e});
                    this.failed.add(f);
                }
                finally {
                    this.deployed.remove(f);
                }
                continue;
            }
            if (!this.hasBeenUpdated(f)) continue;
            logger.info((Object)"Deployable ''{0}'' has been updated, reloading it", new Object[]{deployable});
            try {
                this.deployerManager.undeploy(deployable);
                this.deployed.remove(f);
                System.gc();
            }
            catch (UnsupportedDeployerException e) {
                continue;
            }
            catch (DeployerException e) {
                logger.error((Object)("Undeploy of the deployable '" + deployable + "' has failed"), new Object[]{e});
                this.deployed.remove(f);
                this.failed.add(f);
            }
            IArchive archive = ArchiveManager.getInstance().getArchive((Object)f);
            if (archive == null) {
                logger.warn((Object)"Ignoring invalid file ''{0}''", new Object[]{f});
                continue;
            }
            try {
                newDeployable = DeployableHelper.getDeployable((IArchive)archive);
            }
            catch (DeployableHelperException e) {
                logger.error((Object)("Cannot get a deployable for the archive '" + archive + "'"), new Object[]{e});
                continue;
            }
            try {
                this.deployerManager.deploy(newDeployable);
                this.deployed.put(f, newDeployable);
                System.gc();
                continue;
            }
            catch (UnsupportedDeployerException e) {
                continue;
            }
            catch (DeployerException e) {
                this.failed.add(f);
                throw new DeployableMonitorException("Cannot redeploy the deployable '" + newDeployable + "'.", e);
            }
            break;
        }
        return;
    }

    private boolean fileLengthHasChanged(File file) {
        if (!this.fileLengths.containsKey(file)) {
            return true;
        }
        long storedFileLength = this.fileLengths.get(file);
        long currentFileLength = 0L;
        try {
            currentFileLength = DeployableMonitor.getFileSize(file);
        }
        catch (Exception e) {
            return true;
        }
        return storedFileLength != currentFileLength;
    }

    public List<File> getDirectories() {
        return this.directories;
    }

    public void setDirectories(List<File> directories) {
        this.directories = directories;
    }

    public void addDirectory(File directory) {
        this.directories.add(directory);
    }

    public void removeDirectory(File directory) {
        this.directories.remove(directory);
    }

    public boolean isDevelopmentMode() {
        return this.developmentMode;
    }

    public void setDevelopmentMode(boolean developmentMode) {
        this.developmentMode = developmentMode;
    }

    public void setMonitorInterval(int monitorInterval) {
        this.monitorInterval = monitorInterval;
    }

    public void stopOrder() {
        this.stopped = true;
    }

    public IDeployerManager getDeployerManager() {
        return this.deployerManager;
    }

    public void setDeployerManager(IDeployerManager deployerManager) {
        this.deployerManager = deployerManager;
    }

    public void setExclusionPatterns(List<String> patterns) {
        this.filter.setExclusionList(patterns);
    }
}

