/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.mail.internal.factory;

import java.util.Properties;
import javax.naming.BinaryRefAddr;
import javax.naming.NamingException;
import javax.naming.Reference;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.lib.util.JNDIUtils;
import org.ow2.jonas.lib.util.PropDump;
import org.ow2.jonas.mail.MailService;
import org.ow2.jonas.mail.factory.JavaMail;
import org.ow2.jonas.mail.internal.factory.AbstractJavaMail;
import org.ow2.jonas.mail.internal.factory.JavaMailMimePartDSFactory;

public class JavaMailMimePartDS
extends AbstractJavaMail {
    private static final String FACTORY_TYPE = "javax.mail.internet.MimePartDataSource";
    private Properties messageProperties = null;
    protected static final String MIMEMESSAGE_TO = "mail.to";
    protected static final String MIMEMESSAGE_CC = "mail.cc";
    protected static final String MIMEMESSAGE_BCC = "mail.bcc";
    protected static final String MIMEMESSAGE_SUBJECT = "mail.subject";

    public String getType() {
        return FACTORY_TYPE;
    }

    public JavaMailMimePartDS(String factoryName, String name, Properties mailProperties, MailService mailService) {
        super(factoryName, name, mailProperties, mailService);
        PropDump.print((String)"Received props:", (Properties)mailProperties, (Logger)JavaMailMimePartDS.getLogger(), (int)BasicLevel.DEBUG);
        this.messageProperties = new Properties();
        String propValue = null;
        propValue = (String)this.getMailSessionProperties().remove(MIMEMESSAGE_TO);
        if (propValue != null) {
            this.messageProperties.setProperty(MIMEMESSAGE_TO, propValue);
        }
        if ((propValue = (String)this.getMailSessionProperties().remove(MIMEMESSAGE_CC)) != null) {
            this.messageProperties.setProperty(MIMEMESSAGE_CC, propValue);
        }
        if ((propValue = (String)this.getMailSessionProperties().remove(MIMEMESSAGE_BCC)) != null) {
            this.messageProperties.setProperty(MIMEMESSAGE_BCC, propValue);
        }
        if ((propValue = (String)this.getMailSessionProperties().remove(MIMEMESSAGE_SUBJECT)) != null) {
            this.messageProperties.setProperty(MIMEMESSAGE_SUBJECT, propValue);
        }
        if (JavaMailMimePartDS.getLogger().isLoggable(BasicLevel.DEBUG)) {
            PropDump.print((String)"Message props:", (Properties)this.messageProperties, (Logger)JavaMailMimePartDS.getLogger(), (int)BasicLevel.DEBUG);
        }
    }

    public Properties getMimeMessageProperties() {
        return this.messageProperties;
    }

    public void setMimeMessageProperties(Properties props) {
        this.messageProperties = props;
        try {
            this.getMailService().recreateJavaMailFactory((JavaMail)this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (JavaMailMimePartDS.getLogger().isLoggable(BasicLevel.DEBUG)) {
            PropDump.print((String)"These are the udated message props", (Properties)this.messageProperties, (Logger)JavaMailMimePartDS.getLogger(), (int)BasicLevel.DEBUG);
        }
    }

    public Reference getReference() throws NamingException {
        Reference reference = new Reference(FACTORY_TYPE, JavaMailMimePartDSFactory.class.getName(), null);
        byte[] bytes = null;
        bytes = JNDIUtils.getBytesFromObject((Object)this.getMailSessionProperties());
        if (bytes != null) {
            reference.add(new BinaryRefAddr("javaxmailSession.properties", bytes));
        }
        if ((bytes = JNDIUtils.getBytesFromObject((Object)this.messageProperties)) != null) {
            reference.add(new BinaryRefAddr("javaxInternetMimeMessage.properties", bytes));
        }
        if ((bytes = JNDIUtils.getBytesFromObject((Object)this.getAuthenticationProperties())) != null) {
            reference.add(new BinaryRefAddr("authentication.properties", bytes));
        }
        return reference;
    }
}

