/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.factory;

import java.lang.reflect.Constructor;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.ORB;
import org.jacorb.orb.factory.DefaultServerSocketFactory;
import org.jacorb.orb.factory.DefaultSocketFactory;
import org.jacorb.orb.factory.PortRangeSocketFactory;
import org.jacorb.orb.factory.ServerSocketFactory;
import org.jacorb.orb.factory.SocketFactory;
import org.jacorb.util.ObjectUtil;

public class SocketFactoryManager
implements Configurable {
    private static final String FACTORY_PROP = "jacorb.net.socket_factory";
    private static final String SERVER_FACTORY_PROP = "jacorb.net.server_socket_factory";
    private SocketFactory socketFactory = null;
    private ServerSocketFactory serverFactory = null;
    private ORB orb;
    private Configuration configuration = null;
    private Logger logger = null;
    private String serverFactoryClassName = null;
    private String factoryClassName = null;
    private String portNo = null;
    static /* synthetic */ Class class$org$jacorb$orb$ORB;

    public SocketFactoryManager(ORB oRB) {
        this.orb = oRB;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.configuration = configuration;
        this.logger = ((org.jacorb.config.Configuration)configuration).getNamedLogger("jacorb.orb.factory");
        this.serverFactoryClassName = configuration.getAttribute(SERVER_FACTORY_PROP, "");
        this.factoryClassName = configuration.getAttribute(FACTORY_PROP, "");
        this.portNo = configuration.getAttribute("jacorb.net.socket_factory.port.min", "");
    }

    public synchronized SocketFactory getSocketFactory() {
        if (this.socketFactory != null) {
            return this.socketFactory;
        }
        this.socketFactory = this.factoryClassName.length() == 0 ? (this.portNo.length() > 0 ? new PortRangeSocketFactory() : new DefaultSocketFactory()) : this.getFactory(this.factoryClassName);
        return this.socketFactory;
    }

    public synchronized ServerSocketFactory getServerSocketFactory() {
        if (this.serverFactory != null) {
            return this.serverFactory;
        }
        this.serverFactory = this.serverFactoryClassName == null || this.serverFactoryClassName.length() == 0 ? new DefaultServerSocketFactory() : this.getServerFactory(this.serverFactoryClassName);
        return this.serverFactory;
    }

    private SocketFactory getFactory(String string) {
        Object object = this.getFactoryObject(this.orb, string);
        if (object instanceof SocketFactory) {
            if (object instanceof Configurable) {
                try {
                    ((Configurable)object).configure(this.configuration);
                }
                catch (ConfigurationException configurationException) {
                    throw new RuntimeException("Configurable custom socket factory " + string + " could not be configured!: " + configurationException);
                }
            }
            return (SocketFactory)object;
        }
        throw new RuntimeException("Custom factory " + string + " does not implement SocketFactory");
    }

    private ServerSocketFactory getServerFactory(String string) {
        Object object = this.getFactoryObject(this.orb, string);
        if (object instanceof ServerSocketFactory) {
            if (object instanceof Configurable) {
                try {
                    ((Configurable)object).configure(this.configuration);
                }
                catch (ConfigurationException configurationException) {
                    throw new RuntimeException("Configurable custom server socket factory " + string + " could not be configured!: " + configurationException);
                }
            }
            return (ServerSocketFactory)object;
        }
        throw new RuntimeException("Custom factory " + string + " does not implement ServerSocketFactory");
    }

    private Object getFactoryObject(ORB oRB, String string) {
        Object t;
        Constructor constructor = null;
        try {
            Class clazz = ObjectUtil.classForName(string);
            if (oRB != null) {
                try {
                    constructor = clazz.getConstructor(class$org$jacorb$orb$ORB == null ? (class$org$jacorb$orb$ORB = SocketFactoryManager.class$("org.jacorb.orb.ORB")) : class$org$jacorb$orb$ORB);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            t = constructor != null ? constructor.newInstance(oRB) : clazz.newInstance();
        }
        catch (Exception exception) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(exception.getMessage());
            }
            throw new RuntimeException("Failed to create custom socket factory: " + string);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("SocketFactoryManager: created " + t.getClass().getName());
        }
        return t;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

