/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.trading.constraint;

import java.io.PrintStream;
import org.jacorb.trading.constraint.ExprNode;
import org.jacorb.trading.constraint.MissingPropertyException;
import org.jacorb.trading.constraint.PropertySource;
import org.jacorb.trading.constraint.Value;
import org.jacorb.trading.constraint.ValueType;

public class AddNode
extends ExprNode {
    private ExprNode m_left;
    private ExprNode m_right;

    private AddNode() {
    }

    public AddNode(ExprNode exprNode, ExprNode exprNode2) {
        this.m_left = exprNode;
        this.m_right = exprNode2;
        int n = ValueType.promote(exprNode.getType().getId(), exprNode2.getType().getId());
        this.setType(new ValueType(n));
    }

    public void print(PrintStream printStream) {
        printStream.println("AddNode: type = " + this.getType());
        printStream.println("Left node:");
        this.m_left.print(printStream);
        printStream.println("Right node:");
        this.m_right.print(printStream);
    }

    public Value evaluate(PropertySource propertySource) throws MissingPropertyException {
        Value value = null;
        int n = this.getType().getId();
        Value value2 = this.m_left.evaluate(propertySource);
        Value value3 = value2.convert(n);
        value2 = this.m_right.evaluate(propertySource);
        Value value4 = value2.convert(n);
        value = value3.plus(value4);
        return value;
    }
}

