/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.enhancer.interceptors;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ow2.easybeans.api.EasyBeansInvocationContext;
import org.ow2.easybeans.api.Factory;
import org.ow2.easybeans.api.bean.EasyBeansBean;
import org.ow2.easybeans.api.interceptor.EZBInterceptorInvoker;
import org.ow2.easybeans.api.interceptor.EZBInterceptorManager;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicInvocationContextImpl
implements EasyBeansInvocationContext {
    private static final Log LOGGER = LogFactory.getLog(DynamicInvocationContextImpl.class);
    private Map<String, Object> contextData;
    private Object[] parameters;
    private EasyBeansBean instance;
    private Object timer;
    private List<EZBInterceptorInvoker> interceptorInvokerList;
    private Method method = null;
    private int index;
    private EZBInterceptorManager interceptorManager;
    private boolean isLifeCycleMode = false;

    public DynamicInvocationContextImpl(EasyBeansBean instance, List<EZBInterceptorInvoker> interceptorInvokerList, EZBInterceptorManager interceptorManager, boolean isLifeCycleMode, Method method, Object ... parameters) {
        LOGGER.debug((Object)"Creating DynamicInvocationContextImpl for instance ''{0}'', interceptor Invoker list ''{1}'', interceptor manager ''{2}'', method ''{3}'', parameters ''{4}''", new Object[]{instance, interceptorInvokerList, interceptorManager, method, Arrays.asList(parameters)});
        this.index = 0;
        this.instance = instance;
        this.interceptorInvokerList = interceptorInvokerList;
        this.interceptorManager = interceptorManager;
        this.isLifeCycleMode = isLifeCycleMode;
        this.method = method;
        this.parameters = parameters;
    }

    public Object proceed() throws Exception {
        return this.interceptorInvokerList.get(this.index++).invoke((EasyBeansInvocationContext)this, this.interceptorManager);
    }

    public Factory<?, ?> getFactory() {
        return this.instance.getEasyBeansFactory();
    }

    public Map<String, Object> getContextData() {
        if (this.contextData == null) {
            this.contextData = new HashMap<String, Object>();
        }
        return this.contextData;
    }

    public Method getMethod() {
        if (this.isLifeCycleMode) {
            return null;
        }
        return this.method;
    }

    public Object[] getParameters() {
        if (this.isLifeCycleMode) {
            throw new IllegalStateException("getParameters method shouldn't be called on lifecycle interceptors");
        }
        return this.getInternalParameters();
    }

    protected Object[] getInternalParameters() {
        return this.parameters;
    }

    public Object getTarget() {
        return this.instance;
    }

    public Object getTimer() {
        return this.timer;
    }

    public void setParameters(Object[] parameters) {
        if (this.isLifeCycleMode) {
            throw new IllegalStateException("setParameters method shouldn't be called on lifecycle interceptors");
        }
        this.parameters = parameters;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getName());
        sb.append("[");
        int j = 1;
        for (EZBInterceptorInvoker invoker : this.interceptorInvokerList) {
            sb.append("\n  [").append(j).append("/").append(this.interceptorInvokerList.size()).append("] = ").append(invoker);
            if (j == this.index) {
                sb.append("  <-- current");
            }
            ++j;
        }
        sb.append("]");
        return sb.toString();
    }
}

