/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.proxy.client;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import java.util.HashMap;
import javax.ejb.EJBLocalObject;
import javax.ejb.NoSuchEJBException;
import javax.ejb.NoSuchObjectLocalException;
import org.ow2.easybeans.api.EZBContainer;
import org.ow2.easybeans.api.EZBServer;
import org.ow2.easybeans.api.EmbeddedManager;
import org.ow2.easybeans.api.Factory;
import org.ow2.easybeans.proxy.client.AbsInvocationHandler;
import org.ow2.easybeans.rpc.EJBLocalRequestImpl;
import org.ow2.easybeans.rpc.api.EJBLocalRequest;
import org.ow2.easybeans.rpc.api.EJBResponse;
import org.ow2.easybeans.rpc.api.RPCException;
import org.ow2.easybeans.rpc.util.Hash;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalCallInvocationHandler
extends AbsInvocationHandler
implements Externalizable {
    private static final long serialVersionUID = -4327634481654235615L;
    private Integer embeddedID = null;
    private transient Factory<?, ?> factory = null;
    private boolean isExtendingEJBLocalObject = false;

    public LocalCallInvocationHandler(Integer embeddedID, String containerId, String factoryName, boolean useID) {
        super(containerId, factoryName, useID);
        this.embeddedID = embeddedID;
        this.initFactory();
    }

    public LocalCallInvocationHandler() {
        super(null, null, false);
    }

    private void initFactory() {
        EZBServer ejb3Server = EmbeddedManager.getEmbedded((Integer)this.embeddedID);
        if (ejb3Server == null) {
            throw new IllegalStateException("Cannot find the server with id '" + this.embeddedID + "'.");
        }
        EZBContainer container = ejb3Server.getContainer(this.getContainerId());
        if (container == null) {
            throw new IllegalStateException("Cannot find the container with id '" + this.getContainerId() + "'.");
        }
        this.factory = container.getFactory(this.getFactoryName());
        if (this.factory == null) {
            throw new IllegalStateException("Cannot find the factory with name '" + this.getFactoryName() + "'.");
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Exception {
        return this.invoke(proxy, method, args, null);
    }

    public Object invoke(Object proxy, Method method, Object[] args, Long hashMethod) throws Exception {
        if (this.isRemoved()) {
            this.handleThrowable(this.convertThrowable(new NoSuchEJBException("The bean has been removed")), false, method, null);
        }
        if (!(!method.getDeclaringClass().getName().equals("java.lang.Object") || this.isUsingID() && this.getBeanId() == null && method.getName().equals("toString"))) {
            return this.handleObjectMethods(method, args);
        }
        if (this.getHashedMethods() == null) {
            this.setHashedMethods(new HashMap<Method, Long>());
        }
        Long hashLong = null;
        if (hashMethod == null) {
            hashLong = this.getHashedMethods().get(method);
            if (hashLong == null) {
                hashLong = Hash.hashMethod(method);
                this.getHashedMethods().put(method, hashLong);
            }
        } else {
            hashLong = hashMethod;
        }
        EJBLocalRequestImpl localRequest = new EJBLocalRequestImpl(hashLong, args, this.getBeanId(), this.getInterfaceClassName());
        EJBResponse response = this.factory.localCall((EJBLocalRequest)localRequest);
        this.setBeanId(response.getBeanId());
        if (method.getDeclaringClass().getName().equals("java.lang.Object") && this.getBeanId() != null && method.getName().equals("toString")) {
            return this.handleObjectMethods(method, args);
        }
        this.setRemoved(response.isRemoved());
        RPCException rpcException = response.getRPCException();
        if (rpcException != null) {
            this.handleThrowable(rpcException.getCause(), rpcException.isApplicationException(), method, rpcException);
        }
        return response.getValue();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.embeddedID);
        out.writeObject(this.getContainerId());
        out.writeObject(this.getFactoryName());
        out.writeObject(this.getInterfaceClassName());
        out.writeBoolean(this.isExtendingRmiRemote());
        out.writeBoolean(this.isExtendingEJBLocalObject);
        out.writeBoolean(this.isUsingID());
        out.writeBoolean(this.isRemoved());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.embeddedID = (Integer)in.readObject();
        this.setContainerId((String)in.readObject());
        this.setFactoryName((String)in.readObject());
        this.setInterfaceClassName((String)in.readObject());
        this.setExtendingRmiRemote(in.readBoolean());
        this.isExtendingEJBLocalObject = in.readBoolean();
        this.setUseID(in.readBoolean());
        this.setRemoved(in.readBoolean());
        this.initFactory();
    }

    protected Integer getEmbeddedID() {
        return this.embeddedID;
    }

    @Override
    public void setInterfaceClass(Class<?> clz) {
        super.setInterfaceClass(clz);
        if (EJBLocalObject.class.isAssignableFrom(clz)) {
            this.isExtendingEJBLocalObject = true;
        }
    }

    protected Throwable convertThrowable(Throwable throwable) {
        if (this.isExtendingEJBLocalObject && throwable instanceof NoSuchEJBException) {
            NoSuchObjectLocalException ne = new NoSuchObjectLocalException(throwable.getMessage(), (Exception)throwable);
            return ne;
        }
        return throwable;
    }

    public void setFactory(Factory<?, ?> factory) {
        this.factory = factory;
    }

    protected Factory<?, ?> getFactory() {
        return this.factory;
    }
}

