/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Logger;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.validation.Schema;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.PackageUtils;
import org.apache.cxf.common.util.ReflectionInvokationHandler;
import org.apache.cxf.jaxb.JAXBBeanInfo;
import org.apache.cxf.jaxb.JAXBContextProxy;
import org.apache.cxf.jaxb.JAXBUtils;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.provider.AbstractConfigurableProvider;
import org.apache.cxf.jaxrs.utils.AnnotationUtils;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.jaxrs.utils.schemas.SchemaHandler;
import org.apache.cxf.staxutils.DelegatingXMLStreamWriter;
import org.apache.cxf.staxutils.DepthXMLStreamReader;
import org.apache.cxf.staxutils.StaxStreamFilter;
import org.apache.cxf.staxutils.StaxUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJAXBProvider
extends AbstractConfigurableProvider
implements MessageBodyReader<Object>,
MessageBodyWriter<Object> {
    protected static final ResourceBundle BUNDLE = BundleUtils.getBundle(AbstractJAXBProvider.class);
    private static final Logger LOG = LogUtils.getL7dLogger(AbstractJAXBProvider.class);
    private static final String JAXB_DEFAULT_NAMESPACE = "##default";
    private static final String JAXB_DEFAULT_NAME = "##default";
    private static Map<String, JAXBContext> packageContexts = new HashMap<String, JAXBContext>();
    private static Map<Class<?>, JAXBContext> classContexts = new HashMap();
    protected Set<Class<?>> collectionContextClasses = new HashSet();
    protected JAXBContext collectionContext;
    protected Map<String, String> jaxbElementClassMap;
    protected boolean unmarshalAsJaxbElement;
    protected boolean marshalAsJaxbElement;
    protected Map<String, String> outElementsMap;
    protected Map<String, String> outAppendMap;
    protected List<String> outDropElements;
    protected List<String> inDropElements;
    protected Map<String, String> inElementsMap;
    protected Map<String, String> inAppendMap;
    private boolean attributesToElements;
    private MessageContext mc;
    private Schema schema;
    private String collectionWrapperName;
    private Map<String, String> collectionWrapperMap;
    private List<String> jaxbElementClassNames;
    private Map<String, Object> cProperties;
    private Map<String, Object> uProperties;
    private boolean skipJaxbChecks;

    public void setContextProperties(Map<String, Object> contextProperties) {
        this.cProperties = contextProperties;
    }

    public void setUnmarshallerProperties(Map<String, Object> unmarshalProperties) {
        this.uProperties = unmarshalProperties;
    }

    public void setUnmarshallAsJaxbElement(boolean value) {
        this.unmarshalAsJaxbElement = value;
    }

    public void setMarshallAsJaxbElement(boolean value) {
        this.marshalAsJaxbElement = value;
    }

    public void setJaxbElementClassNames(List<String> names) {
        this.jaxbElementClassNames = names;
    }

    public void setJaxbElementClassMap(Map<String, String> map) {
        this.jaxbElementClassMap = map;
    }

    protected void checkContentLength() {
        List values;
        if (this.mc != null && (values = this.mc.getHttpHeaders().getRequestHeader("Content-Length")).size() == 1 && "0".equals(values.get(0))) {
            String message = new Message("EMPTY_BODY", BUNDLE, new Object[0]).toString();
            LOG.warning(message);
            throw new WebApplicationException(400);
        }
    }

    protected Object convertToJaxbElementIfNeeded(Object obj, Class<?> cls, Type genericType) throws Exception {
        QName name = null;
        if (this.jaxbElementClassNames != null && this.jaxbElementClassNames.contains(cls.getName()) || this.jaxbElementClassMap != null && this.jaxbElementClassMap.containsKey(cls.getName())) {
            name = this.jaxbElementClassMap != null ? JAXRSUtils.convertStringToQName(this.jaxbElementClassMap.get(cls.getName())) : this.getJaxbQName(cls, genericType, obj, false);
        }
        if (name == null && this.marshalAsJaxbElement) {
            name = JAXRSUtils.convertStringToQName(cls.getSimpleName());
        }
        if (name != null) {
            return new JAXBElement(name, cls, null, obj);
        }
        return obj;
    }

    public void setCollectionWrapperName(String wName) {
        this.collectionWrapperName = wName;
    }

    public void setCollectionWrapperMap(Map<String, String> map) {
        this.collectionWrapperMap = map;
    }

    protected void setContext(MessageContext context) {
        this.mc = context;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] anns, MediaType mt) {
        if (InjectionUtils.isSupportedCollectionOrArray(type) && (type = InjectionUtils.getActualType(genericType)) == null) {
            return false;
        }
        return this.unmarshalAsJaxbElement || this.isSupported(type, genericType, anns);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JAXBContext getCollectionContext(Class<?> type) throws JAXBException {
        Set<Class<?>> set = this.collectionContextClasses;
        synchronized (set) {
            if (!this.collectionContextClasses.contains(type)) {
                this.collectionContextClasses.add(CollectionWrapper.class);
                this.collectionContextClasses.add(type);
            }
            this.collectionContext = JAXBContext.newInstance((Class[])this.collectionContextClasses.toArray(new Class[0]), this.cProperties);
            return this.collectionContext;
        }
    }

    protected QName getCollectionWrapperQName(Class<?> cls, Type type, Object object, boolean pluralName) throws Exception {
        String name = this.getCollectionWrapperName(cls);
        if (name == null) {
            return this.getJaxbQName(cls, type, object, pluralName);
        }
        return JAXRSUtils.convertStringToQName(name);
    }

    private String getCollectionWrapperName(Class<?> cls) {
        if (this.collectionWrapperName != null) {
            return this.collectionWrapperName;
        }
        if (this.collectionWrapperMap != null) {
            return this.collectionWrapperMap.get(cls.getName());
        }
        return null;
    }

    protected QName getJaxbQName(Class<?> cls, Type type, Object object, boolean pluralName) throws Exception {
        if (cls == JAXBElement.class) {
            return object != null ? ((JAXBElement)object).getName() : null;
        }
        XmlRootElement root = cls.getAnnotation(XmlRootElement.class);
        QName qname = null;
        if (root != null) {
            String packageNs;
            String namespace = this.getNamespace(root.namespace());
            if ("".equals(namespace) && (packageNs = JAXBUtils.getPackageNamespace(cls)) != null) {
                namespace = this.getNamespace(packageNs);
            }
            String name = this.getLocalName(root.name(), cls.getSimpleName(), pluralName);
            return new QName(namespace, name);
        }
        JAXBContext context = this.getJAXBContext(cls, type);
        JAXBContextProxy proxy = ReflectionInvokationHandler.createProxyWrapper(context, JAXBContextProxy.class);
        JAXBBeanInfo info = JAXBUtils.getBeanInfo(proxy, cls);
        if (info != null) {
            try {
                Object instance = object == null ? cls.newInstance() : object;
                String name = this.getLocalName(info.getElementLocalName(instance), cls.getSimpleName(), pluralName);
                String namespace = this.getNamespace(info.getElementNamespaceURI(instance));
                return new QName(namespace, name);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return qname;
    }

    private String getLocalName(String name, String clsName, boolean pluralName) {
        if ("##default".equals(name)) {
            name = clsName;
            name = name.length() > 1 ? name.substring(0, 1).toLowerCase() + name.substring(1) : name.toLowerCase();
        }
        if (pluralName) {
            name = name + 's';
        }
        return name;
    }

    private String getNamespace(String namespace) {
        if ("##default".equals(namespace)) {
            return "";
        }
        return namespace;
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] anns, MediaType mt) {
        return this.marshalAsJaxbElement || this.isSupported(type, genericType, anns);
    }

    public void setSchemaLocations(List<String> locations) {
        this.schema = SchemaHandler.createSchema(locations, this.getBus());
    }

    public void setSchema(Schema s) {
        this.schema = s;
    }

    public long getSize(Object o, Class<?> type, Type genericType, Annotation[] annotations, MediaType mt) {
        return -1L;
    }

    protected MessageContext getContext() {
        return this.mc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JAXBContext getJAXBContext(Class<?> type, Type genericType) throws JAXBException {
        JAXBContext customContext;
        ContextResolver resolver;
        if (this.mc != null && (resolver = this.mc.getResolver(ContextResolver.class, JAXBContext.class)) != null && (customContext = (JAXBContext)resolver.getContext(type)) != null) {
            return customContext;
        }
        resolver = classContexts;
        synchronized (resolver) {
            JAXBContext context = classContexts.get(type);
            if (context != null) {
                return context;
            }
        }
        JAXBContext context = this.getPackageContext(type);
        return context != null ? context : this.getClassContext(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JAXBContext getClassContext(Class<?> type) throws JAXBException {
        Map<Class<?>, JAXBContext> map = classContexts;
        synchronized (map) {
            JAXBContext context = classContexts.get(type);
            if (context == null) {
                context = JAXBContext.newInstance((Class[])new Class[]{type}, this.cProperties);
                classContexts.put(type, context);
            }
            return context;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JAXBContext getPackageContext(Class<?> type) {
        if (type == null || type == JAXBElement.class) {
            return null;
        }
        Map<String, JAXBContext> map = packageContexts;
        synchronized (map) {
            String packageName = PackageUtils.getPackageName(type);
            JAXBContext context = packageContexts.get(packageName);
            if (context == null) {
                try {
                    if (type.getClassLoader() != null) {
                        context = JAXBContext.newInstance((String)packageName, (ClassLoader)type.getClassLoader(), this.cProperties);
                        packageContexts.put(packageName, context);
                    }
                }
                catch (JAXBException ex) {
                    LOG.fine("Error creating a JAXBContext using ObjectFactory : " + ex.getMessage());
                    return null;
                }
            }
            return context;
        }
    }

    protected boolean isSupported(Class<?> type, Type genericType, Annotation[] anns) {
        if (this.jaxbElementClassMap != null && this.jaxbElementClassMap.containsKey(type.getName()) || this.isSkipJaxbChecks()) {
            return true;
        }
        return type.getAnnotation(XmlRootElement.class) != null || JAXBElement.class.isAssignableFrom(type) || this.objectFactoryForClass(type) || type != genericType && this.objectFactoryForType(genericType) || this.getAdapter(type, anns) != null || type.getResource("jaxb.index") != null;
    }

    protected boolean objectFactoryForClass(Class<?> type) {
        try {
            return type.getClassLoader().loadClass(PackageUtils.getPackageName(type) + ".ObjectFactory") != null;
        }
        catch (Exception ex) {
            return false;
        }
    }

    private boolean objectFactoryForType(Type genericType) {
        return this.objectFactoryForClass(InjectionUtils.getActualType(genericType));
    }

    protected Unmarshaller createUnmarshaller(Class<?> cls, Type genericType) throws JAXBException {
        return this.createUnmarshaller(cls, genericType, false);
    }

    protected Unmarshaller createUnmarshaller(Class<?> cls, Type genericType, boolean isCollection) throws JAXBException {
        JAXBContext context = isCollection ? this.getCollectionContext(cls) : this.getJAXBContext(cls, genericType);
        Unmarshaller unmarshaller = context.createUnmarshaller();
        if (this.schema != null) {
            unmarshaller.setSchema(this.schema);
        }
        if (this.uProperties != null) {
            for (Map.Entry<String, Object> entry : this.uProperties.entrySet()) {
                unmarshaller.setProperty(entry.getKey(), entry.getValue());
            }
        }
        return unmarshaller;
    }

    protected Marshaller createMarshaller(Object obj, Class<?> cls, Type genericType, String enc) throws JAXBException {
        Class objClazz = JAXBElement.class.isAssignableFrom(cls) ? ((JAXBElement)obj).getDeclaredType() : cls;
        JAXBContext context = this.getJAXBContext(objClazz, genericType);
        Marshaller marshaller = context.createMarshaller();
        if (enc != null) {
            marshaller.setProperty("jaxb.encoding", (Object)enc);
        }
        return marshaller;
    }

    protected Class<?> getActualType(Class<?> type, Type genericType, Annotation[] anns) {
        Class<?> theType = null;
        theType = JAXBElement.class.isAssignableFrom(type) ? InjectionUtils.getActualType(genericType) : type;
        XmlJavaTypeAdapter adapter = this.getAdapter(theType, anns);
        if (adapter != null) {
            if (adapter.type() != XmlJavaTypeAdapter.DEFAULT.class) {
                theType = adapter.type();
            } else {
                Type[] types = InjectionUtils.getActualTypes(adapter.value().getGenericSuperclass());
                if (types != null && types.length == 2) {
                    theType = InjectionUtils.getActualType(types[0]);
                }
            }
        }
        return theType;
    }

    protected Object checkAdapter(Object obj, Class<?> cls, Annotation[] anns, boolean marshal) {
        XmlJavaTypeAdapter typeAdapter = this.getAdapter(obj.getClass(), anns);
        if (typeAdapter != null) {
            try {
                XmlAdapter xmlAdapter = (XmlAdapter)typeAdapter.value().newInstance();
                if (marshal) {
                    return xmlAdapter.marshal(obj);
                }
                return xmlAdapter.unmarshal(obj);
            }
            catch (Exception ex) {
                LOG.warning("Problem using the XmlJavaTypeAdapter");
                ex.printStackTrace();
            }
        }
        return obj;
    }

    protected XmlJavaTypeAdapter getAdapter(Class<?> objectClass, Annotation[] anns) {
        XmlJavaTypeAdapter typeAdapter = AnnotationUtils.getAnnotation(anns, XmlJavaTypeAdapter.class);
        if (typeAdapter == null && (typeAdapter = objectClass.getAnnotation(XmlJavaTypeAdapter.class)) == null) {
            Class<?>[] interfaces = objectClass.getInterfaces();
            typeAdapter = interfaces.length > 0 ? interfaces[0].getAnnotation(XmlJavaTypeAdapter.class) : null;
        }
        return typeAdapter;
    }

    protected Schema getSchema() {
        return this.schema;
    }

    static void clearContexts() {
        classContexts.clear();
        packageContexts.clear();
    }

    protected static void handleJAXBException(JAXBException e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        LOG.warning(sw.toString());
        StringBuilder sb = new StringBuilder();
        if (e.getMessage() != null) {
            sb.append(e.getMessage()).append(". ");
        }
        if (e.getCause() != null && e.getCause().getMessage() != null) {
            sb.append(e.getCause().getMessage()).append(". ");
        }
        if (e.getLinkedException() != null && e.getLinkedException().getMessage() != null) {
            sb.append(e.getLinkedException().getMessage()).append(". ");
        }
        Throwable t = e.getLinkedException() != null ? e.getLinkedException() : (e.getCause() != null ? e.getCause() : e);
        String message = new Message("JAXB_EXCEPTION", BUNDLE, sb.toString()).toString();
        Response r = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type("text/plain").entity((Object)message).build();
        throw new WebApplicationException(t, r);
    }

    public void setOutTransformElements(Map<String, String> outElements) {
        this.outElementsMap = outElements;
    }

    public void setInAppendElements(Map<String, String> inElements) {
        this.inAppendMap = inElements;
    }

    public void setInTransformElements(Map<String, String> inElements) {
        this.inElementsMap = inElements;
    }

    public void setOutAppendElements(Map<String, String> map) {
        this.outAppendMap = map;
    }

    public void setOutDropElements(List<String> dropElementsSet) {
        this.outDropElements = dropElementsSet;
    }

    public void setInDropElements(List<String> dropElementsSet) {
        this.inDropElements = dropElementsSet;
    }

    protected static Set<QName> convertToSetOfQNames(List<String> dropEls) {
        Set<QName> dropElements = Collections.emptySet();
        if (dropEls != null) {
            dropElements = new LinkedHashSet<QName>(dropEls.size());
            for (String val : dropEls) {
                dropElements.add(JAXRSUtils.convertStringToQName(val));
            }
        }
        return dropElements;
    }

    protected XMLStreamReader createTransformReaderIfNeeded(XMLStreamReader reader, InputStream is) {
        if (this.inDropElements != null) {
            Set<QName> dropElements = AbstractJAXBProvider.convertToSetOfQNames(this.inDropElements);
            reader = StaxUtils.createFilteredReader(this.createNewReaderIfNeeded(reader, is), new StaxStreamFilter(dropElements.toArray(new QName[0])));
        }
        if (this.inElementsMap != null || this.inAppendMap != null) {
            reader = new InTransformReader(this.createNewReaderIfNeeded(reader, is), this.inElementsMap, this.inAppendMap);
        }
        return reader;
    }

    protected XMLStreamWriter createTransformWriterIfNeeded(XMLStreamWriter writer, OutputStream os) {
        if (this.outElementsMap != null || this.outDropElements != null || this.outAppendMap != null || this.attributesToElements) {
            writer = this.createNewWriterIfNeeded(writer, os);
            writer = new OutTransformWriter(writer, this.outElementsMap, this.outAppendMap, this.outDropElements, this.attributesToElements);
        }
        return writer;
    }

    protected XMLStreamReader createNewReaderIfNeeded(XMLStreamReader reader, InputStream is) {
        return reader == null ? StaxUtils.createXMLStreamReader(is) : reader;
    }

    protected XMLStreamWriter createNewWriterIfNeeded(XMLStreamWriter writer, OutputStream os) {
        return writer == null ? StaxUtils.createXMLStreamWriter(os) : writer;
    }

    protected static void convertToQNamesMap(Map<String, String> map, QNamesMap elementsMap, Map<String, String> nsMap) {
        if (map != null) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                QName lname = JAXRSUtils.convertStringToQName(entry.getKey());
                QName rname = JAXRSUtils.convertStringToQName(entry.getValue());
                elementsMap.put(lname, rname);
                if (nsMap == null) continue;
                nsMap.put(lname.getNamespaceURI(), rname.getNamespaceURI());
            }
        }
    }

    protected static void convertToMapOfQNames(Map<String, String> map, Map<QName, QName> elementsMap) {
        if (map != null) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                QName lname = JAXRSUtils.convertStringToQName(entry.getKey());
                QName rname = JAXRSUtils.convertStringToQName(entry.getValue());
                elementsMap.put(lname, rname);
            }
        }
    }

    public void setAttributesToElements(boolean value) {
        this.attributesToElements = value;
    }

    public void setSkipJaxbChecks(boolean skipJaxbChecks) {
        this.skipJaxbChecks = skipJaxbChecks;
    }

    public boolean isSkipJaxbChecks() {
        return this.skipJaxbChecks;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DelegatingNamespaceContext
    implements NamespaceContext {
        private NamespaceContext nc;
        private Map<String, String> nsMap;

        public DelegatingNamespaceContext(NamespaceContext nc, Map<String, String> nsMap) {
            this.nc = nc;
            this.nsMap = nsMap;
        }

        @Override
        public String getNamespaceURI(String prefix) {
            return this.nc.getNamespaceURI(prefix);
        }

        @Override
        public String getPrefix(String ns) {
            String value = this.nsMap.get(ns);
            if (value != null && value.length() == 0) {
                return null;
            }
            return value != null ? this.nc.getPrefix(value) : this.nc.getPrefix(ns);
        }

        public Iterator getPrefixes(String ns) {
            return this.nc.getPrefixes(ns);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class InTransformReader
    extends DepthXMLStreamReader {
        private static final String INTERN_NAMES = "org.codehaus.stax2.internNames";
        private static final String INTERN_NS = "org.codehaus.stax2.internNsUris";
        private QNamesMap inElementsMap;
        private Map<QName, QName> inAppendMap = new HashMap<QName, QName>(5);
        private Map<String, String> nsMap = new HashMap<String, String>(5);
        private QName currentQName;
        private QName previousQName;
        private int previousDepth = -1;

        public InTransformReader(XMLStreamReader reader, Map<String, String> inMap, Map<String, String> appendMap) {
            super(reader);
            this.inElementsMap = new QNamesMap(inMap == null ? 0 : inMap.size());
            AbstractJAXBProvider.convertToQNamesMap(inMap, this.inElementsMap, this.nsMap);
            AbstractJAXBProvider.convertToMapOfQNames(appendMap, this.inAppendMap);
        }

        @Override
        public int next() throws XMLStreamException {
            if (this.currentQName != null) {
                return 1;
            }
            if (this.previousDepth != -1 && this.previousDepth == this.getDepth() + 1) {
                this.previousDepth = -1;
                return 2;
            }
            return super.next();
        }

        @Override
        public Object getProperty(String name) throws IllegalArgumentException {
            if (INTERN_NAMES.equals(name) || INTERN_NS.equals(name)) {
                return Boolean.FALSE;
            }
            return super.getProperty(name);
        }

        @Override
        public String getLocalName() {
            QName cQName = this.getCurrentName();
            if (cQName != null) {
                String name = cQName.getLocalPart();
                this.resetCurrentQName();
                return name;
            }
            return super.getLocalName();
        }

        private QName getCurrentName() {
            return this.currentQName != null ? this.currentQName : (this.previousQName != null ? this.previousQName : null);
        }

        private void resetCurrentQName() {
            this.currentQName = this.previousQName;
            this.previousQName = null;
        }

        @Override
        public NamespaceContext getNamespaceContext() {
            return new DelegatingNamespaceContext(super.getNamespaceContext(), this.nsMap);
        }

        @Override
        public String getNamespaceURI() {
            QName theName = this.readCurrentElement();
            QName appendQName = this.inAppendMap.remove(theName);
            if (appendQName != null) {
                this.previousDepth = this.getDepth();
                this.previousQName = theName;
                this.currentQName = appendQName;
                return this.currentQName.getNamespaceURI();
            }
            QName expected = this.inElementsMap.get(theName);
            if (expected == null) {
                return theName.getNamespaceURI();
            }
            this.currentQName = expected;
            return this.currentQName.getNamespaceURI();
        }

        private QName readCurrentElement() {
            if (this.currentQName != null) {
                return this.currentQName;
            }
            String ns = super.getNamespaceURI();
            String name = super.getLocalName();
            return new QName(ns, name);
        }
    }

    private static class QNamesMap {
        private QName[] keys;
        private QName[] values;
        private int index;

        public QNamesMap(int size) {
            this.keys = new QName[size];
            this.values = new QName[size];
        }

        public void put(QName key, QName value) {
            this.keys[this.index] = key;
            this.values[this.index] = value;
            ++this.index;
        }

        public QName get(QName key) {
            for (int i = 0; i < this.keys.length; ++i) {
                if (!this.keys[i].getNamespaceURI().equals(key.getNamespaceURI())) continue;
                if (this.keys[i].getLocalPart().equals(key.getLocalPart())) {
                    return this.values[i];
                }
                if (!"*".equals(this.keys[i].getLocalPart())) continue;
                return "*".equals(this.values[i]) ? new QName(key.getLocalPart()) : new QName(this.values[i].getNamespaceURI(), key.getLocalPart());
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class OutTransformWriter
    extends DelegatingXMLStreamWriter {
        private QNamesMap elementsMap;
        private Map<QName, QName> appendMap = new HashMap<QName, QName>(5);
        private Map<String, String> nsMap = new HashMap<String, String>(5);
        private Set<String> prefixes = new HashSet<String>(2);
        private Set<String> writtenUris = new HashSet<String>(2);
        private Set<QName> dropElements;
        private List<Integer> droppingIndexes = new LinkedList<Integer>();
        private List<QName> appendedElements = new LinkedList<QName>();
        private List<Integer> appendedIndexes = new LinkedList<Integer>();
        private int currentDepth;
        private boolean attributesToElements;

        public OutTransformWriter(XMLStreamWriter writer, Map<String, String> outMap, Map<String, String> append, List<String> dropEls, boolean attributesToElements) {
            super(writer);
            this.elementsMap = new QNamesMap(outMap == null ? 0 : outMap.size());
            AbstractJAXBProvider.convertToQNamesMap(outMap, this.elementsMap, this.nsMap);
            AbstractJAXBProvider.convertToMapOfQNames(append, this.appendMap);
            this.dropElements = AbstractJAXBProvider.convertToSetOfQNames(dropEls);
            this.attributesToElements = attributesToElements;
        }

        @Override
        public void writeNamespace(String prefix, String uri) throws XMLStreamException {
            if (this.matchesDropped()) {
                return;
            }
            if (this.writtenUris.contains(uri)) {
                return;
            }
            String value = this.nsMap.get(uri);
            if (value != null && value.length() == 0) {
                return;
            }
            super.writeNamespace(prefix, value != null ? value : uri);
        }

        @Override
        public void writeStartElement(String prefix, String local, String uri) throws XMLStreamException {
            ++this.currentDepth;
            QName currentQName = new QName(uri, local);
            QName appendQName = this.appendMap.get(currentQName);
            if (appendQName != null && !this.appendedElements.contains(appendQName)) {
                ++this.currentDepth;
                String theprefix = uri.equals(appendQName.getNamespaceURI()) ? prefix : "";
                this.write(new QName(appendQName.getNamespaceURI(), appendQName.getLocalPart(), theprefix));
                if (theprefix.length() > 0) {
                    super.writeNamespace(theprefix, uri);
                    this.writtenUris.add(uri);
                }
                this.appendedElements.add(appendQName);
                this.appendedIndexes.add(this.currentDepth - 1);
            }
            if (this.dropElements.contains(currentQName)) {
                this.droppingIndexes.add(this.currentDepth - 1);
                return;
            }
            this.write(new QName(uri, local, prefix));
        }

        @Override
        public void writeEndElement() throws XMLStreamException {
            --this.currentDepth;
            if (this.indexRemoved(this.droppingIndexes)) {
                return;
            }
            super.writeEndElement();
            if (this.indexRemoved(this.appendedIndexes)) {
                super.writeEndElement();
            }
        }

        @Override
        public void writeCharacters(String text) throws XMLStreamException {
            if (this.matchesDropped()) {
                return;
            }
            super.writeCharacters(text);
        }

        private void write(QName qname) throws XMLStreamException {
            QName name = this.elementsMap.get(qname);
            if (name == null) {
                name = qname;
            }
            boolean writeNs = false;
            String prefix = "";
            if (name.getNamespaceURI().length() > 0) {
                if (qname.getPrefix().length() == 0) {
                    prefix = this.findUniquePrefix();
                    writeNs = true;
                } else {
                    prefix = qname.getPrefix();
                    this.prefixes.add(prefix);
                }
                this.prefixes.add(prefix);
            }
            super.writeStartElement(prefix, name.getLocalPart(), name.getNamespaceURI());
            if (writeNs) {
                this.writeNamespace(prefix, name.getNamespaceURI());
            }
        }

        private String findUniquePrefix() {
            int i = 0;
            while (this.prefixes.contains("ps" + ++i)) {
            }
            return "ps" + i;
        }

        private boolean matchesDropped() {
            int size = this.droppingIndexes.size();
            return size > 0 && this.droppingIndexes.get(size - 1) == this.currentDepth - 1;
        }

        private boolean indexRemoved(List<Integer> indexes) {
            int size = indexes.size();
            if (size > 0 && indexes.get(size - 1) == this.currentDepth) {
                indexes.remove(size - 1);
                return true;
            }
            return false;
        }

        @Override
        public NamespaceContext getNamespaceContext() {
            return new DelegatingNamespaceContext(super.getNamespaceContext(), this.nsMap);
        }

        @Override
        public void writeAttribute(String uri, String local, String value) throws XMLStreamException {
            if (!this.attributesToElements) {
                super.writeAttribute(uri, local, value);
            } else {
                this.writeAttributeAsElement(uri, local, value);
            }
        }

        @Override
        public void writeAttribute(String local, String value) throws XMLStreamException {
            if (!this.attributesToElements) {
                super.writeAttribute(local, value);
            } else {
                this.writeAttributeAsElement("", local, value);
            }
        }

        private void writeAttributeAsElement(String uri, String local, String value) throws XMLStreamException {
            this.writeStartElement(uri, local);
            this.writeCharacters(value);
            this.writeEndElement();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @XmlRootElement
    protected static class CollectionWrapper {
        @XmlAnyElement(lax=true)
        private List<?> l;

        protected CollectionWrapper() {
        }

        public void setList(List<?> list) {
            this.l = list;
        }

        public List<?> getList() {
            if (this.l == null) {
                this.l = new ArrayList();
            }
            return this.l;
        }

        public <T> Object getCollectionOrArray(Class<T> type, Class<?> origType) {
            Object first;
            List<?> theList = this.getList();
            if (theList.size() > 0 && (first = theList.get(0)) instanceof JAXBElement && !JAXBElement.class.isAssignableFrom(type)) {
                ArrayList newList = new ArrayList(theList.size());
                for (Object o : theList) {
                    newList.add(((JAXBElement)o).getValue());
                }
                theList = newList;
            }
            if (origType.isArray()) {
                Object[] values = (Object[])Array.newInstance(type, theList.size());
                for (int i = 0; i < theList.size(); ++i) {
                    values[i] = theList.get(i);
                }
                return values;
            }
            if (origType == Set.class) {
                return new HashSet(theList);
            }
            return theList;
        }
    }
}

