/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.java2wsdl.processor.internal.simple.generator;

import java.util.Map;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.common.model.JavaInterface;
import org.apache.cxf.tools.common.model.JavaModel;
import org.apache.cxf.tools.java2wsdl.processor.internal.simple.generator.AbstractSimpleGenerator;

public class SimpleImplGenerator
extends AbstractSimpleGenerator {
    private static final String IMPL_TEMPLATE = "org/apache/cxf/tools/java2wsdl/processor/internal/simple/generator/template/impl.vm";

    public SimpleImplGenerator() {
        this.name = "impl.generator";
    }

    public boolean passthrough() {
        Boolean genFromSei = (Boolean)this.env.get("genFromSEI");
        return genFromSei == false || !this.env.optionSet("server") || this.env.optionSet("implClass");
    }

    public void generate(ToolContext penv) throws ToolException {
        this.env = penv;
        JavaModel javaModel = this.env.get(JavaModel.class);
        if (this.passthrough()) {
            return;
        }
        Map<String, JavaInterface> interfaces = javaModel.getInterfaces();
        for (JavaInterface intf : interfaces.values()) {
            this.clearAttributes();
            this.setAttributes("intf", intf);
            this.setAttributes("seiClass", this.env.get("seiClass"));
            this.setCommonAttributes();
            this.doWrite(IMPL_TEMPLATE, this.parseOutputName(intf.getPackageName(), intf.getName() + "Impl"));
            this.env.put("implClass", intf.getFullClassName() + "Impl");
        }
    }
}

