/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import org.apache.cxf.transport.http.HttpURLConnectionFactory;
import org.apache.cxf.transport.http.HttpURLConnectionInfo;

public class HttpURLConnectionFactoryImpl
implements HttpURLConnectionFactory {
    public static final String HTTP_URL_PROTOCOL_ID = "http";

    public HttpURLConnection createConnection(Proxy proxy, URL url) throws IOException {
        if (!url.getProtocol().equals(HTTP_URL_PROTOCOL_ID)) {
            throw new IOException("Illegal Protocol " + url.getProtocol() + " for HTTP URLConnection Factory.");
        }
        if (proxy != null) {
            return (HttpURLConnection)url.openConnection(proxy);
        }
        return (HttpURLConnection)url.openConnection();
    }

    public HttpURLConnectionInfo getConnectionInfo(HttpURLConnection connection) throws IOException {
        return new HttpURLConnectionInfo(connection);
    }

    public String getProtocol() {
        return HTTP_URL_PROTOCOL_ID;
    }
}

