/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.security.interceptors.jrmp.ctxcheck;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import org.ow2.jonas.lib.bootstrap.JProp;

public class CtxCheckConfig {
    private static PublicKey publicKey = null;

    public CtxCheckConfig() {
        if (publicKey == null) {
            this.initConfig();
        }
    }

    public PublicKey getPublicKey() {
        return publicKey;
    }

    protected synchronized void initConfig() {
        Certificate cert;
        JProp props = JProp.getInstance();
        String keystoreFile = props.getValue("jonas.security.context.check.keystoreFile");
        if (keystoreFile == null) {
            throw new IllegalStateException("The 'jonas.security.context.check.keystoreFile' attribute was not found in the JOnAS configuration file but this attribute is mandatory");
        }
        String keystorePass = props.getValue("jonas.security.context.check.keystorePass");
        if (keystorePass == null) {
            throw new IllegalStateException("The 'jonas.security.context.check.keystorePass' attribute was not found in the JOnAS configuration file but this attribute is mandatory");
        }
        String alias = props.getValue("jonas.security.context.check.alias");
        if (alias == null) {
            throw new IllegalStateException("The 'jonas.security.context.check.alias' attribute was not found in the JOnAS configuration file but this attribute is mandatory");
        }
        File f = new File(keystoreFile);
        if (!f.exists()) {
            throw new IllegalStateException("The keystore file named '" + f + "' was not found.");
        }
        KeyStore keyStore = null;
        try {
            keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        }
        catch (KeyStoreException e) {
            throw new IllegalStateException("Error while getting a keystore ':" + e.getMessage());
        }
        try {
            keyStore.load(new BufferedInputStream(new FileInputStream(f)), keystorePass.toCharArray());
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Error while loading the keystore file '" + f + "'." + e.getMessage());
        }
        catch (CertificateException e) {
            throw new IllegalStateException("Error while loading the keystore file '" + f + "'." + e.getMessage());
        }
        catch (FileNotFoundException e) {
            throw new IllegalStateException("Error while loading the keystore file '" + f + "'." + e.getMessage());
        }
        catch (IOException e) {
            throw new IllegalStateException("Error while loading the keystore file '" + f + "'." + e.getMessage());
        }
        try {
            cert = keyStore.getCertificate(alias);
        }
        catch (KeyStoreException e) {
            throw new IllegalStateException("Error while getting the alias '" + alias + "' in the keystore file '" + keystoreFile + "':" + e.getMessage());
        }
        publicKey = cert.getPublicKey();
    }
}

