/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.pool.impl.enhanced.internal.lock.impl;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.LockSupport;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.pool.impl.enhanced.internal.lock.impl.BasicCondition;
import org.ow2.util.pool.impl.enhanced.internal.lock.impl.ILockWithSignalClearableConditionControl;
import org.ow2.util.pool.impl.enhanced.internal.lock.impl.ISignalClearableConditionControl;
import org.ow2.util.pool.impl.enhanced.internal.lock.impl.LockError;

public class BasicLock
implements Lock {
    private static final Log LOG = LogFactory.getLog(BasicLock.class);
    private AtomicBoolean locked = new AtomicBoolean(false);
    private Queue<Thread> waiters = new ConcurrentLinkedQueue<Thread>();
    private volatile Thread owner = null;
    private ILockWithSignalClearableConditionControl lockControl = new ILockWithSignalClearableConditionControl(){
        private Set<ISignalClearableConditionControl> toUnparkConditionSet = new HashSet<ISignalClearableConditionControl>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean innerLock(Long untilLong) {
            long until = 0L;
            if (untilLong != null) {
                until = untilLong;
            }
            LOG.debug((Object)"ask for lock {0}", new Object[]{BasicLock.this});
            boolean wasInterrupted = false;
            Thread current = Thread.currentThread();
            if (current == BasicLock.this.owner) {
                throw new IllegalStateException("This lock is not reentrent lock");
            }
            BasicLock.this.waiters.add(current);
            try {
                while (BasicLock.this.waiters.peek() != current || !BasicLock.this.locked.compareAndSet(false, true)) {
                    if (untilLong != null) {
                        if (wasInterrupted) {
                            current.interrupt();
                            boolean bl = false;
                            return bl;
                        }
                        if (System.currentTimeMillis() >= until) {
                            boolean bl = false;
                            return bl;
                        }
                        LockSupport.parkUntil(until);
                    } else {
                        LockSupport.park();
                    }
                    if (!Thread.interrupted()) continue;
                    wasInterrupted = true;
                }
            }
            finally {
                BasicLock.this.waiters.remove(current);
            }
            LOG.debug((Object)"lock obtained {0}", new Object[]{BasicLock.this});
            if (wasInterrupted) {
                current.interrupt();
            }
            BasicLock.this.owner = current;
            return true;
        }

        public void innerUnlock() {
            Iterator<ISignalClearableConditionControl> it = this.toUnparkConditionSet.iterator();
            block4: while (it.hasNext()) {
                switch (it.next().unparkOneThread()) {
                    case NOTHING_TO_SIGNAL: 
                    case SIGNALED_NO_MORE_THEAD: {
                        it.remove();
                        continue block4;
                    }
                    case SIGNALED: 
                    case ALREADY_SIGNALED: {
                        continue block4;
                    }
                }
                throw new LockError();
            }
            BasicLock.this.owner = null;
            LOG.debug((Object)"lock {0} release", new Object[]{BasicLock.this});
            BasicLock.this.locked.set(false);
            LockSupport.unpark((Thread)BasicLock.this.waiters.peek());
        }

        public void checkOwner() {
            if (Thread.currentThread() != BasicLock.this.owner) {
                throw new IllegalMonitorStateException();
            }
        }

        public void askForUnparkOneThread(ISignalClearableConditionControl basicCondition) {
            this.toUnparkConditionSet.add(basicCondition);
        }

        public void avoidAskForUnparkOneThread(ISignalClearableConditionControl basicCondition) {
            this.toUnparkConditionSet.remove(basicCondition);
        }
    };

    public void lock() {
        this.lockControl.innerLock(null);
    }

    public void unlock() {
        this.lockControl.checkOwner();
        this.lockControl.innerUnlock();
    }

    public void lockInterruptibly() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        this.lockControl.innerLock(null);
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
    }

    public BasicCondition newCondition() {
        return new BasicCondition(this.lockControl);
    }

    public boolean tryLock() {
        return this.lockControl.innerLock(System.currentTimeMillis());
    }

    public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        boolean innerLock = this.lockControl.innerLock(System.currentTimeMillis() + unit.toMillis(time));
        if (!innerLock && Thread.interrupted()) {
            throw new InterruptedException();
        }
        return innerLock;
    }
}

