/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.management.domain.cluster;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.jmx.JmxService;
import org.ow2.jonas.lib.management.domain.DomainMonitor;
import org.ow2.jonas.lib.management.domain.cluster.BaseClusterMBean;
import org.ow2.jonas.lib.management.domain.cluster.ClusterFactory;
import org.ow2.jonas.lib.management.domain.cluster.ClusterMember;
import org.ow2.jonas.lib.management.domain.proxy.clusterd.ClusterDaemonProxy;
import org.ow2.jonas.lib.management.domain.proxy.server.ServerProxy;
import org.ow2.jonas.lib.management.javaee.J2EEServerState;
import org.ow2.jonas.lib.util.JonasObjectName;
import org.ow2.jonas.lib.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseCluster
implements BaseClusterMBean {
    protected String name = null;
    protected ObjectName objectName = null;
    protected Map members = new HashMap();
    protected ClusterFactory cf;
    protected int state = 0;
    public static final int STATE_INIT = 0;
    public static final int STATE_UP = 1;
    public static final int STATE_DOWN = 2;
    public static final int STATE_FAILED = 3;
    public static final int STATE_PARTIALLY_FAILED = 4;
    public static final int STATE_PARTIALLY_UP = 5;
    public static final int STATE_PARTIALLY_DOWN = 6;
    public static final int STATE_UNKNOWN = 7;
    protected static Logger logger = Log.getLogger((String)"org.ow2.jonas.management.cluster");
    protected JmxService jmx = null;
    protected DomainMonitor dm;
    protected String domainName = null;

    public BaseCluster(ClusterFactory cf) {
        logger.log(BasicLevel.DEBUG, (Object)"");
        this.cf = cf;
        this.dm = cf.getDomainMonitor();
        this.domainName = this.dm.getDomainName();
        this.jmx = this.dm.getJmxService();
    }

    public abstract ClusterMember createClusterMember(String var1, ServerProxy var2);

    public ObjectName setName(String name) throws JMException {
        this.name = name;
        this.objectName = JonasObjectName.cluster((String)this.domainName, (String)name, (String)this.getType());
        return this.objectName;
    }

    public String getObjectName() {
        return this.objectName.toString();
    }

    public abstract String getType();

    public synchronized boolean addMember(ClusterMember m) {
        String mbr = m.getName();
        logger.log(BasicLevel.DEBUG, (Object)mbr);
        this.members.put(mbr, m);
        return true;
    }

    public synchronized ServerProxy getServerProxy(String name) {
        for (ClusterMember member : this.members.values()) {
            try {
                if (!member.getServerName().equals(name)) continue;
                return member.getProxy();
            }
            catch (JMException e) {
                logger.log(BasicLevel.WARN, (Object)("Cannot get server name: " + e));
                return null;
            }
        }
        return null;
    }

    public synchronized ServerProxy getRunningServerProxy() {
        Collection<ServerProxy> proxys = this.getServerProxyList();
        for (ServerProxy proxy : proxys) {
            if (!proxy.getJ2EEServerState().equals((Object)J2EEServerState.RUNNING)) continue;
            return proxy;
        }
        return null;
    }

    public synchronized Collection<ServerProxy> getServerProxyList() {
        ArrayList<ServerProxy> ret = new ArrayList<ServerProxy>();
        for (ClusterMember m : this.members.values()) {
            ret.add(m.getProxy());
        }
        return ret;
    }

    @Override
    public String getState() {
        this.updateState();
        switch (this.state) {
            case 0: {
                return "INIT";
            }
            case 1: {
                return "UP";
            }
            case 2: {
                return "DOWN";
            }
            case 3: {
                return "FAILED";
            }
            case 5: {
                return "PARTIALLY_UP";
            }
            case 6: {
                return "PARTIALLY_DOWN";
            }
            case 4: {
                return "PARTIALLY_FAILED";
            }
        }
        return "UNKNOWN";
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getNbMembers() {
        return this.members.size();
    }

    @Override
    public synchronized String[] getMembers() {
        logger.log(BasicLevel.DEBUG, (Object)"");
        Collection col = this.members.values();
        String[] result = new String[col.size()];
        int i = 0;
        for (ClusterMember m : col) {
            result[i++] = m.getObjectName().toString();
        }
        return result;
    }

    @Override
    @Deprecated
    public void addServer(String name, String[] urls, String clusterd) throws JMException {
        this.addServer(name, urls, clusterd, null, null);
    }

    @Override
    public void addServer(String svname, String[] urls, String cdn, String username, String password) throws JMException {
        ClusterMember member;
        boolean added;
        ServerProxy proxy;
        ClusterDaemonProxy cdp = null;
        if (cdn != null && cdn.length() > 0 && (cdp = this.dm.findClusterDaemonProxy(cdn)) == null) {
            logger.log(BasicLevel.WARN, (Object)("Unknown ClusterDaemon :" + cdn));
        }
        if ((proxy = this.dm.findServerProxy(svname)) == null) {
            ArrayList<String> urlcol = new ArrayList<String>();
            for (int i = 0; i < urls.length; ++i) {
                urlcol.add(urls[i]);
            }
            if (username != null && password != null) {
                try {
                    this.dm.addAuthenticationInformation(svname, username, password);
                }
                catch (UnsupportedEncodingException e) {
                    throw new JMException("Failed saving authentication information for server " + svname + ": " + e.getLocalizedMessage());
                }
            }
            proxy = new ServerProxy(this.dm, svname, urlcol, cdp);
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("Adding server : " + svname));
            }
            ObjectName on = JonasObjectName.serverProxy((String)this.domainName, (String)svname);
            proxy.setObjectName(on.toString());
        }
        if (!(added = this.addMember(member = this.createClusterMember(svname, proxy)))) {
            throw new RuntimeException("Server already in cluster: " + svname);
        }
        ObjectName on = JonasObjectName.clusterMember((String)this.domainName, (String)svname, (String)this.getType(), (String)this.name);
        member.setObjectName(on);
        MBeanServer mbeanServer = this.jmx.getJmxServer();
        if (mbeanServer.isRegistered(on)) {
            mbeanServer.unregisterMBean(on);
        }
        mbeanServer.registerMBean(member, on);
        this.dm.notifyServerProxyRunning(proxy);
    }

    @Override
    public synchronized void removeServer(String svname) {
        this.dm.removeAuthenticationInformation(svname);
        this.members.remove(svname);
    }

    public synchronized boolean isMember(String serverName) {
        return this.members.containsKey(serverName);
    }

    @Override
    public synchronized void startit() throws JMException {
        for (ClusterMember m : this.members.values()) {
            DeployThread th = new DeployThread(m.getProxy(), null, 5, false);
            th.start();
        }
    }

    @Override
    public synchronized void stopit() throws JMException {
        for (ClusterMember m : this.members.values()) {
            DeployThread th = new DeployThread(m.getProxy(), null, 6, false);
            th.start();
        }
    }

    @Override
    public synchronized void deployModule(String file) {
        for (ClusterMember m : this.members.values()) {
            DeployThread th = new DeployThread(m.getProxy(), file, 1, false);
            th.start();
        }
    }

    @Override
    public synchronized void undeployModule(String file) {
        for (ClusterMember m : this.members.values()) {
            DeployThread th = new DeployThread(m.getProxy(), file, 2, false);
            th.start();
        }
    }

    @Override
    public void uploadFile(String file, boolean repl) {
        for (ClusterMember m : this.members.values()) {
            DeployThread th = new DeployThread(m.getProxy(), file, 3, repl);
            th.start();
        }
    }

    @Override
    public synchronized void uploadDeployModule(String file, boolean repl) {
        for (ClusterMember m : this.members.values()) {
            DeployThread th = new DeployThread(m.getProxy(), file, 4, repl);
            th.start();
        }
    }

    private synchronized void updateState() {
        int nbFailed = 0;
        int nbRunning = 0;
        int nbStopped = 0;
        int nbInitial = 0;
        int nbMembers = 0;
        for (ClusterMember member : this.members.values()) {
            String memberState = member.getState();
            if (J2EEServerState.UNKNOWN.toString().equals(memberState) || J2EEServerState.INITIAL.toString().equals(memberState)) {
                ++nbInitial;
            } else if (J2EEServerState.RUNNING.toString().equals(memberState) || J2EEServerState.STANDBY.toString().equals(memberState)) {
                ++nbRunning;
            } else if (J2EEServerState.FAILED.toString().equals(memberState)) {
                ++nbFailed;
            } else if (J2EEServerState.STOPPED.toString().equals(memberState)) {
                ++nbStopped;
            }
            ++nbMembers;
        }
        this.state = nbInitial == nbMembers ? 0 : (nbFailed == nbMembers ? 3 : (nbRunning == nbMembers ? 1 : (nbStopped == nbMembers ? 2 : (nbFailed > 0 ? 4 : (nbRunning > 0 ? 5 : (nbStopped > 0 ? 6 : 7))))));
    }

    public class DeployThread
    extends Thread {
        private ServerProxy proxy;
        private String filename;
        private int action;
        private boolean replace;

        public DeployThread(ServerProxy proxy, String filename, int action, boolean replace) {
            this.proxy = proxy;
            this.filename = filename;
            this.action = action;
            this.replace = replace;
        }

        public void run() {
            switch (this.action) {
                case 5: {
                    this.proxy.start(false);
                    break;
                }
                case 6: {
                    this.proxy.stop(false);
                    break;
                }
                case 1: {
                    this.proxy.deployModule(this.filename);
                    break;
                }
                case 2: {
                    this.proxy.undeployModule(this.filename);
                    break;
                }
                case 4: {
                    this.proxy.uploadDeployModule(this.filename, this.replace);
                    break;
                }
                case 3: {
                    this.proxy.uploadFile(this.filename, this.replace);
                }
            }
        }
    }
}

