/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.compiler.lib;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.objectweb.jorm.api.JormConfigurator;
import org.objectweb.jorm.api.PException;
import org.objectweb.jorm.compiler.api.JormCompilerConfigurator;
import org.objectweb.jorm.compiler.api.JormCompilerParameter;
import org.objectweb.jorm.compiler.api.PExceptionCompiler;
import org.objectweb.jorm.compiler.lib.JormCompilerConfiguratorImpl;
import org.objectweb.jorm.compiler.lib.JormCompilerParameterImpl;
import org.objectweb.jorm.generator.api.Generator;
import org.objectweb.jorm.metainfo.api.Class;
import org.objectweb.jorm.metainfo.api.CompositeName;
import org.objectweb.jorm.metainfo.api.Manager;
import org.objectweb.jorm.metainfo.api.MetaObject;
import org.objectweb.jorm.mi2xml.api.Writer;
import org.objectweb.jorm.util.api.Loggable;
import org.objectweb.jorm.util.io.api.TargetHolder;
import org.objectweb.jorm.util.io.lib.JavaFileHolder;
import org.objectweb.jorm.verifier.api.Verifier;
import org.objectweb.jorm.xml2mi.api.Parser;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;

public class JormCompiler {
    protected Logger logger;
    protected LoggerFactory loggerFactory = null;
    protected Manager manager;
    protected Parser parser;
    protected Verifier verifier;
    protected Generator generator;
    protected Writer writer;
    protected JormCompilerParameter compilerParameter;
    protected JormCompilerConfigurator compilerConfigurator;

    public JormCompiler() {
        this.compilerParameter = new JormCompilerParameterImpl();
        this.compilerConfigurator = new JormCompilerConfiguratorImpl();
    }

    public JormCompiler(JormCompilerParameter cp, JormCompilerConfigurator cc) {
        this.compilerParameter = cp;
        this.compilerConfigurator = cc;
    }

    public JormCompilerParameter getCompilerParameter() {
        return this.compilerParameter;
    }

    public JormCompilerConfigurator getCompilerConfigurator() {
        return this.compilerConfigurator;
    }

    public void setupLogger() throws PException {
        if (this.loggerFactory != null) {
            this.logger.log(BasicLevel.DEBUG, (Object)"The log system is already setup");
            return;
        }
        this.loggerFactory = this.compilerConfigurator.getLoggerFactory();
        this.logger = this.loggerFactory.getLogger("org.objectweb.jorm.compiler");
        this.logger.log(BasicLevel.DEBUG, (Object)"Logger factory assigned");
    }

    public void setupMIManager() throws PException {
        if (this.manager != null) {
            this.logger.log(BasicLevel.DEBUG, (Object)"The MI manager is already defined");
            return;
        }
        this.logger.log(BasicLevel.DEBUG, (Object)"Instanciate the meta-information manager");
        this.manager = this.compilerConfigurator.getMIManager();
        this.compilerConfigurator.configureMIManager(this.manager);
    }

    public void setupParser() throws PException {
        if (this.parser != null) {
            this.logger.log(BasicLevel.DEBUG, (Object)"The parser is already defined");
            return;
        }
        this.logger.log(BasicLevel.DEBUG, (Object)"Instanciate the parser");
        this.parser = this.compilerConfigurator.getParser();
        this.compilerConfigurator.configureParser(this.parser, this.compilerParameter.getDtdLocations(), this.compilerParameter.getClasspath(), this.manager);
    }

    public void setupVerifier() throws PException {
        if (this.verifier != null) {
            this.logger.log(BasicLevel.DEBUG, (Object)"The verifier is already defined");
            return;
        }
        this.logger.log(BasicLevel.DEBUG, (Object)"Instanciate the verifier");
        this.verifier = this.compilerConfigurator.getVerifier();
        ((Loggable)this.verifier).setLoggerFactory(this.loggerFactory);
        ((Loggable)this.verifier).setLogger(this.loggerFactory.getLogger("org.objectweb.jorm.verifier"));
        this.verifier.setMetaInfoManager(this.manager);
        this.verifier.setProjectName(this.compilerParameter.getProjectName());
        Iterator it = this.compilerConfigurator.knownMappers();
        while (it.hasNext()) {
            String mn = (String)it.next();
            this.logger.log(BasicLevel.DEBUG, (Object)("Register specific verifier for mapper [" + mn + "]"));
            this.verifier.addMappingVerifier(mn, this.compilerConfigurator.getMappingVerifier(mn));
        }
    }

    public void setupGenerator() throws PException {
        if (this.generator != null) {
            this.logger.log(BasicLevel.DEBUG, (Object)"The generator is already defined");
            return;
        }
        this.logger.log(BasicLevel.DEBUG, (Object)"Instanciate the generator");
        this.generator = this.compilerConfigurator.getGenerator();
        ((Loggable)this.generator).setLogger(this.loggerFactory.getLogger("org.objectweb.jorm.generator"));
        ((Loggable)this.generator).setLoggerFactory(this.loggerFactory);
        this.generator.setPathExplorer(this.compilerParameter.getClasspath());
        this.generator.setMetaInfoManager(this.manager);
        this.generator.setCompilerConfigurator(this.compilerConfigurator);
        this.generator.setCompilerParameter(this.compilerParameter);
        this.generator.init();
        Iterator it = this.compilerConfigurator.knownMappers();
        while (it.hasNext()) {
            String mn = (String)it.next();
            this.logger.log(BasicLevel.DEBUG, (Object)("Register specific generator for mapper [" + mn + "]"));
            this.generator.addMappingGenerator(mn, this.compilerConfigurator.getMOPFactory(mn));
        }
    }

    public void process() throws PException {
        this.setupLogger();
        this.logger.log(BasicLevel.DEBUG, (Object)("process with jormc; files:" + this.compilerParameter.getInputFiles()));
        Collection metaObjects = this.parseFiles(this.compilerParameter.getInputFiles());
        this.logger.log(BasicLevel.DEBUG, (Object)("generates " + metaObjects.size() + "jorm files"));
        if (this.compilerParameter.isGeneratedPDFiles()) {
            this.generateJormFiles(metaObjects);
        }
        if (!this.compilerParameter.isParseOnly()) {
            Collection javafiles = this.generateFiles(metaObjects);
            if (this.compilerParameter.isJavac()) {
                this.compileFiles(javafiles);
            }
        }
    }

    public Collection parseFiles(Collection fns) throws PException {
        this.setupLogger();
        this.setupMIManager();
        this.setupParser();
        this.logger.log(BasicLevel.DEBUG, (Object)"parsing of files");
        return this.parser.parse(fns.iterator());
    }

    public void verifyMetaInfo(Collection mos) throws PException {
        this.setupLogger();
        this.setupVerifier();
        this.verifier.verify(mos);
    }

    public Collection generateFiles(Collection c) throws PException {
        Iterator mos;
        JavaFileHolder targetHolder;
        this.setupLogger();
        this.setupMIManager();
        this.setupGenerator();
        this.logger.log(BasicLevel.DEBUG, (Object)("Output directory=" + this.compilerParameter.getOutput()));
        try {
            targetHolder = new JavaFileHolder(this.compilerParameter.getOutput());
        }
        catch (Exception e) {
            throw new PExceptionCompiler(e, "Impossible to create a JavaFileHolder");
        }
        String trmaps = "Generation for the following target mappers: ";
        String SEP = "";
        Iterator it = this.compilerConfigurator.knownMappers();
        while (it.hasNext()) {
            String mn = (String)it.next();
            trmaps = trmaps + SEP + mn;
            SEP = ", ";
        }
        this.logger.log(BasicLevel.INFO, (Object)(trmaps + "."));
        Iterator iterator = mos = c != null ? c.iterator() : this.manager.getJormObjects().iterator();
        while (mos.hasNext()) {
            MetaObject o = (MetaObject)mos.next();
            if (o instanceof CompositeName) {
                this.logger.log(BasicLevel.INFO, (Object)("Generation for the [" + ((CompositeName)o).getName() + "] composite name"));
                this.generator.generate((CompositeName)o, (TargetHolder)targetHolder, this.compilerParameter);
                continue;
            }
            if (o instanceof Class) {
                this.logger.log(BasicLevel.INFO, (Object)("Generation for the [" + ((Class)o).getName() + "] class"));
                try {
                    this.generator.generate((Class)o, (TargetHolder)targetHolder, this.compilerParameter, this.compilerConfigurator);
                    continue;
                }
                catch (Exception e) {
                    this.logger.log(BasicLevel.ERROR, (Object)("Error during the generation of the class " + ((Class)o).getFQName()), (Throwable)e);
                    if (e instanceof PException) {
                        throw (PException)e;
                    }
                    throw new PExceptionCompiler(e, "Error during the generation of the class " + ((Class)o).getFQName());
                }
            }
            throw new PExceptionCompiler("Meta Object is not a class or a composite name : " + o);
        }
        ArrayList<String> al = new ArrayList<String>();
        it = targetHolder.iterateFile();
        while (it.hasNext()) {
            try {
                al.add(((File)it.next()).getCanonicalPath());
            }
            catch (IOException e) {
                throw new PException((Exception)e, "Cannot build the list of generated files.");
            }
        }
        return al;
    }

    public void compileFiles(Collection javafiles) throws PException {
        this.setupLogger();
        throw new UnsupportedOperationException("NOT YET IMPLEMENTED!");
    }

    public Manager getMIManager() {
        return this.manager;
    }

    public void setMIManager(Manager manager) {
        this.manager = manager;
    }

    public void setupWriter() throws PException {
        if (this.writer != null) {
            this.logger.log(BasicLevel.DEBUG, (Object)"The writer is already defined");
            return;
        }
        this.logger.log(BasicLevel.DEBUG, (Object)"Instanciate the jorm writer");
        this.writer = this.compilerConfigurator.getWriter();
        ((Loggable)this.writer).setLogger(this.loggerFactory.getLogger("org.objectweb.jorm.mi2xml"));
        ((Loggable)this.writer).setLoggerFactory(this.loggerFactory);
        this.writer.init((JormConfigurator)this.compilerConfigurator);
    }

    public Collection generateJormFiles(Collection c) throws PException {
        Iterator mos;
        JavaFileHolder targetHolder;
        this.setupLogger();
        this.setupMIManager();
        this.setupWriter();
        this.logger.log(BasicLevel.DEBUG, (Object)("Output directory=" + this.compilerParameter.getOutput()));
        try {
            targetHolder = new JavaFileHolder(this.compilerParameter.getOutput());
        }
        catch (Exception e) {
            throw new PExceptionCompiler(e, "Impossible to create a JavaFileHolder");
        }
        Iterator iterator = mos = c != null ? c.iterator() : this.manager.getJormObjects().iterator();
        while (mos.hasNext()) {
            MetaObject o = (MetaObject)mos.next();
            if (o instanceof CompositeName) {
                this.logger.log(BasicLevel.INFO, (Object)(".pd file generation for the [" + ((CompositeName)o).getName() + "] composite name"));
                this.writer.write(o, (TargetHolder)targetHolder);
                continue;
            }
            if (o instanceof Class) {
                this.logger.log(BasicLevel.INFO, (Object)(".pd file generation for the [" + ((Class)o).getName() + "] class"));
                try {
                    this.writer.write(o, (TargetHolder)targetHolder);
                    continue;
                }
                catch (Exception e) {
                    this.logger.log(BasicLevel.ERROR, (Object)("Error during the .pd file generation of the class " + ((Class)o).getFQName()), (Throwable)e);
                    if (e instanceof PException) {
                        throw (PException)e;
                    }
                    throw new PExceptionCompiler(e, "Error during the .pd file generation of the class " + ((Class)o).getFQName());
                }
            }
            throw new PExceptionCompiler("Meta Object is not a class or a composite name : " + o);
        }
        ArrayList<String> al = new ArrayList<String>();
        Iterator it = targetHolder.iterateFile();
        while (it.hasNext()) {
            try {
                al.add(((File)it.next()).getCanonicalPath());
            }
            catch (IOException e) {
                throw new PExceptionCompiler(e, "Impossible to retrieve File descriptors");
            }
        }
        return al;
    }
}

