/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.pool.impl.enhanced.internal.actionscheduler;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.pool.impl.enhanced.internal.actionscheduler.Average;
import org.ow2.util.pool.impl.enhanced.internal.actionscheduler.FutureTaskReallyCancellable;
import org.ow2.util.pool.impl.enhanced.internal.actionscheduler.IAction;
import org.ow2.util.pool.impl.enhanced.internal.actionscheduler.IActionScheduler;

public class ActionScheduler
implements IActionScheduler {
    private static final Log LOG = LogFactory.getLog(ActionScheduler.class);
    private static final int ELEMENT_TO_KEEP_FOR_AVERAGE_COMPUTATION = 20;
    private LinkedList<Future<Boolean>> scheduledCallableList;
    private IAction action;
    private Executor executor;
    private Object mutex = new Object();
    private Average average = new Average(20);

    public ActionScheduler(IAction action, Executor executor) {
        this.executor = executor;
        this.action = action;
        this.scheduledCallableList = new LinkedList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleAction(int time) {
        for (int i = 0; i < time; ++i) {
            FutureTaskReallyCancellable<Boolean> futureTask = new FutureTaskReallyCancellable<Boolean>((Callable)this.action){
                private long startTime;

                @Override
                public void run() {
                    this.startTime = System.currentTimeMillis();
                    super.run();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void done() {
                    if (!this.isCancelled()) {
                        Object object = ActionScheduler.this.mutex;
                        synchronized (object) {
                            ActionScheduler.this.scheduledCallableList.remove(this);
                        }
                        try {
                            if (((Boolean)this.get()).booleanValue()) {
                                ActionScheduler.this.average.addElement(System.currentTimeMillis() - this.startTime);
                            }
                        }
                        catch (InterruptedException e) {
                            LOG.error((Object)"No InterruptedException on done task expected", new Object[]{e});
                        }
                        catch (ExecutionException e) {
                            LOG.error((Object)"Task failed", new Object[]{e});
                        }
                    }
                }
            };
            Object object = this.mutex;
            synchronized (object) {
                this.scheduledCallableList.addFirst((Future<Boolean>)futureTask);
            }
            this.executor.execute(futureTask);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int cancelAction(int time) {
        Object object = this.mutex;
        synchronized (object) {
            int canceledSheduledCallable = 0;
            Iterator iterator = this.scheduledCallableList.iterator();
            while (iterator.hasNext() && canceledSheduledCallable < time) {
                Future future = (Future)iterator.next();
                if (!future.cancel(false)) continue;
                ++canceledSheduledCallable;
                iterator.remove();
            }
            return canceledSheduledCallable;
        }
    }
}

