/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.connector;

import java.util.Iterator;
import java.util.Set;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.jms.XAConnection;
import javax.jms.XAConnectionFactory;
import javax.jms.XATopicConnection;
import javax.jms.XATopicConnectionFactory;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.resource.ResourceException;
import javax.resource.spi.CommException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.SecurityException;
import javax.security.auth.Subject;
import org.objectweb.joram.client.connector.AdapterTracing;
import org.objectweb.joram.client.connector.ConnectionRequest;
import org.objectweb.joram.client.connector.DefaultConnectionManager;
import org.objectweb.joram.client.connector.ManagedConnectionFactoryImpl;
import org.objectweb.joram.client.connector.ManagedConnectionImpl;
import org.objectweb.joram.client.connector.OutboundTopicConnectionFactory;
import org.objectweb.joram.client.connector.TopicConnectionRequest;
import org.objectweb.joram.client.jms.admin.AbstractConnectionFactory;
import org.objectweb.joram.client.jms.ha.local.XAHALocalConnectionFactory;
import org.objectweb.joram.client.jms.ha.local.XATopicHALocalConnectionFactory;
import org.objectweb.joram.client.jms.ha.tcp.XAHATcpConnectionFactory;
import org.objectweb.joram.client.jms.ha.tcp.XATopicHATcpConnectionFactory;
import org.objectweb.joram.client.jms.local.XALocalConnectionFactory;
import org.objectweb.joram.client.jms.local.XATopicLocalConnectionFactory;
import org.objectweb.joram.client.jms.tcp.XATcpConnectionFactory;
import org.objectweb.joram.client.jms.tcp.XATopicTcpConnectionFactory;
import org.objectweb.util.monolog.api.BasicLevel;

public class ManagedTopicConnectionFactoryImpl
extends ManagedConnectionFactoryImpl {
    private static final long serialVersionUID = 1L;

    public Object createConnectionFactory(ConnectionManager cxManager) throws ResourceException {
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)(this + " createConnectionFactory(" + cxManager + ")"));
        }
        return new OutboundTopicConnectionFactory(this, cxManager);
    }

    public Object createConnectionFactory() throws ResourceException {
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)(this + " createConnectionFactory()"));
        }
        OutboundTopicConnectionFactory factory = new OutboundTopicConnectionFactory(this, DefaultConnectionManager.getRef());
        Reference ref = new Reference(factory.getClass().getName(), "org.objectweb.joram.client.connector.ObjectFactoryImpl", null);
        ref.add(new StringRefAddr("hostName", this.hostName));
        ref.add(new StringRefAddr("serverPort", "" + this.serverPort));
        ref.add(new StringRefAddr("userName", this.userName));
        ref.add(new StringRefAddr("password", this.password));
        ref.add(new StringRefAddr("identityClass", this.identityClass));
        factory.setReference(ref);
        return factory;
    }

    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo cxRequest) throws ResourceException {
        String identityClass;
        String password;
        String userName;
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)(this + " createManagedConnection(" + subject + ", " + cxRequest + ")"));
        }
        String hostName = this.hostName;
        int serverPort = this.serverPort;
        if (cxRequest == null) {
            userName = this.userName;
            password = this.password;
            identityClass = this.identityClass;
        } else {
            if (!(cxRequest instanceof ConnectionRequest)) {
                if (this.out != null) {
                    this.out.print("Provided ConnectionRequestInfo instance is not a JORAM object.");
                }
                throw new ResourceException("Provided ConnectionRequestInfo instance is not a JORAM object.");
            }
            userName = ((ConnectionRequest)cxRequest).getUserName();
            password = ((ConnectionRequest)cxRequest).getPassword();
            identityClass = ((ConnectionRequest)cxRequest).getIdentityClass();
        }
        XATopicConnection cnx = null;
        if (this.collocated) {
            hostName = "localhost";
            serverPort = -1;
        }
        try {
            XATopicConnectionFactory factory;
            if (this.isHa) {
                if (this.collocated) {
                    if (this.ra.haURL != null) {
                        if (cxRequest instanceof TopicConnectionRequest) {
                            factory = XATopicHATcpConnectionFactory.create((String)this.ra.haURL);
                            this.setParameters(factory);
                            ((AbstractConnectionFactory)factory).setIdentityClassName(identityClass);
                            cnx = factory.createXATopicConnection(userName, password);
                        } else {
                            factory = XAHATcpConnectionFactory.create((String)this.ra.haURL);
                            this.setParameters(factory);
                            ((AbstractConnectionFactory)factory).setIdentityClassName(identityClass);
                            cnx = factory.createXAConnection(userName, password);
                        }
                    } else if (cxRequest instanceof TopicConnectionRequest) {
                        factory = XATopicHALocalConnectionFactory.create();
                        this.setParameters(factory);
                        ((AbstractConnectionFactory)factory).setIdentityClassName(identityClass);
                        cnx = factory.createXATopicConnection(userName, password);
                    } else {
                        factory = XAHALocalConnectionFactory.create();
                        this.setParameters(factory);
                        ((AbstractConnectionFactory)factory).setIdentityClassName(identityClass);
                        cnx = factory.createXAConnection(userName, password);
                    }
                } else {
                    String urlHa = "hajoram://" + hostName + ":" + serverPort;
                    if (cxRequest instanceof TopicConnectionRequest) {
                        XATopicConnectionFactory factory2 = XATopicHATcpConnectionFactory.create((String)urlHa);
                        this.setParameters(factory2);
                        ((AbstractConnectionFactory)factory2).setIdentityClassName(identityClass);
                        cnx = factory2.createXATopicConnection(userName, password);
                    } else {
                        XAConnectionFactory factory3 = XAHATcpConnectionFactory.create((String)urlHa);
                        this.setParameters(factory3);
                        ((AbstractConnectionFactory)factory3).setIdentityClassName(identityClass);
                        cnx = factory3.createXAConnection(userName, password);
                    }
                }
            } else if (this.collocated) {
                if (cxRequest instanceof TopicConnectionRequest) {
                    factory = XATopicLocalConnectionFactory.create();
                    this.setParameters(factory);
                    ((AbstractConnectionFactory)factory).setIdentityClassName(identityClass);
                    cnx = factory.createXATopicConnection(userName, password);
                } else {
                    factory = XALocalConnectionFactory.create();
                    this.setParameters(factory);
                    ((AbstractConnectionFactory)factory).setIdentityClassName(identityClass);
                    cnx = factory.createXAConnection(userName, password);
                }
            } else if (cxRequest instanceof TopicConnectionRequest) {
                factory = XATopicTcpConnectionFactory.create((String)hostName, (int)serverPort);
                this.setParameters(factory);
                ((AbstractConnectionFactory)factory).setIdentityClassName(identityClass);
                cnx = factory.createXATopicConnection(userName, password);
            } else {
                factory = XATcpConnectionFactory.create((String)hostName, (int)serverPort);
                this.setParameters(factory);
                ((AbstractConnectionFactory)factory).setIdentityClassName(identityClass);
                cnx = factory.createXAConnection(userName, password);
            }
            if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
                AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)(this + " createManagedConnection cnx = " + cnx));
            }
        }
        catch (IllegalStateException exc) {
            if (this.out != null) {
                this.out.print("Could not access the JORAM server: " + (Object)((Object)exc));
            }
            throw new CommException("Could not access the JORAM server: " + (Object)((Object)exc));
        }
        catch (JMSSecurityException exc) {
            if (this.out != null) {
                this.out.print("Invalid user identification: " + (Object)((Object)exc));
            }
            throw new SecurityException("Invalid user identification: " + (Object)((Object)exc));
        }
        catch (JMSException exc) {
            if (this.out != null) {
                this.out.print("Failed connecting process: " + (Object)((Object)exc));
            }
            throw new ResourceException("Failed connecting process: " + (Object)((Object)exc));
        }
        ManagedConnectionImpl managedCx = new ManagedConnectionImpl(this.ra, (XAConnection)cnx, hostName, serverPort, userName);
        managedCx.setLogWriter(this.out);
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)(this + " createManagedConnection managedCx = " + managedCx));
        }
        return managedCx;
    }

    public ManagedConnection matchManagedConnections(Set connectionSet, Subject subject, ConnectionRequestInfo cxRequest) throws ResourceException {
        String userName;
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)(this + " matchManagedConnections(" + connectionSet + ", " + subject + ", " + cxRequest + ")"));
        }
        String mode = "Unified";
        if (cxRequest == null) {
            userName = this.userName;
        } else {
            if (!(cxRequest instanceof ConnectionRequest)) {
                if (this.out != null) {
                    this.out.print("Provided ConnectionRequestInfo instance is not a JORAM object.");
                }
                throw new ResourceException("Provided ConnectionRequestInfo instance is not a JORAM object.");
            }
            userName = ((ConnectionRequest)cxRequest).getUserName();
            if (cxRequest instanceof TopicConnectionRequest) {
                mode = "PubSub";
            }
        }
        String hostName = this.hostName;
        int serverPort = this.serverPort;
        if (this.collocated) {
            hostName = "localhost";
            serverPort = -1;
        }
        ManagedConnectionImpl managedCx = null;
        boolean matching = false;
        Iterator it = connectionSet.iterator();
        while (!matching && it.hasNext()) {
            try {
                managedCx = (ManagedConnectionImpl)it.next();
                matching = managedCx.matches(hostName, serverPort, userName, mode);
            }
            catch (ClassCastException exc) {}
        }
        if (matching) {
            if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
                AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)(this + " matchManagedConnections match " + managedCx));
            }
            managedCx.setLogWriter(this.out);
            return managedCx;
        }
        return null;
    }

    public int hashCode() {
        return ("PubSub:" + this.hostName + ":" + this.serverPort + "-" + this.userName).hashCode();
    }

    public boolean equals(Object o) {
        boolean res;
        if (!(o instanceof ManagedTopicConnectionFactoryImpl)) {
            return false;
        }
        ManagedConnectionFactoryImpl other = (ManagedConnectionFactoryImpl)o;
        boolean bl = res = this.hostName.equals(other.hostName) && this.serverPort == other.serverPort && this.userName.equals(other.userName);
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)(this + " equals = " + res));
        }
        return res;
    }
}

