/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import org.hibernate.MappingException;
import org.hibernate.annotations.AccessType;
import org.hibernate.annotations.Target;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.cfg.PropertyData;

public class PropertyInferredData
implements PropertyData {
    private final String defaultAccess;
    private final XProperty property;
    private final ReflectionManager reflectionManager;

    public PropertyInferredData(XProperty property, String propertyAccessor, ReflectionManager reflectionManager) {
        this.property = property;
        this.defaultAccess = propertyAccessor;
        this.reflectionManager = reflectionManager;
    }

    public String getDefaultAccess() throws MappingException {
        AccessType access = this.property.getAnnotation(AccessType.class);
        return access != null ? access.value() : this.defaultAccess;
    }

    public String getPropertyName() throws MappingException {
        return this.property.getName();
    }

    public XClass getPropertyClass() throws MappingException {
        if (this.property.isAnnotationPresent(Target.class)) {
            return this.reflectionManager.toXClass(this.property.getAnnotation(Target.class).value());
        }
        return this.property.getType();
    }

    public XClass getClassOrElement() throws MappingException {
        if (this.property.isAnnotationPresent(Target.class)) {
            return this.reflectionManager.toXClass(this.property.getAnnotation(Target.class).value());
        }
        return this.property.getClassOrElementClass();
    }

    public String getClassOrElementName() throws MappingException {
        return this.getClassOrElement().getName();
    }

    public String getTypeName() throws MappingException {
        return this.getPropertyClass().getName();
    }

    public XProperty getProperty() {
        return this.property;
    }
}

