/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.membership;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Properties;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.MembershipListener;
import org.apache.catalina.tribes.MembershipService;
import org.apache.catalina.tribes.membership.McastServiceImpl;
import org.apache.catalina.tribes.membership.MemberImpl;
import org.apache.catalina.tribes.util.Arrays;
import org.apache.catalina.tribes.util.StringManager;
import org.apache.catalina.tribes.util.UUIDGenerator;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class McastService
implements MembershipService,
MembershipListener {
    private static Log log = LogFactory.getLog(McastService.class);
    protected StringManager sm = StringManager.getManager("org.apache.catalina.tribes.membership");
    private static final String info = "McastService/2.1";
    protected Properties properties = new Properties();
    protected McastServiceImpl impl;
    protected MembershipListener listener;
    protected MemberImpl localMember;
    private int mcastSoTimeout;
    private int mcastTTL;
    protected byte[] payload;
    protected byte[] domain;
    protected static final Member[] EMPTY_MEMBERS = new Member[0];

    public McastService() {
        this.properties.setProperty("mcastPort", "45564");
        this.properties.setProperty("mcastAddress", "228.0.0.4");
        this.properties.setProperty("memberDropTime", "3000");
        this.properties.setProperty("mcastFrequency", "500");
    }

    public String getInfo() {
        return info;
    }

    public void setProperties(Properties properties) {
        this.hasProperty(properties, "mcastPort");
        this.hasProperty(properties, "mcastAddress");
        this.hasProperty(properties, "memberDropTime");
        this.hasProperty(properties, "mcastFrequency");
        this.hasProperty(properties, "tcpListenPort");
        this.hasProperty(properties, "tcpListenHost");
        this.properties = properties;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getLocalMemberName() {
        return this.localMember.toString();
    }

    public Member getLocalMember(boolean alive) {
        if (alive && this.localMember != null && this.impl != null) {
            this.localMember.setMemberAliveTime(System.currentTimeMillis() - this.impl.getServiceStartTime());
        }
        return this.localMember;
    }

    public void setLocalMemberProperties(String listenHost, int listenPort) {
        this.properties.setProperty("tcpListenHost", listenHost);
        this.properties.setProperty("tcpListenPort", String.valueOf(listenPort));
        try {
            if (this.localMember != null) {
                this.localMember.setHostname(listenHost);
                this.localMember.setPort(listenPort);
            } else {
                this.localMember = new MemberImpl(listenHost, listenPort, 0L);
                this.localMember.setUniqueId(UUIDGenerator.randomUUID(true));
                this.localMember.setPayload(this.getPayload());
                this.localMember.setDomain(this.getDomain());
            }
            this.localMember.getData(true, true);
        }
        catch (IOException x) {
            throw new IllegalArgumentException(x);
        }
    }

    public void setAddress(String addr) {
        this.properties.setProperty("mcastAddress", addr);
    }

    public void setMcastAddr(String addr) {
        this.setAddress(addr);
    }

    public String getAddress() {
        return this.properties.getProperty("mcastAddress");
    }

    public String getMcastAddr() {
        return this.getAddress();
    }

    public void setMcastBindAddress(String bindaddr) {
        this.setBind(bindaddr);
    }

    public void setBind(String bindaddr) {
        this.properties.setProperty("mcastBindAddress", bindaddr);
    }

    public String getMcastBindAddress() {
        return this.getBind();
    }

    public String getBind() {
        return this.properties.getProperty("mcastBindAddress");
    }

    public void setMcastPort(int port) {
        this.setPort(port);
    }

    public void setPort(int port) {
        this.properties.setProperty("mcastPort", String.valueOf(port));
    }

    public void setRecoveryCounter(int recoveryCounter) {
        this.properties.setProperty("recoveryCounter", String.valueOf(recoveryCounter));
    }

    public void setRecoveryEnabled(boolean recoveryEnabled) {
        this.properties.setProperty("recoveryEnabled", String.valueOf(recoveryEnabled));
    }

    public void setRecoverySleepTime(long recoverySleepTime) {
        this.properties.setProperty("recoverySleepTime", String.valueOf(recoverySleepTime));
    }

    public int getMcastPort() {
        return this.getPort();
    }

    public int getPort() {
        String p = this.properties.getProperty("mcastPort");
        return new Integer(p);
    }

    public void setMcastFrequency(long time) {
        this.setFrequency(time);
    }

    public void setFrequency(long time) {
        this.properties.setProperty("mcastFrequency", String.valueOf(time));
    }

    public long getMcastFrequency() {
        return this.getFrequency();
    }

    public long getFrequency() {
        String p = this.properties.getProperty("mcastFrequency");
        return new Long(p);
    }

    public void setMcastDropTime(long time) {
        this.setDropTime(time);
    }

    public void setDropTime(long time) {
        this.properties.setProperty("memberDropTime", String.valueOf(time));
    }

    public long getMcastDropTime() {
        return this.getDropTime();
    }

    public long getDropTime() {
        String p = this.properties.getProperty("memberDropTime");
        return new Long(p);
    }

    protected void hasProperty(Properties properties, String name) {
        if (properties.getProperty(name) == null) {
            throw new IllegalArgumentException("McastService:Required property \"" + name + "\" is missing.");
        }
    }

    public void start() throws Exception {
        this.start(4);
        this.start(8);
    }

    public void start(int level) throws Exception {
        this.hasProperty(this.properties, "mcastPort");
        this.hasProperty(this.properties, "mcastAddress");
        this.hasProperty(this.properties, "memberDropTime");
        this.hasProperty(this.properties, "mcastFrequency");
        this.hasProperty(this.properties, "tcpListenPort");
        this.hasProperty(this.properties, "tcpListenHost");
        if (this.impl != null) {
            this.impl.start(level);
            return;
        }
        String host = this.getProperties().getProperty("tcpListenHost");
        int port = Integer.parseInt(this.getProperties().getProperty("tcpListenPort"));
        if (this.localMember == null) {
            this.localMember = new MemberImpl(host, port, 100L);
            this.localMember.setUniqueId(UUIDGenerator.randomUUID(true));
        } else {
            this.localMember.setHostname(host);
            this.localMember.setPort(port);
            this.localMember.setMemberAliveTime(100L);
        }
        if (this.payload != null) {
            this.localMember.setPayload(this.payload);
        }
        if (this.domain != null) {
            this.localMember.setDomain(this.domain);
        }
        this.localMember.setServiceStartTime(System.currentTimeMillis());
        InetAddress bind = null;
        if (this.properties.getProperty("mcastBindAddress") != null) {
            bind = InetAddress.getByName(this.properties.getProperty("mcastBindAddress"));
        }
        int ttl = -1;
        int soTimeout = -1;
        if (this.properties.getProperty("mcastTTL") != null) {
            try {
                ttl = Integer.parseInt(this.properties.getProperty("mcastTTL"));
            }
            catch (Exception x) {
                log.error("Unable to parse mcastTTL=" + this.properties.getProperty("mcastTTL"), x);
            }
        }
        if (this.properties.getProperty("mcastSoTimeout") != null) {
            try {
                soTimeout = Integer.parseInt(this.properties.getProperty("mcastSoTimeout"));
            }
            catch (Exception x) {
                log.error("Unable to parse mcastSoTimeout=" + this.properties.getProperty("mcastSoTimeout"), x);
            }
        }
        this.impl = new McastServiceImpl(this.localMember, Long.parseLong(this.properties.getProperty("mcastFrequency")), Long.parseLong(this.properties.getProperty("memberDropTime")), Integer.parseInt(this.properties.getProperty("mcastPort")), bind, InetAddress.getByName(this.properties.getProperty("mcastAddress")), ttl, soTimeout, this);
        String value = this.properties.getProperty("recoveryEnabled", "true");
        boolean recEnabled = Boolean.valueOf(value);
        this.impl.setRecoveryEnabled(recEnabled);
        int recCnt = Integer.parseInt(this.properties.getProperty("recoveryCounter", "10"));
        this.impl.setRecoveryCounter(recCnt);
        long recSlpTime = Long.parseLong(this.properties.getProperty("recoverySleepTime", "5000"));
        this.impl.setRecoverySleepTime(recSlpTime);
        this.impl.start(level);
    }

    public void stop(int svc) {
        try {
            if (this.impl != null && this.impl.stop(svc)) {
                this.impl = null;
            }
        }
        catch (Exception x) {
            log.error("Unable to stop the mcast service, level:" + svc + ".", x);
        }
    }

    public String[] getMembersByName() {
        String[] membernames;
        Member[] currentMembers = this.getMembers();
        if (currentMembers != null) {
            membernames = new String[currentMembers.length];
            for (int i = 0; i < currentMembers.length; ++i) {
                membernames[i] = currentMembers[i].toString();
            }
        } else {
            membernames = new String[]{};
        }
        return membernames;
    }

    public Member findMemberByName(String name) {
        Member[] currentMembers = this.getMembers();
        for (int i = 0; i < currentMembers.length; ++i) {
            if (!name.equals(currentMembers[i].toString())) continue;
            return currentMembers[i];
        }
        return null;
    }

    public boolean hasMembers() {
        if (this.impl == null || this.impl.membership == null) {
            return false;
        }
        return this.impl.membership.hasMembers();
    }

    public Member getMember(Member mbr) {
        if (this.impl == null || this.impl.membership == null) {
            return null;
        }
        return this.impl.membership.getMember(mbr);
    }

    public Member[] getMembers() {
        if (this.impl == null || this.impl.membership == null) {
            return EMPTY_MEMBERS;
        }
        return this.impl.membership.getMembers();
    }

    public void setMembershipListener(MembershipListener listener) {
        this.listener = listener;
    }

    public void removeMembershipListener() {
        this.listener = null;
    }

    public void memberAdded(Member member) {
        if (this.listener != null) {
            this.listener.memberAdded(member);
        }
    }

    public void memberDisappeared(Member member) {
        if (this.listener != null) {
            this.listener.memberDisappeared(member);
        }
    }

    public int getMcastSoTimeout() {
        return this.getSoTimeout();
    }

    public int getSoTimeout() {
        return this.mcastSoTimeout;
    }

    public void setMcastSoTimeout(int mcastSoTimeout) {
        this.setSoTimeout(mcastSoTimeout);
    }

    public void setSoTimeout(int mcastSoTimeout) {
        this.mcastSoTimeout = mcastSoTimeout;
        this.properties.setProperty("mcastSoTimeout", String.valueOf(mcastSoTimeout));
    }

    public int getMcastTTL() {
        return this.getTtl();
    }

    public int getTtl() {
        return this.mcastTTL;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public byte[] getDomain() {
        return this.domain;
    }

    public void setMcastTTL(int mcastTTL) {
        this.setTtl(mcastTTL);
    }

    public void setTtl(int mcastTTL) {
        this.mcastTTL = mcastTTL;
        this.properties.setProperty("mcastTTL", String.valueOf(mcastTTL));
    }

    public void setPayload(byte[] payload) {
        this.payload = payload;
        if (this.localMember != null) {
            this.localMember.setPayload(payload);
            this.localMember.getData(true, true);
            try {
                if (this.impl != null) {
                    this.impl.send(false);
                }
            }
            catch (Exception x) {
                log.error("Unable to send payload update.", x);
            }
        }
    }

    public void setDomain(byte[] domain) {
        this.domain = domain;
        if (this.localMember != null) {
            this.localMember.setDomain(domain);
            this.localMember.getData(true, true);
            try {
                if (this.impl != null) {
                    this.impl.send(false);
                }
            }
            catch (Exception x) {
                log.error("Unable to send domain update.", x);
            }
        }
    }

    public void setDomain(String domain) {
        if (domain == null) {
            return;
        }
        if (domain.startsWith("{")) {
            this.setDomain(Arrays.fromString(domain));
        } else {
            this.setDomain(Arrays.convert(domain));
        }
    }

    public static void main(String[] args) throws Exception {
        if (log.isInfoEnabled()) {
            log.info("Usage McastService hostname tcpport");
        }
        McastService service = new McastService();
        Properties p = new Properties();
        p.setProperty("mcastPort", "5555");
        p.setProperty("mcastAddress", "224.10.10.10");
        p.setProperty("mcastClusterDomain", "catalina");
        p.setProperty("bindAddress", "localhost");
        p.setProperty("memberDropTime", "3000");
        p.setProperty("mcastFrequency", "500");
        p.setProperty("tcpListenPort", "4000");
        p.setProperty("tcpListenHost", "127.0.0.1");
        service.setProperties(p);
        service.start();
        Thread.sleep(3600000L);
    }
}

