/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.mom.dest;

import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.common.Debug;
import java.util.Enumeration;
import java.util.Properties;
import org.objectweb.joram.mom.dest.DistributionModule;
import org.objectweb.joram.mom.dest.Topic;
import org.objectweb.joram.mom.notifications.ClientMessages;
import org.objectweb.joram.shared.excepts.RequestException;
import org.objectweb.joram.shared.messages.ConversionHelper;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class DistributionTopic
extends Topic {
    public static Logger logger = Debug.getLogger((String)DistributionTopic.class.getName());
    private static final long serialVersionUID = 1L;
    private transient DistributionModule distributionModule;
    private Properties properties;

    public void setProperties(Properties properties) throws RequestException {
        super.setProperties(properties);
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("DistributionTopic.<init> prop = " + properties));
        }
        this.properties = (Properties)properties.clone();
        try {
            String className = ConversionHelper.toString((Object)properties.get("distribution.className"));
            Class.forName(className).getConstructor(new Class[0]);
        }
        catch (Exception exc) {
            logger.log(BasicLevel.ERROR, (Object)"DistributionTopic: error with distribution class.", (Throwable)exc);
            throw new RequestException(exc.getMessage());
        }
    }

    public void initialize(boolean firstTime) {
        super.initialize(firstTime);
        if (this.distributionModule == null) {
            this.distributionModule = new DistributionModule(this, (Properties)this.properties.clone());
        }
    }

    public void agentFinalize(boolean lastTime) {
        super.agentFinalize(lastTime);
        this.close();
    }

    public ClientMessages preProcess(AgentId from, ClientMessages cm) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("DistributionTopic. preProcess(" + from + ", " + (Object)((Object)cm) + ')'));
        }
        return this.distributionModule.processMessages(cm);
    }

    public String toString() {
        return "DistributionTopic:" + this.getId().toString();
    }

    private void close() {
        if (this.distributionModule != null) {
            this.distributionModule.close();
        }
    }

    public void updateProperties(Properties prop) throws Exception {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("DistributionTopic.updateProperties(" + prop + ')'));
        }
        super.setProperties(prop);
        Enumeration<Object> e = prop.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            this.properties.put(key, prop.get(key));
        }
        this.distributionModule.updateProperties(this.properties);
    }
}

