/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http_osgi;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.cxf.transport.http_osgi.OsgiDestination;
import org.apache.cxf.transport.http_osgi.OsgiDestinationRegistryIntf;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OsgiDestinationRegistry
implements OsgiDestinationRegistryIntf {
    private ConcurrentMap<String, OsgiDestination> destinations = new ConcurrentHashMap<String, OsgiDestination>();

    @Override
    public void addDestination(String path, OsgiDestination destination) {
        String p = OsgiDestinationRegistry.getTrimmedPath(path);
        this.destinations.putIfAbsent(p, destination);
    }

    @Override
    public void removeDestination(String path) {
        this.destinations.remove(path);
    }

    @Override
    public OsgiDestination getDestinationForPath(String path) {
        return (OsgiDestination)this.destinations.get(OsgiDestinationRegistry.getTrimmedPath(path));
    }

    @Override
    public Collection<OsgiDestination> getDestinations() {
        return Collections.unmodifiableCollection(this.destinations.values());
    }

    @Override
    public Set<String> getDestinationsPaths() {
        return Collections.unmodifiableSet(this.destinations.keySet());
    }

    static String getTrimmedPath(String path) {
        if (path == null) {
            return "/";
        }
        String lh = "http://localhost/";
        String lhs = "https://localhost/";
        if (path.startsWith("http://localhost/")) {
            path = path.substring("http://localhost/".length());
        } else if (path.startsWith("https://localhost/")) {
            path = path.substring("https://localhost/".length());
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        return path;
    }
}

