/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.agent.conf;

import fr.dyade.aaa.agent.conf.A3CMLCluster;
import fr.dyade.aaa.agent.conf.A3CMLConfig;
import fr.dyade.aaa.agent.conf.A3CMLDomain;
import fr.dyade.aaa.agent.conf.A3CMLNat;
import fr.dyade.aaa.agent.conf.A3CMLNetwork;
import fr.dyade.aaa.agent.conf.A3CMLProperty;
import fr.dyade.aaa.agent.conf.A3CMLServer;
import fr.dyade.aaa.agent.conf.A3CMLService;
import fr.dyade.aaa.agent.conf.A3CMLWrapper;
import fr.dyade.aaa.agent.conf.Log;
import java.io.Reader;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.objectweb.util.monolog.api.BasicLevel;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class A3CMLSaxWrapper
extends DefaultHandler
implements A3CMLWrapper {
    protected A3CMLConfig a3cmlConfig = null;
    String configName = "default";
    String conf = null;
    A3CMLDomain domain = null;
    A3CMLServer server = null;
    A3CMLNetwork network = null;
    A3CMLService service = null;
    A3CMLProperty property = null;
    String jvmArgs = null;
    A3CMLNat nat = null;
    A3CMLCluster cluster = null;

    public A3CMLConfig parse(Reader cfgReader, String cfgName) throws Exception {
        this.configName = cfgName;
        this.a3cmlConfig = new A3CMLConfig();
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser parser = factory.newSAXParser();
        parser.parse(new InputSource(cfgReader), (DefaultHandler)this);
        return this.a3cmlConfig;
    }

    public void fatalError(SAXParseException e) throws SAXException {
        Log.logger.log(BasicLevel.ERROR, (Object)("fatal error parsing " + e.getPublicId() + " at " + e.getLineNumber() + "." + e.getColumnNumber()));
        throw e;
    }

    public void error(SAXParseException e) throws SAXException {
        Log.logger.log(BasicLevel.ERROR, (Object)("error parsing " + e.getPublicId() + " at " + e.getLineNumber() + "." + e.getColumnNumber()));
        throw e;
    }

    public void warning(SAXParseException e) throws SAXException {
        Log.logger.log(BasicLevel.ERROR, (Object)("warning parsing " + e.getPublicId() + " at " + e.getLineNumber() + "." + e.getColumnNumber()));
        throw e;
    }

    public void startDocument() throws SAXException {
        if (Log.logger.isLoggable(BasicLevel.DEBUG)) {
            Log.logger.log(BasicLevel.DEBUG, (Object)"startDocument");
        }
    }

    public void startElement(String uri, String localName, String rawName, Attributes atts) throws SAXException {
        String name = rawName;
        if (Log.logger.isLoggable(BasicLevel.DEBUG)) {
            Log.logger.log(BasicLevel.DEBUG, (Object)("startElement: " + name));
        }
        if (name.equals("config")) {
            this.conf = atts.getValue("name");
            if (this.conf == null) {
                this.conf = this.configName;
            }
        } else if (this.configName.equals(this.conf)) {
            if (name.equals("domain")) {
                try {
                    this.domain = new A3CMLDomain(atts.getValue("name"), atts.getValue("network"));
                }
                catch (Exception exc) {
                    throw new SAXException(exc.getMessage());
                }
            }
            if (name.equals("server")) {
                try {
                    short sid;
                    try {
                        sid = Short.parseShort(atts.getValue("id"));
                    }
                    catch (NumberFormatException exc) {
                        throw new Exception("bad value for server id: " + atts.getValue("id"));
                    }
                    this.server = new A3CMLServer(sid, atts.getValue("name"), atts.getValue("hostname"));
                }
                catch (Exception exc) {
                    throw new SAXException(exc.getMessage());
                }
            }
            if (name.equals("cluster")) {
                try {
                    short sid;
                    try {
                        sid = Short.parseShort(atts.getValue("id"));
                    }
                    catch (NumberFormatException exc) {
                        throw new Exception("bad value for cluster id: " + atts.getValue("id"));
                    }
                    this.cluster = new A3CMLCluster(sid, atts.getValue("name"));
                }
                catch (Exception exc) {
                    throw new SAXException(exc.getMessage());
                }
            }
            if (name.equals("network")) {
                try {
                    int port;
                    try {
                        port = Integer.parseInt(atts.getValue("port"));
                    }
                    catch (NumberFormatException exc) {
                        throw new Exception("bad value for network port: " + atts.getValue("port"));
                    }
                    this.network = new A3CMLNetwork(atts.getValue("domain"), port);
                }
                catch (Exception exc) {
                    throw new SAXException(exc.getMessage());
                }
            }
            if (name.equals("service")) {
                this.service = new A3CMLService(atts.getValue("class"), atts.getValue("args"));
            } else if (name.equals("property")) {
                this.property = new A3CMLProperty(atts.getValue("name"), atts.getValue("value"));
            } else if (name.equals("nat")) {
                this.nat = new A3CMLNat(Short.parseShort(atts.getValue("sid")), atts.getValue("hostname"), Integer.parseInt(atts.getValue("port")));
            } else if (name.equals("jvmArgs")) {
                this.jvmArgs = atts.getValue("value");
            } else {
                throw new SAXException("unknown element \"" + name + "\"");
            }
        }
    }

    public void endElement(String uri, String localName, String rawName) throws SAXException {
        block28: {
            String name = rawName;
            if (Log.logger.isLoggable(BasicLevel.DEBUG)) {
                Log.logger.log(BasicLevel.DEBUG, (Object)("endElement: " + name));
            }
            if (name.equals("config")) {
                this.conf = null;
            } else if (this.configName.equals(this.conf)) {
                try {
                    if (name.equals("domain")) {
                        this.a3cmlConfig.addDomain(this.domain);
                        this.domain = null;
                        break block28;
                    }
                    if (name.equals("server")) {
                        if (this.cluster == null) {
                            this.a3cmlConfig.addServer(this.server);
                        } else {
                            this.cluster.addServer(this.server);
                        }
                        this.server = null;
                        break block28;
                    }
                    if (name.equals("cluster")) {
                        this.a3cmlConfig.addCluster(this.cluster);
                        this.cluster = null;
                        break block28;
                    }
                    if (name.equals("network")) {
                        if (this.server != null) {
                            this.server.addNetwork(this.network);
                            this.a3cmlConfig.getDomain(this.network.domain).addServer(this.server);
                        }
                        this.network = null;
                        break block28;
                    }
                    if (name.equals("service")) {
                        if (this.server != null) {
                            this.server.addService(this.service);
                        }
                        this.service = null;
                        break block28;
                    }
                    if (name.equals("property")) {
                        if (this.server == null && this.cluster == null) {
                            this.a3cmlConfig.addProperty(this.property);
                        } else if (this.server != null) {
                            this.server.addProperty(this.property);
                        } else if (this.server == null && this.cluster != null) {
                            this.cluster.addProperty(this.property);
                        }
                        this.property = null;
                        break block28;
                    }
                    if (name.equals("nat")) {
                        if (this.server != null) {
                            this.server.addNat(this.nat);
                        }
                        this.nat = null;
                        break block28;
                    }
                    if (name.equals("jvmArgs")) {
                        if (this.server != null && this.jvmArgs != null) {
                            this.server.jvmArgs = this.jvmArgs;
                        } else if (this.server == null && this.cluster != null) {
                            this.cluster.jvmArgs = this.jvmArgs;
                        }
                        this.jvmArgs = null;
                        break block28;
                    }
                    throw new SAXException("unknown element \"" + name + "\"");
                }
                catch (SAXException exc) {
                    throw exc;
                }
                catch (Exception exc) {
                    throw new SAXException(exc.getMessage());
                }
            }
        }
    }

    public void endDocument() throws SAXException {
        if (Log.logger.isLoggable(BasicLevel.DEBUG)) {
            Log.logger.log(BasicLevel.DEBUG, (Object)"endDocument");
        }
    }
}

