/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.schemaframework;

import java.io.IOException;
import java.io.Writer;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.databaseaccess.FieldTypeDefinition;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.tools.schemaframework.DatabaseObjectDefinition;

public class NestedTableDefinition
extends DatabaseObjectDefinition {
    protected int typeSize;
    protected Class type;
    protected String typeName;

    public void appendTypeString(Writer writer, AbstractSession session) throws ValidationException {
        FieldTypeDefinition fieldType;
        if (this.getType() != null) {
            fieldType = session.getPlatform().getFieldTypeDefinition(this.getType());
            if (fieldType == null) {
                throw ValidationException.javaTypeIsNotAValidDatabaseType(this.getType());
            }
        } else {
            fieldType = new FieldTypeDefinition(this.getTypeName());
        }
        try {
            writer.write(fieldType.getName());
            if (fieldType.isSizeAllowed() && (this.getTypeSize() != 0 || fieldType.isSizeRequired())) {
                writer.write("(");
                if (this.getTypeSize() == 0) {
                    writer.write(Integer.valueOf(fieldType.getDefaultSize()).toString());
                } else {
                    writer.write(Integer.valueOf(this.getTypeSize()).toString());
                }
                writer.write(")");
            }
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
    }

    public Writer buildCreationWriter(AbstractSession session, Writer writer) throws ValidationException {
        try {
            writer.write("CREATE TYPE ");
            writer.write(this.getFullName());
            writer.write(" AS TABLE OF ");
            this.appendTypeString(writer, session);
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
        return writer;
    }

    public Writer buildDeletionWriter(AbstractSession session, Writer writer) throws ValidationException {
        try {
            writer.write("DROP TYPE " + this.getFullName());
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
        return writer;
    }

    public Class getType() {
        return this.type;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public int getTypeSize() {
        return this.typeSize;
    }

    public void setType(Class type) {
        this.type = type;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public void setTypeSize(int typeSize) {
        this.typeSize = typeSize;
    }
}

