/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.bridge.builtin;

import org.apache.lucene.document.DateTools;
import org.hibernate.AssertionFailure;
import org.hibernate.search.annotations.Resolution;

public class DateResolutionUtil {
    private DateResolutionUtil() {
    }

    public static DateTools.Resolution getLuceneResolution(Resolution hibResolution) {
        DateTools.Resolution resolution = null;
        switch (hibResolution) {
            case YEAR: {
                resolution = DateTools.Resolution.YEAR;
                break;
            }
            case MONTH: {
                resolution = DateTools.Resolution.MONTH;
                break;
            }
            case DAY: {
                resolution = DateTools.Resolution.DAY;
                break;
            }
            case HOUR: {
                resolution = DateTools.Resolution.HOUR;
                break;
            }
            case MINUTE: {
                resolution = DateTools.Resolution.MINUTE;
                break;
            }
            case SECOND: {
                resolution = DateTools.Resolution.SECOND;
                break;
            }
            case MILLISECOND: {
                resolution = DateTools.Resolution.MILLISECOND;
                break;
            }
            default: {
                throw new AssertionFailure("Unknown Resolution: " + (Object)((Object)hibResolution));
            }
        }
        return resolution;
    }
}

