/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.locking;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.annotations.OptimisticLockingType;
import org.eclipse.persistence.descriptors.AllFieldsLockingPolicy;
import org.eclipse.persistence.descriptors.ChangedFieldsLockingPolicy;
import org.eclipse.persistence.descriptors.SelectedFieldsLockingPolicy;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.columns.ColumnMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptimisticLockingMetadata
extends ORMetadata {
    private Boolean m_cascade;
    private List<ColumnMetadata> m_selectedColumns = new ArrayList<ColumnMetadata>();
    private String m_type;

    public OptimisticLockingMetadata() {
        super("<optimistic-locking>");
    }

    public OptimisticLockingMetadata(MetadataAnnotation optimisticLocking, MetadataAccessibleObject accessibleObject) {
        super(optimisticLocking, accessibleObject);
        this.m_type = (String)optimisticLocking.getAttribute("type");
        this.m_cascade = (Boolean)optimisticLocking.getAttribute("cascade");
        for (Object selectedColumn : (Object[])optimisticLocking.getAttributeArray("selectedColumns")) {
            this.m_selectedColumns.add(new ColumnMetadata((MetadataAnnotation)selectedColumn, accessibleObject));
        }
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof OptimisticLockingMetadata) {
            OptimisticLockingMetadata optimisticLocking = (OptimisticLockingMetadata)objectToCompare;
            if (!this.valuesMatch(this.m_cascade, optimisticLocking.getCascade())) {
                return false;
            }
            if (!this.valuesMatch(this.m_selectedColumns, optimisticLocking.getSelectedColumns())) {
                return false;
            }
            return this.valuesMatch(this.m_type, optimisticLocking.getType());
        }
        return false;
    }

    public Boolean getCascade() {
        return this.m_cascade;
    }

    public List<ColumnMetadata> getSelectedColumns() {
        return this.m_selectedColumns;
    }

    public String getType() {
        return this.m_type;
    }

    public boolean hasSelectedColumns() {
        return !this.m_selectedColumns.isEmpty();
    }

    public void process(MetadataDescriptor descriptor) {
        if (this.m_type == null || this.m_type.equals(OptimisticLockingType.VERSION_COLUMN.name())) {
            descriptor.setUsesCascadedOptimisticLocking(this.m_cascade != null && this.m_cascade != false);
        } else if (this.m_type.equals(OptimisticLockingType.ALL_COLUMNS.name())) {
            descriptor.setOptimisticLockingPolicy(new AllFieldsLockingPolicy());
        } else if (this.m_type.equals(OptimisticLockingType.CHANGED_COLUMNS.name())) {
            descriptor.setOptimisticLockingPolicy(new ChangedFieldsLockingPolicy());
        } else if (this.m_type.equals(OptimisticLockingType.SELECTED_COLUMNS.name())) {
            if (this.m_selectedColumns.isEmpty()) {
                throw ValidationException.optimisticLockingSelectedColumnNamesNotSpecified(descriptor.getJavaClass());
            }
            SelectedFieldsLockingPolicy policy = new SelectedFieldsLockingPolicy();
            for (ColumnMetadata selectedColumn : this.m_selectedColumns) {
                if (selectedColumn.getName().equals("")) {
                    throw ValidationException.optimisticLockingSelectedColumnNamesNotSpecified(descriptor.getJavaClass());
                }
                policy.addLockFieldName(selectedColumn.getName());
            }
            descriptor.setOptimisticLockingPolicy(policy);
        }
    }

    public void setCascade(Boolean cascade) {
        this.m_cascade = cascade;
    }

    public void setSelectedColumns(List<ColumnMetadata> selectedColumns) {
        this.m_selectedColumns = selectedColumns;
    }

    public void setType(String type) {
        this.m_type = type;
    }
}

