/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.pool.impl.enhanced.impl.listener.resizer;

import org.ow2.util.pool.impl.enhanced.api.IWaitControl;
import org.ow2.util.pool.impl.enhanced.api.listener.IPoolListener;
import org.ow2.util.pool.impl.enhanced.api.listener.statistics.IPoolStatsListener;
import org.ow2.util.pool.impl.enhanced.impl.listener.resizer.UpdateMethod;
import org.ow2.util.pool.impl.enhanced.internal.resizer.api.IResizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResizerUpdatePoolListener<E, S>
implements IPoolListener<E> {
    private UpdateMethod getUpdateMethod;
    private UpdateMethod putUpdateMethod;
    private UpdateMethod removeUpdateMethod;
    private UpdateMethod interruptAllWaitersUpdateMethod;
    private IPoolStatsListener<E, S> poolStatsAccessor;
    private IResizer<S> poolResizer;
    private Object mutex;
    private S currentStats;

    public ResizerUpdatePoolListener(S stats, IResizer<S> poolResizer, IPoolStatsListener<E, S> poolStatsAccessor) {
        this(stats, poolResizer, poolStatsAccessor, UpdateMethod.BEFORE, UpdateMethod.AFTER, UpdateMethod.AFTER, UpdateMethod.AFTER);
    }

    public ResizerUpdatePoolListener(S stats, IResizer<S> poolResizer, IPoolStatsListener<E, S> poolStatsAccessor, UpdateMethod getUpdateMethod, UpdateMethod putUpdateMethod, UpdateMethod removeUpdateMethod, UpdateMethod interruptAllWaitersUpdateMethod) {
        if (stats == null) {
            throw new IllegalArgumentException();
        }
        this.poolStatsAccessor = poolStatsAccessor;
        this.poolResizer = poolResizer;
        this.currentStats = stats;
        this.getUpdateMethod = getUpdateMethod;
        this.putUpdateMethod = putUpdateMethod;
        this.removeUpdateMethod = removeUpdateMethod;
        this.interruptAllWaitersUpdateMethod = interruptAllWaitersUpdateMethod;
        this.mutex = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareUpdate() {
        Object object = this.mutex;
        synchronized (object) {
            this.poolStatsAccessor.copyStats(this.currentStats);
            this.poolResizer.prepareUpdate(this.currentStats);
        }
    }

    public void update() {
        this.poolResizer.update();
    }

    @Override
    public void getMethodCalled(IWaitControl timeout) {
        this.prepareUpdate();
        if (this.getUpdateMethod.isBefore()) {
            this.update();
        }
    }

    @Override
    public void getMethodFailed(Exception poolException, IWaitControl timeout) {
        this.prepareUpdate();
        if (this.getUpdateMethod.isAfterFailed()) {
            this.update();
        }
    }

    @Override
    public void getMethodReturned(E result, IWaitControl timeout) {
        this.prepareUpdate();
        if (this.getUpdateMethod.isAfterSuccessful()) {
            this.update();
        }
    }

    @Override
    public void signalAllWaitersMethodCalled() {
        this.prepareUpdate();
        if (this.interruptAllWaitersUpdateMethod.isBefore()) {
            this.update();
        }
    }

    @Override
    public void putMethodCalled(E poolItem) {
        this.prepareUpdate();
        if (this.putUpdateMethod.isBefore()) {
            this.update();
        }
    }

    @Override
    public void putMethodFailed(Exception poolException, E poolItem) {
        this.prepareUpdate();
        if (this.putUpdateMethod.isAfterFailed()) {
            this.update();
        }
    }

    @Override
    public void putMethodReturned(E poolItem) {
        this.prepareUpdate();
        if (this.putUpdateMethod.isAfterSuccessful()) {
            this.update();
        }
    }

    @Override
    public void removeMethodCalled(E poolItem) {
        this.prepareUpdate();
        if (this.removeUpdateMethod.isBefore()) {
            this.update();
        }
    }

    @Override
    public void removeMethodFailed(Exception poolException, E poolItem) {
        this.prepareUpdate();
        if (this.removeUpdateMethod.isAfterFailed()) {
            this.update();
        }
    }

    @Override
    public void removeMethodReturned(E poolItem) {
        this.prepareUpdate();
        if (this.removeUpdateMethod.isAfterSuccessful()) {
            this.update();
        }
    }

    @Override
    public void signalAllWaitersMethodFailed(Exception e) {
        this.prepareUpdate();
        if (this.interruptAllWaitersUpdateMethod.isAfterFailed()) {
            this.update();
        }
    }

    @Override
    public void signalAllWaitersMethodReturned() {
        this.prepareUpdate();
        if (this.interruptAllWaitersUpdateMethod.isAfterSuccessful()) {
            this.update();
        }
    }
}

