/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence;

import java.util.Arrays;
import org.apache.openjpa.persistence.OpenJPAEnum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface HintValueConverter {
    public Object convert(Object var1);

    public boolean canConvert(Class<?> var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StringToBoolean
    implements HintValueConverter {
        @Override
        public Object convert(Object v) {
            if (v instanceof String) {
                return Boolean.valueOf(v.toString());
            }
            if (v instanceof Boolean) {
                return v;
            }
            return v;
        }

        @Override
        public boolean canConvert(Class<?> cls) {
            return String.class == cls || Boolean.class == cls || Boolean.TYPE == cls;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StringToInteger
    implements HintValueConverter {
        private String[] strings;
        private Integer[] numbers;

        public StringToInteger() {
        }

        public StringToInteger(String[] strings, int[] numbers) {
            if (strings == null || numbers == null || strings.length != numbers.length) {
                throw new IllegalArgumentException();
            }
            this.strings = new String[strings.length];
            this.numbers = new Integer[numbers.length];
            for (int i = 0; i < strings.length; ++i) {
                this.strings[i] = strings[i];
                this.numbers[i] = numbers[i];
            }
        }

        @Override
        public Object convert(Object s) {
            if (!(s instanceof String)) {
                return s;
            }
            String str = s.toString();
            if (this.strings == null) {
                try {
                    return Integer.parseInt(str);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Can not convert " + str + " . Expected a numeric string");
                }
            }
            for (int i = 0; i < this.strings.length; ++i) {
                if (!this.strings[i].equalsIgnoreCase(str)) continue;
                return this.numbers[i];
            }
            throw new IllegalArgumentException("Can not convert " + str + " . Valid input is " + Arrays.toString(this.strings));
        }

        @Override
        public boolean canConvert(Class<?> cls) {
            return String.class == cls;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class OpenJPAEnumToInteger
    implements HintValueConverter {
        private OpenJPAEnum<?> _prototype;

        public OpenJPAEnumToInteger(OpenJPAEnum<?> prototype) {
            this._prototype = prototype;
        }

        @Override
        public Object convert(Object e) {
            if (e.getClass() == this._prototype.getClass()) {
                return ((OpenJPAEnum)e).toKernelConstant();
            }
            if (e instanceof String) {
                return this._prototype.convertToKernelConstant(e.toString());
            }
            if (e instanceof Integer) {
                return this._prototype.convertToKernelConstant((Integer)e);
            }
            return e;
        }

        @Override
        public boolean canConvert(Class<?> type) {
            return OpenJPAEnum.class.isAssignableFrom(type) || type == String.class || type == Integer.class || type == Integer.TYPE;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EnumToInteger
    implements HintValueConverter {
        private Class<? extends Enum<?>> _type;
        private Integer[] map;

        public EnumToInteger(Class<? extends Enum<?>> enumType, int[] numbers) {
            try {
                this._type = enumType;
                Enum[] values = (Enum[])enumType.getMethod("values", null).invoke(null, (Object[])null);
                this.map = new Integer[values.length];
                int i = 0;
                for (Enum v : values) {
                    this.map[v.ordinal()] = numbers[i++];
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public Object convert(Object e) {
            if (e.getClass() == this._type) {
                return this.map[((Enum)e).ordinal()];
            }
            return e;
        }

        @Override
        public boolean canConvert(Class<?> type) {
            return Enum.class.isAssignableFrom(type);
        }
    }
}

