/*
 * Decompiled with CFR 0.152.
 */
package javax.persistence.spi;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.WeakHashMap;
import javax.persistence.PersistenceException;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceProviderResolver;

public class PersistenceProviderResolverHolder {
    private static PersistenceProviderResolver persistenceProviderResolver = new DefaultPersistenceProviderResolver();

    public static PersistenceProviderResolver getPersistenceProviderResolver() {
        return persistenceProviderResolver;
    }

    public static void setPersistenceProviderResolver(PersistenceProviderResolver resolver) {
        persistenceProviderResolver.clearCachedProviders();
        persistenceProviderResolver = resolver == null ? new DefaultPersistenceProviderResolver() : resolver;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultPersistenceProviderResolver
    implements PersistenceProviderResolver {
        private static final String PERSISTENCE_PROVIDER = PersistenceProvider.class.getName();
        private static final String PERSISTENCE_PROVIDER_JAR_PROPERTY = "META-INF/services/" + PERSISTENCE_PROVIDER;
        private static final long serialVersionUID = 5768927739496807544L;
        private WeakHashMap<ClassLoader, List<PersistenceProvider>> persistenceProviders = new WeakHashMap();

        private DefaultPersistenceProviderResolver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void findPersistenceProviders(ClassLoader classLoader) {
            Enumeration<URL> urls = null;
            try {
                urls = classLoader.getResources(PERSISTENCE_PROVIDER_JAR_PROPERTY);
            }
            catch (IOException e) {
                throw new PersistenceException("Cannot get resources named '" + PERSISTENCE_PROVIDER_JAR_PROPERTY + "' on the current classloader '" + classLoader + "'.", e);
            }
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                URLConnection urlConnection = null;
                try {
                    urlConnection = url.openConnection();
                }
                catch (IOException e) {
                    throw new PersistenceException("Cannot open connection on URL '" + url + "'.", e);
                }
                urlConnection.setDefaultUseCaches(false);
                InputStream is = null;
                try {
                    is = urlConnection.getInputStream();
                    Reader reader = null;
                    BufferedReader bufferedReader = null;
                    try {
                        reader = new InputStreamReader(is);
                        bufferedReader = new BufferedReader(reader);
                        String line = bufferedReader.readLine();
                        if (line == null) {
                            throw new PersistenceException("No lines found in the file available at the URL '" + url + "'.");
                        }
                        this.addPersistenceProvider(classLoader, line.trim());
                    }
                    finally {
                        reader.close();
                        bufferedReader.close();
                    }
                }
                catch (IOException e) {
                    throw new PersistenceException("Cannot get InputStream on URL '" + url + "'.", e);
                }
                finally {
                    if (is == null) continue;
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        throw new PersistenceException("Cannot close InputStream on URL '" + url + "'.", e);
                    }
                }
            }
        }

        private void addPersistenceProvider(ClassLoader classLoader, String persistenceProviderName) {
            Class<?> persistenceProviderClass = null;
            try {
                persistenceProviderClass = classLoader.loadClass(persistenceProviderName);
            }
            catch (ClassNotFoundException e) {
                throw new PersistenceException("Cannot load the persistence provider class with the name '" + persistenceProviderName + "' in the ClassLoader '" + classLoader + "'.", e);
            }
            Object object = null;
            try {
                object = persistenceProviderClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new PersistenceException("Cannot build an instance of the persistence provider class with the name '" + persistenceProviderName + "' in the ClassLoader '" + classLoader + "'.", e);
            }
            catch (IllegalAccessException e) {
                throw new PersistenceException("Cannot build an instance of the persistence provider class with the name '" + persistenceProviderName + "' in the ClassLoader '" + classLoader + "'.", e);
            }
            if (!(object instanceof PersistenceProvider)) {
                throw new PersistenceException("The instance of the object with the class name '" + persistenceProviderName + "' in the ClassLoader '" + classLoader + "' is not an instance of PersistenceProvider interface.");
            }
            List<PersistenceProvider> existingPersistenceProviders = this.persistenceProviders.get(classLoader);
            if (existingPersistenceProviders == null) {
                existingPersistenceProviders = new ArrayList<PersistenceProvider>();
                this.persistenceProviders.put(classLoader, existingPersistenceProviders);
            }
            existingPersistenceProviders.add(object);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<PersistenceProvider> getPersistenceProviders() {
            ClassLoader currentCL = Thread.currentThread().getContextClassLoader();
            List<PersistenceProvider> availablePersistenceProviders = null;
            WeakHashMap<ClassLoader, List<PersistenceProvider>> weakHashMap = this.persistenceProviders;
            synchronized (weakHashMap) {
                availablePersistenceProviders = this.persistenceProviders.get(currentCL);
                if (availablePersistenceProviders == null) {
                    this.findPersistenceProviders(currentCL);
                }
            }
            return availablePersistenceProviders;
        }

        @Override
        public void clearCachedProviders() {
            this.persistenceProviders.clear();
        }

        private class ProviderName {
            public ProviderName(String name, URL source) {
            }

            public String getName() {
                return null;
            }

            public URL getSource() {
                return null;
            }

            public String toString() {
                return super.toString();
            }
        }
    }
}

