/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast;

import antlr.ASTFactory;
import antlr.Token;
import antlr.collections.AST;
import java.lang.reflect.Constructor;
import org.hibernate.hql.antlr.HqlSqlTokenTypes;
import org.hibernate.hql.ast.HqlSqlWalker;
import org.hibernate.hql.ast.tree.AggregateNode;
import org.hibernate.hql.ast.tree.BetweenOperatorNode;
import org.hibernate.hql.ast.tree.BinaryArithmeticOperatorNode;
import org.hibernate.hql.ast.tree.BinaryLogicOperatorNode;
import org.hibernate.hql.ast.tree.BooleanLiteralNode;
import org.hibernate.hql.ast.tree.Case2Node;
import org.hibernate.hql.ast.tree.CaseNode;
import org.hibernate.hql.ast.tree.CollectionFunction;
import org.hibernate.hql.ast.tree.ConstructorNode;
import org.hibernate.hql.ast.tree.CountNode;
import org.hibernate.hql.ast.tree.DeleteStatement;
import org.hibernate.hql.ast.tree.DotNode;
import org.hibernate.hql.ast.tree.FromClause;
import org.hibernate.hql.ast.tree.FromElement;
import org.hibernate.hql.ast.tree.IdentNode;
import org.hibernate.hql.ast.tree.ImpliedFromElement;
import org.hibernate.hql.ast.tree.InLogicOperatorNode;
import org.hibernate.hql.ast.tree.IndexNode;
import org.hibernate.hql.ast.tree.InitializeableNode;
import org.hibernate.hql.ast.tree.InsertStatement;
import org.hibernate.hql.ast.tree.IntoClause;
import org.hibernate.hql.ast.tree.IsNotNullLogicOperatorNode;
import org.hibernate.hql.ast.tree.IsNullLogicOperatorNode;
import org.hibernate.hql.ast.tree.JavaConstantNode;
import org.hibernate.hql.ast.tree.LiteralNode;
import org.hibernate.hql.ast.tree.MapEntryNode;
import org.hibernate.hql.ast.tree.MapKeyNode;
import org.hibernate.hql.ast.tree.MapValueNode;
import org.hibernate.hql.ast.tree.MethodNode;
import org.hibernate.hql.ast.tree.OrderByClause;
import org.hibernate.hql.ast.tree.ParameterNode;
import org.hibernate.hql.ast.tree.QueryNode;
import org.hibernate.hql.ast.tree.SelectClause;
import org.hibernate.hql.ast.tree.SelectExpressionImpl;
import org.hibernate.hql.ast.tree.SessionFactoryAwareNode;
import org.hibernate.hql.ast.tree.SqlFragment;
import org.hibernate.hql.ast.tree.SqlNode;
import org.hibernate.hql.ast.tree.UnaryArithmeticNode;
import org.hibernate.hql.ast.tree.UnaryLogicOperatorNode;
import org.hibernate.hql.ast.tree.UpdateStatement;

public class SqlASTFactory
extends ASTFactory
implements HqlSqlTokenTypes {
    private HqlSqlWalker walker;

    public SqlASTFactory(HqlSqlWalker walker) {
        this.walker = walker;
    }

    public Class getASTNodeType(int tokenType) {
        switch (tokenType) {
            case 45: 
            case 86: {
                return QueryNode.class;
            }
            case 51: {
                return UpdateStatement.class;
            }
            case 13: {
                return DeleteStatement.class;
            }
            case 29: {
                return InsertStatement.class;
            }
            case 30: {
                return IntoClause.class;
            }
            case 22: {
                return FromClause.class;
            }
            case 134: {
                return FromElement.class;
            }
            case 135: {
                return ImpliedFromElement.class;
            }
            case 15: {
                return DotNode.class;
            }
            case 78: {
                return IndexNode.class;
            }
            case 126: 
            case 140: {
                return IdentNode.class;
            }
            case 142: {
                return SqlFragment.class;
            }
            case 81: {
                return MethodNode.class;
            }
            case 17: 
            case 27: {
                return CollectionFunction.class;
            }
            case 137: {
                return SelectClause.class;
            }
            case 144: {
                return SelectExpressionImpl.class;
            }
            case 71: {
                return AggregateNode.class;
            }
            case 12: {
                return CountNode.class;
            }
            case 73: {
                return ConstructorNode.class;
            }
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 124: 
            case 125: {
                return LiteralNode.class;
            }
            case 20: 
            case 49: {
                return BooleanLiteralNode.class;
            }
            case 100: {
                return JavaConstantNode.class;
            }
            case 41: {
                return OrderByClause.class;
            }
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: {
                return BinaryArithmeticOperatorNode.class;
            }
            case 90: 
            case 91: {
                return UnaryArithmeticNode.class;
            }
            case 74: {
                return Case2Node.class;
            }
            case 54: {
                return CaseNode.class;
            }
            case 123: 
            case 148: {
                return ParameterNode.class;
            }
            case 34: 
            case 84: 
            case 102: 
            case 108: 
            case 110: 
            case 111: 
            case 112: 
            case 113: {
                return BinaryLogicOperatorNode.class;
            }
            case 26: 
            case 83: {
                return InLogicOperatorNode.class;
            }
            case 10: 
            case 82: {
                return BetweenOperatorNode.class;
            }
            case 80: {
                return IsNullLogicOperatorNode.class;
            }
            case 79: {
                return IsNotNullLogicOperatorNode.class;
            }
            case 19: {
                return UnaryLogicOperatorNode.class;
            }
            case 68: {
                return MapKeyNode.class;
            }
            case 69: {
                return MapValueNode.class;
            }
            case 70: {
                return MapEntryNode.class;
            }
        }
        return SqlNode.class;
    }

    protected AST createUsingCtor(Token token, String className) {
        AST t;
        try {
            Class<?> c = Class.forName(className);
            Class[] tokenArgType = new Class[]{Token.class};
            Constructor<?> ctor = c.getConstructor(tokenArgType);
            if (ctor != null) {
                t = (AST)ctor.newInstance(token);
                this.initializeSqlNode(t);
            } else {
                t = this.create(c);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid class or can't make instance, " + className);
        }
        return t;
    }

    private void initializeSqlNode(AST t) {
        if (t instanceof InitializeableNode) {
            InitializeableNode initializeableNode = (InitializeableNode)((Object)t);
            initializeableNode.initialize(this.walker);
        }
        if (t instanceof SessionFactoryAwareNode) {
            ((SessionFactoryAwareNode)((Object)t)).setSessionFactory(this.walker.getSessionFactoryHelper().getFactory());
        }
    }

    protected AST create(Class c) {
        AST t;
        try {
            t = (AST)c.newInstance();
            this.initializeSqlNode(t);
        }
        catch (Exception e) {
            this.error("Can't create AST Node " + c.getName());
            return null;
        }
        return t;
    }
}

