/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.util.StringManager;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.jni.Library;

public class AprLifecycleListener
implements LifecycleListener {
    private static Log log = LogFactory.getLog(AprLifecycleListener.class);
    private static boolean instanceCreated = false;
    protected static StringManager sm = StringManager.getManager("org.apache.catalina.core");
    protected static final int TCN_REQUIRED_MAJOR = 1;
    protected static final int TCN_REQUIRED_MINOR = 1;
    protected static final int TCN_REQUIRED_PATCH = 17;
    protected static final int TCN_RECOMMENDED_PV = 19;
    protected static String SSLEngine = "on";
    protected static String SSLRandomSeed = "builtin";
    protected static boolean sslInitialized = false;
    protected static boolean aprInitialized = false;
    protected static boolean sslAvailable = false;
    protected static boolean aprAvailable = false;

    public static boolean isAprAvailable() {
        if (instanceCreated) {
            AprLifecycleListener.init();
        }
        return aprAvailable;
    }

    public AprLifecycleListener() {
        instanceCreated = true;
    }

    public void lifecycleEvent(LifecycleEvent event) {
        block11: {
            if ("init".equals(event.getType())) {
                AprLifecycleListener.init();
                if (aprAvailable) {
                    try {
                        AprLifecycleListener.initializeSSL();
                    }
                    catch (Throwable t) {
                        if (!log.isDebugEnabled()) {
                            log.info(sm.getString("aprListener.sslInit"));
                            break block11;
                        }
                        log.debug(sm.getString("aprListener.sslInit"), t);
                    }
                }
            } else if ("after_stop".equals(event.getType())) {
                if (!aprAvailable) {
                    return;
                }
                try {
                    AprLifecycleListener.terminateAPR();
                }
                catch (Throwable t) {
                    if (!log.isDebugEnabled()) {
                        log.info(sm.getString("aprListener.aprDestroy"));
                    }
                    log.debug(sm.getString("aprListener.aprDestroy"), t);
                }
            }
        }
    }

    private static synchronized void terminateAPR() throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        String methodName = "terminate";
        Method method = Class.forName("org.apache.tomcat.jni.Library").getMethod(methodName, null);
        method.invoke(null, (Object[])null);
    }

    private static void init() {
        int major = 0;
        int minor = 0;
        int patch = 0;
        int apver = 0;
        int rqver = 1117;
        int rcver = 1119;
        if (aprInitialized) {
            return;
        }
        aprInitialized = true;
        try {
            String methodName = "initialize";
            Class[] paramTypes = new Class[]{String.class};
            Object[] paramValues = new Object[]{null};
            Class<?> clazz = Class.forName("org.apache.tomcat.jni.Library");
            Method method = clazz.getMethod(methodName, paramTypes);
            method.invoke(null, paramValues);
            major = clazz.getField("TCN_MAJOR_VERSION").getInt(null);
            minor = clazz.getField("TCN_MINOR_VERSION").getInt(null);
            patch = clazz.getField("TCN_PATCH_VERSION").getInt(null);
            apver = major * 1000 + minor * 100 + patch;
        }
        catch (Throwable t) {
            if (!log.isDebugEnabled()) {
                log.info(sm.getString("aprListener.aprInit", System.getProperty("java.library.path")));
            } else {
                log.debug(sm.getString("aprListener.aprInit", System.getProperty("java.library.path")), t);
            }
            return;
        }
        if (apver < rqver) {
            log.error(sm.getString("aprListener.tcnInvalid", major + "." + minor + "." + patch, "1.1.17"));
            try {
                AprLifecycleListener.terminateAPR();
            }
            catch (Throwable t) {
                // empty catch block
            }
            return;
        }
        if (apver < rcver) {
            if (!log.isDebugEnabled()) {
                log.info(sm.getString("aprListener.tcnVersion", major + "." + minor + "." + patch, "1.1.19"));
            } else {
                log.debug(sm.getString("aprListener.tcnVersion", major + "." + minor + "." + patch, "1.1.19"));
            }
        }
        if (!log.isDebugEnabled()) {
            log.info(sm.getString("aprListener.tcnValid", major + "." + minor + "." + patch));
        } else {
            log.debug(sm.getString("aprListener.tcnValid", major + "." + minor + "." + patch));
        }
        log.info(sm.getString("aprListener.flags", Library.APR_HAVE_IPV6, Library.APR_HAS_SENDFILE, Library.APR_HAS_SO_ACCEPTFILTER, Library.APR_HAS_RANDOM));
        aprAvailable = true;
    }

    private static synchronized void initializeSSL() throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if ("off".equalsIgnoreCase(SSLEngine)) {
            return;
        }
        if (sslInitialized) {
            return;
        }
        sslInitialized = true;
        String methodName = "randSet";
        Class[] paramTypes = new Class[]{String.class};
        Object[] paramValues = new Object[]{SSLRandomSeed};
        Class<?> clazz = Class.forName("org.apache.tomcat.jni.SSL");
        Method method = clazz.getMethod(methodName, paramTypes);
        method.invoke(null, paramValues);
        methodName = "initialize";
        paramValues[0] = "on".equalsIgnoreCase(SSLEngine) ? null : SSLEngine;
        method = clazz.getMethod(methodName, paramTypes);
        method.invoke(null, paramValues);
        sslAvailable = true;
    }

    public String getSSLEngine() {
        return SSLEngine;
    }

    public void setSSLEngine(String SSLEngine) {
        AprLifecycleListener.SSLEngine = SSLEngine;
    }

    public String getSSLRandomSeed() {
        return SSLRandomSeed;
    }

    public void setSSLRandomSeed(String SSLRandomSeed) {
        AprLifecycleListener.SSLRandomSeed = SSLRandomSeed;
    }
}

