/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.classes;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.AssociationOverride;
import javax.persistence.AssociationOverrides;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.EntityListeners;
import javax.persistence.ExcludeDefaultListeners;
import javax.persistence.ExcludeSuperclassListeners;
import javax.persistence.IdClass;
import javax.persistence.NamedNativeQueries;
import javax.persistence.NamedNativeQuery;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.SequenceGenerator;
import javax.persistence.SqlResultSetMapping;
import javax.persistence.SqlResultSetMappings;
import javax.persistence.TableGenerator;
import org.eclipse.persistence.annotations.Cache;
import org.eclipse.persistence.annotations.CacheInterceptor;
import org.eclipse.persistence.annotations.ExistenceChecking;
import org.eclipse.persistence.annotations.ExistenceType;
import org.eclipse.persistence.annotations.NamedStoredProcedureQueries;
import org.eclipse.persistence.annotations.NamedStoredProcedureQuery;
import org.eclipse.persistence.annotations.OptimisticLocking;
import org.eclipse.persistence.annotations.PrimaryKey;
import org.eclipse.persistence.annotations.QueryRedirectors;
import org.eclipse.persistence.annotations.ReadOnly;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.MetadataProject;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.PrimaryKeyMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataField;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataMethod;
import org.eclipse.persistence.internal.jpa.metadata.cache.CacheInterceptorMetadata;
import org.eclipse.persistence.internal.jpa.metadata.cache.CacheMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.AssociationOverrideMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.AttributeOverrideMetadata;
import org.eclipse.persistence.internal.jpa.metadata.listeners.EntityListenerMetadata;
import org.eclipse.persistence.internal.jpa.metadata.locking.OptimisticLockingMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.DefaultRedirectorsMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.NamedNativeQueryMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.NamedQueryMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.NamedStoredProcedureQueryMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.SQLResultSetMappingMetadata;
import org.eclipse.persistence.internal.jpa.metadata.sequencing.SequenceGeneratorMetadata;
import org.eclipse.persistence.internal.jpa.metadata.sequencing.TableGeneratorMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappedSuperclassAccessor
extends ClassAccessor {
    private boolean m_excludeDefaultListeners;
    private boolean m_excludeSuperclassListeners;
    private Boolean m_readOnly;
    private Class m_idClass;
    private PrimaryKeyMetadata m_primaryKey;
    private CacheMetadata m_cache;
    private CacheInterceptorMetadata m_cacheInterceptor;
    private DefaultRedirectorsMetadata m_defaultRedirectors;
    private ExistenceType m_existenceChecking;
    private List<EntityListenerMetadata> m_entityListeners = new ArrayList<EntityListenerMetadata>();
    private OptimisticLockingMetadata m_optimisticLocking;
    private String m_idClassName;
    private String m_prePersist;
    private String m_postPersist;
    private String m_preRemove;
    private String m_postRemove;
    private String m_preUpdate;
    private String m_postUpdate;
    private String m_postLoad;

    public MappedSuperclassAccessor() {
        super("<mapped-superclass>");
    }

    public MappedSuperclassAccessor(String xmlElement) {
        super(xmlElement);
    }

    protected MappedSuperclassAccessor(Annotation annotation, Class cls, MetadataProject project) {
        super(annotation, cls, project);
    }

    public MappedSuperclassAccessor(Annotation annotation, Class cls, MetadataDescriptor descriptor) {
        super(annotation, cls, descriptor);
    }

    public boolean excludeDefaultListeners() {
        return this.m_excludeDefaultListeners;
    }

    public boolean excludeSuperclassListeners() {
        return this.m_excludeSuperclassListeners;
    }

    public CacheMetadata getCache() {
        return this.m_cache;
    }

    public CacheInterceptorMetadata getCacheInterceptor() {
        return this.m_cacheInterceptor;
    }

    public List<EntityListenerMetadata> getEntityListeners() {
        return this.m_entityListeners;
    }

    public String getExcludeDefaultListeners() {
        return null;
    }

    public String getExcludeSuperclassListeners() {
        return null;
    }

    public ExistenceType getExistenceChecking() {
        return this.m_existenceChecking;
    }

    public String getIdClassName() {
        return this.m_idClassName;
    }

    public OptimisticLockingMetadata getOptimisticLocking() {
        return this.m_optimisticLocking;
    }

    public PrimaryKeyMetadata getPrimaryKey() {
        return this.m_primaryKey;
    }

    public String getPostLoad() {
        return this.m_postLoad;
    }

    public String getPostPersist() {
        return this.m_postPersist;
    }

    public String getPostRemove() {
        return this.m_postRemove;
    }

    public String getPostUpdate() {
        return this.m_postUpdate;
    }

    public String getPrePersist() {
        return this.m_prePersist;
    }

    public String getPreRemove() {
        return this.m_preRemove;
    }

    public String getPreUpdate() {
        return this.m_preUpdate;
    }

    public Boolean getReadOnly() {
        return this.m_readOnly;
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject accessibleObject) {
        super.initXMLObject(accessibleObject);
        this.initXMLObject(this.m_cache, accessibleObject);
        this.initXMLObject(this.m_optimisticLocking, accessibleObject);
        this.initXMLObjects(this.m_entityListeners, accessibleObject);
        this.m_idClass = this.initXMLClassName(this.m_idClassName);
    }

    @Override
    public void merge(ORMetadata metadata) {
        super.merge(metadata);
        MappedSuperclassAccessor accessor = (MappedSuperclassAccessor)metadata;
        this.m_excludeDefaultListeners = this.mergePrimitiveBoolean(this.m_excludeDefaultListeners, accessor.excludeDefaultListeners(), accessor.getAccessibleObject(), "<exclude-default-listeners>");
        this.m_excludeSuperclassListeners = this.mergePrimitiveBoolean(this.m_excludeSuperclassListeners, accessor.excludeSuperclassListeners(), accessor.getAccessibleObject(), "<exclude-superclass-listeners>");
        this.m_readOnly = (Boolean)this.mergeSimpleObjects(this.m_readOnly, accessor.getReadOnly(), accessor.getAccessibleObject(), "@read-only");
        this.m_idClass = (Class)this.mergeSimpleObjects(this.m_idClass, accessor.getIdClassName(), accessor.getAccessibleObject(), "<id-class>");
        this.m_prePersist = (String)this.mergeSimpleObjects(this.m_prePersist, accessor.getPrePersist(), accessor.getAccessibleObject(), "<pre-persist>");
        this.m_postPersist = (String)this.mergeSimpleObjects(this.m_postPersist, accessor.getPostPersist(), accessor.getAccessibleObject(), "<post-persist>");
        this.m_preRemove = (String)this.mergeSimpleObjects(this.m_preRemove, accessor.getPreRemove(), accessor.getAccessibleObject(), "<pre-remove>");
        this.m_postRemove = (String)this.mergeSimpleObjects(this.m_postRemove, accessor.getPostRemove(), accessor.getAccessibleObject(), "<post-remove>");
        this.m_preUpdate = (String)this.mergeSimpleObjects(this.m_preUpdate, accessor.getPreUpdate(), accessor.getAccessibleObject(), "<pre-update>");
        this.m_postUpdate = (String)this.mergeSimpleObjects(this.m_postUpdate, accessor.getPostUpdate(), accessor.getAccessibleObject(), "<post-update>");
        this.m_postLoad = (String)this.mergeSimpleObjects(this.m_postLoad, accessor.getPostLoad(), accessor.getAccessibleObject(), "<post-load>");
        this.m_existenceChecking = (ExistenceType)((Object)this.mergeSimpleObjects((Object)this.m_existenceChecking, (Object)accessor.getExistenceChecking(), accessor.getAccessibleObject(), "@existence-checking"));
        this.m_cache = (CacheMetadata)this.mergeORObjects(this.m_cache, accessor.getCache());
        this.m_cacheInterceptor = (CacheInterceptorMetadata)this.mergeORObjects(this.m_cacheInterceptor, accessor.getCacheInterceptor());
        this.m_optimisticLocking = (OptimisticLockingMetadata)this.mergeORObjects(this.m_optimisticLocking, accessor.getOptimisticLocking());
        this.m_primaryKey = (PrimaryKeyMetadata)this.mergeORObjects(this.m_primaryKey, accessor.getPrimaryKey());
        this.m_entityListeners = this.mergeORObjectLists(this.m_entityListeners, accessor.getEntityListeners());
    }

    @Override
    public void process() {
        this.processClassMetadata();
        this.addAccessors();
    }

    protected void processAssociationOverride(AssociationOverrideMetadata associationOverride) {
        if (associationOverride.shouldOverride(this.getDescriptor().getAssociationOverrideFor(associationOverride.getName()), this.getLogger(), this.getDescriptor().getJavaClassName())) {
            this.getDescriptor().addAssociationOverride(associationOverride);
        }
    }

    protected void processAssociationOverrides() {
        Object associationOverride;
        Object associationOverrides = this.getAnnotation(AssociationOverrides.class);
        if (associationOverrides != null) {
            for (Annotation associationOverride2 : (Annotation[])MetadataHelper.invokeMethod("value", associationOverrides)) {
                this.processAssociationOverride(new AssociationOverrideMetadata(associationOverride2, this.getAccessibleObject()));
            }
        }
        if ((associationOverride = this.getAnnotation(AssociationOverride.class)) != null) {
            this.processAssociationOverride(new AssociationOverrideMetadata((Annotation)associationOverride, this.getAccessibleObject()));
        }
    }

    protected void processAttributeOverride(AttributeOverrideMetadata attributeOverride) {
        if (attributeOverride.shouldOverride(this.getDescriptor().getAttributeOverrideFor(attributeOverride.getName()), this.getLogger(), this.getDescriptor().getJavaClassName())) {
            this.getDescriptor().addAttributeOverride(attributeOverride);
        }
    }

    protected void processAttributeOverrides() {
        Object attributeOverride;
        Object attributeOverrides = this.getAnnotation(AttributeOverrides.class);
        if (attributeOverrides != null) {
            for (Annotation attributeOverride2 : (Annotation[])MetadataHelper.invokeMethod("value", attributeOverrides)) {
                this.processAttributeOverride(new AttributeOverrideMetadata(attributeOverride2, this.getAccessibleObject()));
            }
        }
        if ((attributeOverride = this.getAnnotation(AttributeOverride.class)) != null) {
            this.processAttributeOverride(new AttributeOverrideMetadata((Annotation)attributeOverride, this.getAccessibleObject()));
        }
    }

    protected void processCache() {
        if (this.m_cache != null || this.isAnnotationPresent(Cache.class)) {
            if (this.getDescriptor().isInheritanceSubclass()) {
                this.getLogger().logWarningMessage("metadata_warning_ignore_inheritance_subclass_cache", this.getJavaClass());
            } else if (this.getDescriptor().hasCache()) {
                this.getLogger().logWarningMessage("metadata_warning_ignore_mapped_superclass_cache", this.getDescriptor().getJavaClass(), this.getJavaClass());
            } else if (this.m_cache == null) {
                new CacheMetadata((Annotation)this.getAnnotation(Cache.class), this.getAccessibleObject()).process(this.getDescriptor(), this.getJavaClass());
            } else {
                this.m_cache.process(this.getDescriptor(), this.getJavaClass());
            }
        }
    }

    protected void processCacheInterceptor() {
        if (this.m_cacheInterceptor != null || this.isAnnotationPresent(CacheInterceptor.class)) {
            if (this.getDescriptor().isInheritanceSubclass()) {
                this.getLogger().logWarningMessage("metadata_warning_ignore_inheritance_subclass_cache_interceptor", this.getJavaClass());
            } else if (this.getDescriptor().hasCacheInterceptor()) {
                this.getLogger().logWarningMessage("metadata_warning_ignore_mapped_superclass_cache_interceptor", this.getDescriptor().getJavaClass(), this.getJavaClass());
            } else if (this.m_cacheInterceptor == null) {
                new CacheInterceptorMetadata((Annotation)this.getAnnotation(CacheInterceptor.class), this.getAccessibleObject()).process(this.getDescriptor(), this.getJavaClass());
            } else {
                this.m_cacheInterceptor.process(this.getDescriptor(), this.getJavaClass());
            }
        }
    }

    protected void processDefaultRedirectors() {
        if (this.m_defaultRedirectors != null || this.isAnnotationPresent(QueryRedirectors.class)) {
            if (this.getDescriptor().isInheritanceSubclass()) {
                this.getLogger().logWarningMessage("metadata_warning_ignore_inheritance_subclass_default_redirectors", this.getJavaClass());
            } else if (this.getDescriptor().hasDefaultRedirectors()) {
                this.getLogger().logWarningMessage("metadata_warning_ignore_mapped_superclass_default_redirectors", this.getDescriptor().getJavaClass(), this.getJavaClass());
            } else if (this.m_defaultRedirectors == null) {
                new DefaultRedirectorsMetadata((Annotation)this.getAnnotation(QueryRedirectors.class), this.getAccessibleObject()).process(this.getDescriptor(), this.getJavaClass());
            } else {
                this.m_defaultRedirectors.process(this.getDescriptor(), this.getJavaClass());
            }
        }
    }

    protected void processClassMetadata() {
        this.processAttributeOverrides();
        this.processAssociationOverrides();
        this.processNamedQueries();
        this.processNamedNativeQueries();
        this.processNamedStoredProcedureQueries();
        this.processSqlResultSetMappings();
        this.processTableGenerator();
        this.processSequenceGenerator();
        this.processIdClass();
        this.processPrimaryKey();
        this.processExcludeDefaultListeners();
        this.processExcludeSuperclassListeners();
        this.processConverters();
        this.processOptimisticLocking();
        this.processCache();
        this.processCacheInterceptor();
        this.processDefaultRedirectors();
        this.processChangeTracking();
        this.processReadOnly();
        this.processCustomizer();
        this.processCopyPolicy();
        this.processExistenceChecking();
        this.processProperties();
    }

    public void processEntityListeners(ClassLoader loader) {
        block3: {
            block2: {
                if (!this.m_entityListeners.isEmpty()) break block2;
                Object entityListeners = this.getAnnotation(EntityListeners.class);
                if (entityListeners == null) break block3;
                for (Class entityListenerClass : (Class[])MetadataHelper.invokeMethod("value", entityListeners)) {
                    EntityListenerMetadata listener = new EntityListenerMetadata((Annotation)entityListeners, entityListenerClass, this.getAccessibleObject());
                    listener.process(this.getDescriptor(), loader, false);
                }
                break block3;
            }
            for (EntityListenerMetadata listener : this.m_entityListeners) {
                listener.process(this.getDescriptor(), loader, false);
            }
        }
    }

    protected void processExcludeDefaultListeners() {
        if (this.excludeDefaultListeners()) {
            this.getDescriptor().setExcludeDefaultListeners(true);
        } else if (this.isAnnotationPresent(ExcludeDefaultListeners.class)) {
            this.getDescriptor().setExcludeDefaultListeners(true);
        }
    }

    protected void processExcludeSuperclassListeners() {
        if (this.excludeSuperclassListeners()) {
            this.getDescriptor().setExcludeSuperclassListeners(true);
        } else if (this.isAnnotationPresent(ExcludeSuperclassListeners.class)) {
            this.getDescriptor().setExcludeSuperclassListeners(true);
        }
    }

    protected void processExistenceChecking() {
        Object existenceChecking = this.getAnnotation(ExistenceChecking.class);
        if (this.m_existenceChecking != null || existenceChecking != null) {
            if (this.getDescriptor().hasExistenceChecking()) {
                this.getLogger().logWarningMessage("metadata_warning_ignore_mapped_superclass_existence_checking", this.getDescriptor().getJavaClass(), this.getJavaClass());
            } else if (this.m_existenceChecking == null) {
                this.getDescriptor().setExistenceChecking((Enum)MetadataHelper.invokeMethod("value", existenceChecking));
            } else {
                if (existenceChecking != null) {
                    this.getLogger().logWarningMessage("metadata_warning_override_annotation_with_xml", existenceChecking, this.getJavaClassName(), this.getLocation());
                }
                this.getDescriptor().setExistenceChecking(this.m_existenceChecking);
            }
        }
    }

    protected void processIdClass() {
        Object idClass = this.getAnnotation(IdClass.class);
        if (this.m_idClass == null || this.m_idClass.equals(Void.TYPE)) {
            if (idClass == null) {
                return;
            }
            this.m_idClass = (Class)MetadataHelper.invokeMethod("value", idClass);
        } else if (idClass != null) {
            this.getLogger().logWarningMessage("metadata_warning_override_annotation_with_xml", idClass, this.getJavaClassName(), this.getLocation());
        }
        this.getDescriptor().setPKClass(this.m_idClass);
        if (this.getDescriptor().usesDefaultPropertyAccess()) {
            for (Method method : MetadataHelper.getDeclaredMethods(this.m_idClass)) {
                MetadataMethod metadataMethod = new MetadataMethod(method, this.getLogger());
                if (!metadataMethod.isValidPersistenceMethod(false, this.getDescriptor())) continue;
                this.getDescriptor().addPKClassId(metadataMethod.getAttributeName(), metadataMethod.getRelationType());
            }
        } else {
            for (Field field : MetadataHelper.getFields(this.m_idClass)) {
                MetadataField metadataField = new MetadataField(field, this.getLogger());
                if (!metadataField.isValidPersistenceField(false, this.getDescriptor())) continue;
                this.getDescriptor().addPKClassId(field.getName(), field.getGenericType());
            }
        }
    }

    protected void processNamedNativeQueries() {
        Object namedNativeQuery;
        Object namedNativeQueries = this.getAnnotation(NamedNativeQueries.class);
        if (namedNativeQueries != null) {
            for (Annotation namedNativeQuery2 : (Annotation[])MetadataHelper.invokeMethod("value", namedNativeQueries)) {
                this.getProject().addQuery(new NamedNativeQueryMetadata(namedNativeQuery2, this.getAccessibleObject()));
            }
        }
        if ((namedNativeQuery = this.getAnnotation(NamedNativeQuery.class)) != null) {
            this.getProject().addQuery(new NamedNativeQueryMetadata((Annotation)namedNativeQuery, this.getAccessibleObject()));
        }
    }

    protected void processNamedQueries() {
        Object namedQuery;
        Object namedQueries = this.getAnnotation(NamedQueries.class);
        if (namedQueries != null) {
            for (Annotation namedQuery2 : (Annotation[])MetadataHelper.invokeMethod("value", namedQueries)) {
                this.getProject().addQuery(new NamedQueryMetadata(namedQuery2, this.getAccessibleObject()));
            }
        }
        if ((namedQuery = this.getAnnotation(NamedQuery.class)) != null) {
            this.getProject().addQuery(new NamedQueryMetadata((Annotation)namedQuery, this.getAccessibleObject()));
        }
    }

    protected void processNamedStoredProcedureQueries() {
        Object namedStoredProcedureQuery;
        Object namedStoredProcedureQueries = this.getAnnotation(NamedStoredProcedureQueries.class);
        if (namedStoredProcedureQueries != null) {
            for (Annotation namedStoredProcedureQuery2 : (Annotation[])MetadataHelper.invokeMethod("value", namedStoredProcedureQueries)) {
                this.getProject().addQuery(new NamedStoredProcedureQueryMetadata(namedStoredProcedureQuery2, this.getAccessibleObject()));
            }
        }
        if ((namedStoredProcedureQuery = this.getAnnotation(NamedStoredProcedureQuery.class)) != null) {
            this.getProject().addQuery(new NamedStoredProcedureQueryMetadata((Annotation)namedStoredProcedureQuery, this.getAccessibleObject()));
        }
    }

    protected void processOptimisticLocking() {
        if (this.getDescriptor().usesOptimisticLocking()) {
            if (this.m_optimisticLocking != null || this.isAnnotationPresent(OptimisticLocking.class)) {
                this.getLogger().logWarningMessage("metadata_warning_ignore_mapped_superclass_optimistic_locking", this.getDescriptor().getJavaClass(), this.getJavaClass());
            }
        } else {
            Object optimisticLocking = this.getAnnotation(OptimisticLocking.class);
            if (this.m_optimisticLocking == null) {
                if (optimisticLocking != null) {
                    new OptimisticLockingMetadata((Annotation)optimisticLocking, this.getAccessibleObject()).process(this.getDescriptor());
                }
            } else {
                if (optimisticLocking != null) {
                    this.getLogger().logWarningMessage("metadata_warning_override_annotation_with_xml", optimisticLocking, this.getJavaClassName(), this.getLocation());
                }
                this.m_optimisticLocking.process(this.getDescriptor());
            }
        }
    }

    protected void processReadOnly() {
        Object readOnly = this.getAnnotation(ReadOnly.class);
        if (this.m_readOnly != null || readOnly != null) {
            if (this.getDescriptor().isInheritanceSubclass()) {
                this.getLogger().logWarningMessage("metadata_warning_ignore_inheritance_subclass_read_only", this.getJavaClass());
            } else if (this.getDescriptor().hasReadOnly()) {
                this.getLogger().logWarningMessage("metadata_warning_ignore_mapped_superclass_read_only", this.getDescriptor().getJavaClass(), this.getJavaClass());
            } else if (this.m_readOnly == null) {
                this.getDescriptor().setReadOnly(true);
            } else {
                if (readOnly != null) {
                    this.getLogger().logWarningMessage("metadata_warning_override_annotation_with_xml", readOnly, this.getJavaClassName(), this.getLocation());
                }
                this.getDescriptor().setReadOnly(this.m_readOnly);
            }
        }
    }

    protected void processPrimaryKey() {
        Object primaryKey = this.getAnnotation(PrimaryKey.class);
        if (this.m_primaryKey == null) {
            if (primaryKey != null) {
                new PrimaryKeyMetadata((Annotation)primaryKey, this.getAccessibleObject()).process(this.getDescriptor());
            }
        } else {
            if (primaryKey != null) {
                this.getLogger().logWarningMessage("metadata_warning_override_annotation_with_xml", primaryKey, this.getJavaClassName(), this.getLocation());
            }
            this.m_primaryKey.process(this.getDescriptor());
        }
    }

    protected void processSequenceGenerator() {
        if (this.isAnnotationPresent(SequenceGenerator.class)) {
            this.getProject().addSequenceGenerator(new SequenceGeneratorMetadata((Annotation)this.getAnnotation(SequenceGenerator.class), this.getAccessibleObject()));
        }
    }

    protected void processSqlResultSetMappings() {
        Object sqlResultSetMappings = this.getAnnotation(SqlResultSetMappings.class);
        if (sqlResultSetMappings != null) {
            for (Annotation sqlResultSetMapping : (Annotation[])MetadataHelper.invokeMethod("value", sqlResultSetMappings)) {
                this.getProject().addSQLResultSetMapping(new SQLResultSetMappingMetadata(sqlResultSetMapping, this.getAccessibleObject()));
            }
        } else {
            Object sqlResultSetMapping = this.getAnnotation(SqlResultSetMapping.class);
            if (sqlResultSetMapping != null) {
                this.getProject().addSQLResultSetMapping(new SQLResultSetMappingMetadata((Annotation)sqlResultSetMapping, this.getAccessibleObject()));
            }
        }
    }

    protected void processTableGenerator() {
        if (this.isAnnotationPresent(TableGenerator.class)) {
            this.getProject().addTableGenerator(new TableGeneratorMetadata((Annotation)this.getAnnotation(TableGenerator.class), this.getAccessibleObject()), this.getDescriptor().getDefaultCatalog(), this.getDescriptor().getDefaultSchema());
        }
    }

    public void setCache(CacheMetadata cache) {
        this.m_cache = cache;
    }

    public void setCacheInterceptor(CacheInterceptorMetadata cacheInterceptor) {
        this.m_cacheInterceptor = cacheInterceptor;
    }

    public void setEntityListeners(List<EntityListenerMetadata> entityListeners) {
        this.m_entityListeners = entityListeners;
    }

    public void setExcludeDefaultListeners(String ignore) {
        this.m_excludeDefaultListeners = true;
    }

    public void setExcludeSuperclassListeners(String ignore) {
        this.m_excludeSuperclassListeners = true;
    }

    public void setExistenceChecking(ExistenceType checking) {
        this.m_existenceChecking = checking;
    }

    public void setIdClassName(String idClassName) {
        this.m_idClassName = idClassName;
    }

    public void setOptimisticLocking(OptimisticLockingMetadata optimisticLocking) {
        this.m_optimisticLocking = optimisticLocking;
    }

    public void setPostLoad(String postLoad) {
        this.m_postLoad = postLoad;
    }

    public void setPostPersist(String postPersist) {
        this.m_postPersist = postPersist;
    }

    public void setPostRemove(String postRemove) {
        this.m_postRemove = postRemove;
    }

    public void setPostUpdate(String postUpdate) {
        this.m_postUpdate = postUpdate;
    }

    public void setPrePersist(String prePersist) {
        this.m_prePersist = prePersist;
    }

    public void setPreRemove(String preRemove) {
        this.m_preRemove = preRemove;
    }

    public void setPreUpdate(String preUpdate) {
        this.m_preUpdate = preUpdate;
    }

    public void setReadOnly(Boolean readOnly) {
        this.m_readOnly = readOnly;
    }
}

