/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.generator.lib;

import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.CodeVisitor;
import org.objectweb.jorm.generator.lib.LoggedClassAdapter;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class RedundencyRemover
extends LoggedClassAdapter {
    boolean hasDotClassMethod = false;
    List methodNames = new ArrayList();
    String className;

    public RedundencyRemover(ClassVisitor classVisitor, Logger logger) {
        super(classVisitor, logger);
    }

    public void visit(int version, int access, String name, String superName, String[] interfaces, String sourceFile) {
        this.className = name;
        super.visit(version, access, name, superName, interfaces, sourceFile);
    }

    public CodeVisitor visitMethod(int access, String name, String desc, String[] exceptions, Attribute attrs) {
        String mn = name;
        if ("class$".equals(name)) {
            if (this.hasDotClassMethod) {
                if (this.debug) {
                    this.logger.log(BasicLevel.DEBUG, (Object)"remove useless .class static method");
                }
                return null;
            }
            if (this.debug) {
                this.logger.log(BasicLevel.DEBUG, (Object)"First .class static method");
            }
            this.hasDotClassMethod = true;
        } else if ("<clinit>".equals(name)) {
            mn = "clinit$" + this.methodNames.size();
            this.methodNames.add(mn);
            if (this.debug) {
                this.logger.log(BasicLevel.DEBUG, (Object)("rename a static section to " + mn));
            }
        }
        return super.visitMethod(access, mn, desc, exceptions, attrs);
    }

    public void visitEnd() {
        CodeVisitor _cv = this.cv.visitMethod(8, "<clinit>", "()V", null, null);
        for (int i = 0; i < this.methodNames.size(); ++i) {
            String mn = (String)this.methodNames.get(i);
            _cv.visitMethodInsn(184, this.className, mn, "()V");
        }
        _cv.visitInsn(177);
        super.visitEnd();
    }
}

