/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.medor.eval.lib;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.objectweb.medor.api.EvaluationException;
import org.objectweb.medor.api.MedorException;
import org.objectweb.medor.datasource.api.Wrapper;
import org.objectweb.medor.eval.api.ConnectionResources;
import org.objectweb.medor.eval.api.EvaluationMetaData;
import org.objectweb.medor.eval.lib.AbstractQueryEvaluator;
import org.objectweb.medor.eval.lib.MedorConnectionResources;
import org.objectweb.medor.eval.prefetch.api.PrefetchBuffer;
import org.objectweb.medor.expression.api.ParameterOperand;
import org.objectweb.medor.expression.api.VariableOperand;
import org.objectweb.medor.expression.lib.BasicVariableOperand;
import org.objectweb.medor.query.api.QueryLeaf;
import org.objectweb.medor.query.api.QueryNode;
import org.objectweb.medor.query.api.QueryTree;
import org.objectweb.medor.query.rdb.lib.AggregateRdbQueryNode;
import org.objectweb.medor.tuple.api.TupleCollection;

public class DeleteEvaluator
extends AbstractQueryEvaluator {
    List queryLeaves = null;

    public DeleteEvaluator(QueryTree query) throws EvaluationException {
        super(query);
        this.getQueryLeaves();
    }

    public ConnectionResources getRequiredConnectionResources() {
        HashMap qls = new HashMap(1);
        int size = this.queryLeaves.size();
        for (int i = 0; i < size; ++i) {
            qls.put(this.queryLeaves.get(i), null);
        }
        return new MedorConnectionResources(qls);
    }

    protected List getQueryLeaves() throws EvaluationException {
        if (this.queryLeaves != null) {
            return this.queryLeaves;
        }
        this.queryLeaves = new ArrayList();
        ArrayList<QueryTree> toTreat = new ArrayList<QueryTree>();
        toTreat.add(this.query);
        while (!toTreat.isEmpty()) {
            QueryTree cur = (QueryTree)toTreat.remove(0);
            if (cur instanceof QueryLeaf) {
                this.queryLeaves.add(cur);
                continue;
            }
            if (!(cur instanceof QueryNode) || cur instanceof AggregateRdbQueryNode) continue;
            QueryTree[] children = ((QueryNode)cur).getChildren();
            for (int i = 0; i < children.length; ++i) {
                toTreat.add(children[i]);
            }
        }
        return this.queryLeaves;
    }

    public long getCacheSize() {
        return 0L;
    }

    public TupleCollection evaluate(ParameterOperand[] parameters, ConnectionResources resources, PrefetchBuffer pb, Map evalMDMap) throws EvaluationException {
        return this.evaluate(parameters, resources, evalMDMap);
    }

    public TupleCollection evaluate(ParameterOperand[] parameters, ConnectionResources resources, Map evalMDMap) throws EvaluationException {
        long result = 0L;
        Iterator qlsIt = this.queryLeaves.iterator();
        while (qlsIt.hasNext()) {
            QueryLeaf ql = (QueryLeaf)qlsIt.next();
            Object conn = resources != null ? resources.getConnection(ql) : null;
            EvaluationMetaData emd = evalMDMap != null ? (EvaluationMetaData)evalMDMap.get(ql) : null;
            try {
                result += this.perfom(this.wrapperFactory.getWrapper(ql.getDataStore()), ql, parameters, conn, emd);
            }
            catch (MedorException mexp) {
                throw new EvaluationException(mexp);
            }
        }
        try {
            return DeleteEvaluator.getMemoryTupleCollection(new VariableOperand[]{new BasicVariableOperand(result)});
        }
        catch (MedorException mexp) {
            throw new EvaluationException(mexp);
        }
    }

    protected long perfom(Wrapper w, QueryLeaf ql, ParameterOperand[] parameters, Object conn, EvaluationMetaData emd) throws MedorException {
        return w.deleteData(ql, parameters, conn, emd);
    }
}

