/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.container.management;

import java.io.IOException;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.management.MBeanException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.ow2.easybeans.api.EZBContainerException;
import org.ow2.easybeans.container.JContainer3;
import org.ow2.easybeans.jsr77.EJBModuleMBean;
import org.ow2.util.archive.api.ArchiveException;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class JContainer3MBean
extends EJBModuleMBean {
    public void start() {
        try {
            ((JContainer3)this.getManagedComponent()).start();
        }
        catch (EZBContainerException ece) {
            JContainer3MBean.getLogger().error((Object)"Cannot start the EJB Container", new Object[]{ece});
            throw new RuntimeException(ece);
        }
    }

    public URL getUrl() {
        try {
            IDeployable deployable = ((JContainer3)this.getManagedComponent()).getDeployable();
            if (deployable.getOriginalDeployable() != null) {
                deployable = deployable.getOriginalDeployable();
            }
            return deployable.getArchive().getURL();
        }
        catch (ArchiveException e) {
            JContainer3MBean.getLogger().error((Object)"Cannot get URL on the archive", new Object[]{e});
            throw new RuntimeException(e);
        }
    }

    public void stop() {
        ((JContainer3)this.getManagedComponent()).stop();
    }

    public String loadClass(String className) {
        Transformer transformer;
        JContainer3 container = (JContainer3)this.getManagedComponent();
        ClassLoader ejbClassLoader = container.getClassLoader();
        boolean inEAR = container.getApplicationName() != null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException("Cannot build document builder", e);
        }
        Document document = builder.newDocument();
        Element classElement = document.createElement("class");
        document.appendChild(classElement);
        classElement.setAttribute("name", className);
        boolean classNotFound = false;
        String error = null;
        Class<?> clazz = null;
        try {
            clazz = ejbClassLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            error = e.toString();
            classNotFound = true;
        }
        catch (Error e) {
            classNotFound = true;
            error = e.toString();
        }
        classElement.setAttribute("classNotFound", Boolean.toString(classNotFound));
        if (classNotFound) {
            Element errorElement = document.createElement("error");
            classElement.appendChild(errorElement);
            Text errorText = document.createTextNode(error);
            errorElement.appendChild(errorText);
        } else {
            String type = null;
            type = inEAR ? "Application / EJBs" : "Application/EJBJAR (This module)";
            ClassLoader classClassLoader = clazz.getClassLoader();
            boolean found = false;
            for (ClassLoader cl = ejbClassLoader; cl != null && !found; cl = cl.getParent()) {
                if (!cl.equals(classClassLoader)) continue;
                found = true;
            }
            if (!found) {
                type = "System";
            }
            classElement.setAttribute("where", type);
            if (classClassLoader != null) {
                Element classLoaderElement = document.createElement("class-loader");
                classElement.appendChild(classLoaderElement);
                classLoaderElement.setAttribute("name", classClassLoader.getClass().getName());
                Text classLoaderText = document.createTextNode(classClassLoader.toString());
                classLoaderElement.appendChild(classLoaderText);
            }
        }
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            transformer = transformerFactory.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            throw new IllegalStateException("Unable to get a new transformer", e);
        }
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        try {
            transformer.transform(new DOMSource(document), streamResult);
        }
        catch (TransformerException e) {
            throw new IllegalStateException("Unable to transform the document", e);
        }
        return stringWriter.toString();
    }

    public URL[] getResources(String resourceName) {
        ClassLoader classLoader = ((JContainer3)this.getManagedComponent()).getClassLoader();
        Enumeration<URL> urls = null;
        try {
            urls = classLoader.getResources(resourceName);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to get the resource '" + resourceName + "'.", e);
        }
        ArrayList<URL> urlsList = new ArrayList<URL>();
        while (urls.hasMoreElements()) {
            urlsList.add(urls.nextElement());
        }
        return urlsList.toArray(new URL[urlsList.size()]);
    }
}

