/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.enhancer.interceptors;

import java.util.List;
import org.ow2.easybeans.api.Factory;
import org.ow2.easybeans.api.container.EZBEJBContext;
import org.ow2.easybeans.asm.ClassVisitor;
import org.ow2.easybeans.asm.MethodVisitor;
import org.ow2.easybeans.asm.Type;
import org.ow2.easybeans.deployment.metadata.ejbjar.EjbJarArchiveMetadata;
import org.ow2.easybeans.enhancer.CommonClassGenerator;
import org.ow2.easybeans.enhancer.EasyBeansClassWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterceptorManagerGenerator
extends CommonClassGenerator {
    private EjbJarArchiveMetadata ejbJarAnnotationMetadata = null;
    private String generatedClassName = null;
    private List<String> allInterceptors = null;
    public static final String[] INTERFACES = new String[]{"org/ow2/easybeans/api/injection/EasyBeansInjection"};
    private static final String EZB_EJBCONTEXT_DESC = Type.getDescriptor(EZBEJBContext.class);

    public InterceptorManagerGenerator(EjbJarArchiveMetadata ejbJarAnnotationMetadata, String generatedClassName, List<String> allInterceptors, ClassLoader readLoader) {
        super(new EasyBeansClassWriter(readLoader));
        this.ejbJarAnnotationMetadata = ejbJarAnnotationMetadata;
        this.generatedClassName = generatedClassName;
        this.allInterceptors = allInterceptors;
    }

    public void generate() {
        this.addClassDeclaration();
        this.addAttributes();
        this.addConstructor();
        this.addMethods();
        this.endClass();
    }

    private void addClassDeclaration() {
        this.getCW().visit(49, 33, this.generatedClassName, null, "java/lang/Object", INTERFACES);
    }

    private void addAttributes() {
        for (String interceptor : this.allInterceptors) {
            String fieldName = InterceptorManagerGenerator.getField(interceptor);
            this.addAttribute(2, fieldName, InterceptorManagerGenerator.encodeClassDesc(interceptor));
        }
    }

    private static String getField(String interceptorClass) {
        return interceptorClass.replace("/", "");
    }

    private static String getMethod(String interceptorClass) {
        return "get" + interceptorClass.replace("/", "");
    }

    private void addConstructor() {
        MethodVisitor mv = this.getCW().visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V");
        for (String interceptor : this.allInterceptors) {
            mv.visitVarInsn(25, 0);
            mv.visitTypeInsn(187, interceptor);
            mv.visitInsn(89);
            mv.visitMethodInsn(183, interceptor, "<init>", "()V");
            mv.visitFieldInsn(181, this.generatedClassName, InterceptorManagerGenerator.getField(interceptor), InterceptorManagerGenerator.encodeClassDesc(interceptor));
        }
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void addMethods() {
        this.addGetterMethods();
        this.addInjectedMethod();
        this.addDefaultMethods();
    }

    private void addDefaultMethods() {
        CommonClassGenerator.addFieldGettersSetters((ClassVisitor)this.getCW(), this.generatedClassName, "easyBeansFactory", Factory.class);
        CommonClassGenerator.addFieldGettersSetters((ClassVisitor)this.getCW(), this.generatedClassName, "easyBeansContext", EZBEJBContext.class);
    }

    private void addGetterMethods() {
        for (String interceptor : this.allInterceptors) {
            MethodVisitor mv = this.getCW().visitMethod(1, InterceptorManagerGenerator.getMethod(interceptor), "()" + InterceptorManagerGenerator.encodeClassDesc(interceptor), null, null);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, this.generatedClassName, InterceptorManagerGenerator.getField(interceptor), InterceptorManagerGenerator.encodeClassDesc(interceptor));
            mv.visitInsn(176);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }
    }

    private void addInjectedMethod() {
        MethodVisitor mv = this.getCW().visitMethod(1, "injectedByEasyBeans", "()V", null, null);
        mv.visitCode();
        for (String interceptor : this.allInterceptors) {
            if (this.ejbJarAnnotationMetadata.getScannedClassMetadata(interceptor) == null) continue;
            String fieldName = InterceptorManagerGenerator.getField(interceptor);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, this.generatedClassName, fieldName, InterceptorManagerGenerator.encodeClassDesc(interceptor));
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, this.generatedClassName, "easyBeansContext", EZB_EJBCONTEXT_DESC);
            mv.visitMethodInsn(182, interceptor, "setEasyBeansContext", "(" + EZB_EJBCONTEXT_DESC + ")V");
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, this.generatedClassName, fieldName, InterceptorManagerGenerator.encodeClassDesc(interceptor));
            mv.visitMethodInsn(182, interceptor, "injectedByEasyBeans", "()V");
        }
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void endClass() {
        this.getCW().visitEnd();
    }

    public byte[] getBytes() {
        return this.getCW().toByteArray();
    }
}

