/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.resource.internal.mbean;

import java.util.Map;
import java.util.Properties;
import org.ow2.jonas.lib.management.javaee.J2EEManagedObject;
import org.ow2.jonas.resource.internal.cm.ConnectionManagerImpl;
import org.ow2.jonas.resource.internal.pool.Pool;

public class JCAConnectionFactory
extends J2EEManagedObject {
    private String managedConnectionFactory = null;
    private String description = null;
    private String jndiname = null;
    private Properties prop = null;
    private ConnectionManagerImpl cm = null;
    private Pool pool = null;
    private String fileName = null;
    private long sequenceNumber = 0L;

    public JCAConnectionFactory(String objectName, String jndiname, String fileName, Properties prop, String description, ConnectionManagerImpl cm) {
        super(objectName);
        this.jndiname = jndiname;
        this.prop = prop;
        this.description = description;
        this.cm = cm;
        this.pool = cm.getPool();
        this.fileName = fileName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getJndiName() {
        return this.jndiname;
    }

    public String getManagedConnectionFactory() {
        return this.managedConnectionFactory;
    }

    public Properties getProperties() {
        return this.prop;
    }

    public void setManagedConnectionFactory(String managedConnectionFactoryObjectName) {
        this.managedConnectionFactory = managedConnectionFactoryObjectName;
    }

    public boolean isJdbcConnSetUp() {
        return this.cm.isJdbcConnSetUp();
    }

    public Integer getJdbcConnCheckLevel() {
        return new Integer(this.cm.getCheckLevel());
    }

    public void setJdbcConnCheckLevel(Integer level) {
        this.cm.setCheckLevel(level);
    }

    public String getJdbcTestStatement() {
        return this.cm.getTestStatement();
    }

    public void setJdbcTestStatement(String test) {
        this.cm.setTestStatement(test);
    }

    public Integer getPstmtMax() {
        return new Integer(this.cm.getMaxPstmtPoolSize());
    }

    public void setPstmtMax(Integer size) {
        this.cm.setMaxPstmtPoolSize(size);
    }

    public Integer getConnMaxAge() {
        return new Integer(this.pool.getMaxAge());
    }

    public void setConnMaxAge(Integer mn) {
        this.pool.setMaxAge(mn);
    }

    public Integer getMaxSize() {
        return new Integer(this.pool.getMaxSize());
    }

    public void setMaxSize(Integer max) {
        try {
            this.pool.setMaxSize(max);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Integer getMaxOpentime() {
        return new Integer(this.pool.getMaxOpentime());
    }

    public void setMaxOpentime(Integer mn) {
        this.pool.setMaxOpentime(mn);
    }

    public Integer getMaxWaiters() {
        return new Integer(this.pool.getMaxWaiters());
    }

    public void setMaxWaiters(Integer max) {
        this.pool.setMaxWaiters(max);
    }

    public Integer getMaxWaitTime() {
        return new Integer(this.pool.getMaxWaitTime());
    }

    public void setMaxWaitTime(Integer max) {
        this.pool.setMaxWaitTime(max);
    }

    public Integer getMinSize() {
        return new Integer(this.pool.getMinSize());
    }

    public Integer getInitSize() {
        return new Integer(this.pool.getInitSize());
    }

    public void setMinSize(Integer min) {
        try {
            this.pool.setMinSize(min);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Integer getSamplingPeriod() {
        return new Integer(this.pool.getSamplingPeriod());
    }

    public void setSamplingPeriod(Integer i) {
        this.pool.setSamplingPeriod(i);
    }

    public Integer getConnectionFailures() {
        return new Integer(this.pool.getConnectionFailures());
    }

    public Integer getConnectionLeaks() {
        return new Integer(this.pool.getConnectionLeaks());
    }

    public Integer getCurrentBusy() {
        return new Integer(this.pool.getCurrentBusy());
    }

    public Integer getBusyMax() {
        return new Integer(this.pool.getBusyMaxRecent());
    }

    public Integer getBusyMin() {
        return new Integer(this.pool.getBusyMinRecent());
    }

    public Integer getCurrentInTx() {
        return new Integer(this.cm.getCurrentInTx());
    }

    public Integer getCurrentOpened() {
        return new Integer(this.pool.getCurrentOpened());
    }

    public Integer getCurrentWaiters() {
        return new Integer(this.pool.getCurrentWaiters());
    }

    public Integer getOpenedCount() {
        return new Integer(this.pool.getOpenedCount());
    }

    public Integer getRejectedFull() {
        return new Integer(this.pool.getRejectedFull());
    }

    public Integer getRejectedOpen() {
        return new Integer(this.pool.getRejectedOpen());
    }

    public Integer getRejectedOther() {
        return new Integer(this.pool.getRejectedOther());
    }

    public Integer getRejectedTimeout() {
        return new Integer(this.pool.getRejectedTimeout());
    }

    public Integer getServedOpen() {
        return new Integer(this.pool.getServedOpen());
    }

    public Integer getWaiterCount() {
        return new Integer(this.pool.getWaiterCount());
    }

    public Integer getWaitersHigh() {
        return new Integer(this.pool.getWaitersHigh());
    }

    public Integer getWaitersHighRecent() {
        return new Integer(this.pool.getWaitersHighRecent());
    }

    public Long getWaitingHigh() {
        return new Long(this.pool.getWaitingHigh());
    }

    public Long getWaitingHighRecent() {
        return new Long(this.pool.getWaitingHighRecent());
    }

    public Long getWaitingTime() {
        return new Long(this.pool.getWaitingTime());
    }

    public int[] getOpenedConnections(int seconds) {
        return this.cm.getOpenedConnections(seconds);
    }

    public int[] getOpenedConnections() {
        return this.cm.getOpenedConnections();
    }

    public Map getConnectionDetails(int connectionId) {
        return this.cm.getConnectionDetails(connectionId);
    }

    public void forceCloseConnection(int connectionId) {
        this.cm.forceCloseConnection(connectionId);
    }

    public void setObservable(boolean observable) {
        this.cm.setObservable(observable);
    }

    public boolean isObservable() {
        return this.cm.isObservable();
    }

    protected long getSequenceNumber() {
        return ++this.sequenceNumber;
    }

    public String getFileName() {
        return this.fileName;
    }

    public long getTotalPstmtFoundInCache() {
        return this.cm.getTotalPstmtFoundInCache();
    }

    public long getTotalPstmtPutInCache() {
        return this.cm.getTotalPstmtPutInCache();
    }

    public long getMaxPstmtJumpCache() {
        return this.cm.getMaxPstmtJumpCache();
    }

    public long getTotalPstmtFreedInCache() {
        return this.cm.getTotalPstmtFreedInCache();
    }

    public long getTotalPstmtCreatedOutOfCache() {
        return this.cm.getTotalPstmtCreatedOutOfCache();
    }
}

